/*
 * generated by Xtext
 */
package org.eclipse.papyrusrt.xtumlrt.xtext.formatting2;

import com.google.inject.Inject;
import org.eclipse.papyrusrt.xtumlrt.common.AbstractAction;
import org.eclipse.papyrusrt.xtumlrt.common.Annotation;
import org.eclipse.papyrusrt.xtumlrt.common.AnnotationParameter;
import org.eclipse.papyrusrt.xtumlrt.common.Artifact;
import org.eclipse.papyrusrt.xtumlrt.common.Attribute;
import org.eclipse.papyrusrt.xtumlrt.common.Capsule;
import org.eclipse.papyrusrt.xtumlrt.common.CapsulePart;
import org.eclipse.papyrusrt.xtumlrt.common.Connector;
import org.eclipse.papyrusrt.xtumlrt.common.ConnectorEnd;
import org.eclipse.papyrusrt.xtumlrt.common.Dependency;
import org.eclipse.papyrusrt.xtumlrt.common.Entity;
import org.eclipse.papyrusrt.xtumlrt.common.Enumeration;
import org.eclipse.papyrusrt.xtumlrt.common.EnumerationLiteral;
import org.eclipse.papyrusrt.xtumlrt.common.Model;
import org.eclipse.papyrusrt.xtumlrt.common.NamedElement;
import org.eclipse.papyrusrt.xtumlrt.common.Operation;
import org.eclipse.papyrusrt.xtumlrt.common.Parameter;
import org.eclipse.papyrusrt.xtumlrt.common.Port;
import org.eclipse.papyrusrt.xtumlrt.common.Protocol;
import org.eclipse.papyrusrt.xtumlrt.common.ProtocolBehaviourFeature;
import org.eclipse.papyrusrt.xtumlrt.common.Signal;
import org.eclipse.papyrusrt.xtumlrt.common.StructuredType;
import org.eclipse.papyrusrt.xtumlrt.common.TypeDefinition;
import org.eclipse.papyrusrt.xtumlrt.interactions.Interaction;
import org.eclipse.papyrusrt.xtumlrt.interactions.InteractionFragment;
import org.eclipse.papyrusrt.xtumlrt.interactions.Lifeline;
import org.eclipse.papyrusrt.xtumlrt.interactions.Message;
import org.eclipse.papyrusrt.xtumlrt.statemach.ActionChain;
import org.eclipse.papyrusrt.xtumlrt.statemach.ChoicePoint;
import org.eclipse.papyrusrt.xtumlrt.statemach.CompositeState;
import org.eclipse.papyrusrt.xtumlrt.statemach.EntryPoint;
import org.eclipse.papyrusrt.xtumlrt.statemach.ExitPoint;
import org.eclipse.papyrusrt.xtumlrt.statemach.Guard;
import org.eclipse.papyrusrt.xtumlrt.statemach.JunctionPoint;
import org.eclipse.papyrusrt.xtumlrt.statemach.State;
import org.eclipse.papyrusrt.xtumlrt.statemach.StateMachine;
import org.eclipse.papyrusrt.xtumlrt.statemach.Transition;
import org.eclipse.papyrusrt.xtumlrt.statemach.Trigger;
import org.eclipse.papyrusrt.xtumlrt.umlrt.AbstractImport;
import org.eclipse.papyrusrt.xtumlrt.umlrt.RTModel;
import org.eclipse.papyrusrt.xtumlrt.xtext.services.UmlrtGrammarAccess;
import org.eclipse.xtext.formatting2.AbstractFormatter2;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.papyrusrt.xtumlrt.common.CommonPackage

class UmlrtFormatter extends AbstractFormatter2 {
	
	@Inject extension UmlrtGrammarAccess

	def commonFormatting(NamedElement element, extension IFormattableDocument document) {
		if (element.name !== null) {
			element.regionFor.feature(CommonPackage.eINSTANCE.getNamedElement_Name()).surround[oneSpace]
		}
		interior(
			element.regionFor.keyword('{').surround[newLine],
			element.regionFor.keyword('}'),
			[indent]
		)
		//element.append[newLines = 2]
	}

	def dispatch void format(RTModel rtmodel, extension IFormattableDocument document) {
		// TODO: format HiddenRegions around keywords, attributes, cross references, etc. 
		commonFormatting(rtmodel, document)
		for (AbstractImport import : rtmodel.imports) {
			format(import, document);
			import.append[newLine]
		}
		for (Artifact containedArtifact : rtmodel.containedArtifacts) {
			format(containedArtifact, document);
			containedArtifact.append[newLines = 2]
		}
		for (Entity entity : rtmodel.entities) {
			format(entity, document);
			entity.append[newLines = 2]
		}
		for (Protocol protocol : rtmodel.getProtocols()) {
			format(protocol, document);
			protocol.append[newLines = 2]
		}
		for (TypeDefinition typeDefinition : rtmodel.typeDefinitions) {
			format(typeDefinition, document);
			typeDefinition.append[newLines = 2]
		}
		for (org.eclipse.papyrusrt.xtumlrt.common.Package packge : rtmodel.packages) {
			format(packge, document);
			packge.append[newLines = 2]
		}
		for (Interaction interaction : rtmodel.interactions) {
			format(interaction, document);
			interaction.append[newLines = 2]
		}
	}

	def dispatch void format(org.eclipse.papyrusrt.xtumlrt.common.Package packge, extension IFormattableDocument document) {
		// TODO: format HiddenRegions around keywords, attributes, cross references, etc. 
		commonFormatting(packge, document)
		for (Entity entity : packge.entities) {
			format(entity, document);
			entity.append[newLines = 2]
		}
		for (Protocol protocol : packge.protocols) {
			format(protocol, document);
			protocol.append[newLines = 2]
		}
		for (TypeDefinition typeDefinition : packge.typeDefinitions) {
			format(typeDefinition, document);
			typeDefinition.append[newLines = 2]
		}
		for (org.eclipse.papyrusrt.xtumlrt.common.Package subpackge : packge.packages) {
			format(subpackge, document);
			subpackge.append[newLines = 2]
		}
	}

	def dispatch void format(Enumeration enumeration, extension IFormattableDocument document) {
		// TODO: format HiddenRegions around keywords, attributes, cross references, etc. 
		commonFormatting(enumeration, document)
		for (EnumerationLiteral literal : enumeration.literals) {
			format(literal, document);
			literal.append[newLine]
		}
	}

	def dispatch void format(StructuredType structuredtype, extension IFormattableDocument document) {
		// TODO: format HiddenRegions around keywords, attributes, cross references, etc. 
		commonFormatting(structuredtype, document)
		for (Attribute attribute : structuredtype.attributes) {
			format(attribute, document);
			attribute.append[newLine]
		}
		for (Operation operation : structuredtype.operations) {
			format(operation, document);
			operation.append[newLine]
		}
	}

	def dispatch void format(Operation operation, extension IFormattableDocument document) {
		// TODO: format HiddenRegions around keywords, attributes, cross references, etc. 
		commonFormatting(operation, document)
		for (Parameter parameter : operation.parameters) {
			format(parameter, document);
		}
		format(operation.returnType, document);
		format(operation.body, document);
	}

	def dispatch void format(Entity entity, extension IFormattableDocument document) {
		// TODO: format HiddenRegions around keywords, attributes, cross references, etc. 
		format(entity.behaviour, document);
	}

	def dispatch void format(Capsule capsule, extension IFormattableDocument document) {
		// TODO: format HiddenRegions around keywords, attributes, cross references, etc. 
		commonFormatting(capsule, document)
		for (Port port : capsule.ports) {
			format(port, document);
			port.append[newLine]
		}
		for (CapsulePart part : capsule.parts) {
			format(part, document);
			part.append[newLine]
		}
		for (Connector connector : capsule.connectors) {
			format(connector, document);
			connector.append[newLine]
		}
		if (capsule.behaviour !== null) format(capsule.behaviour, document)
	}

	def dispatch void format(Connector connector, extension IFormattableDocument document) {
		// TODO: format HiddenRegions around keywords, attributes, cross references, etc. 
		for (ConnectorEnd ends : connector.getEnds()) {
			format(ends, document);
		}
	}

	def dispatch void format(Protocol protocol, extension IFormattableDocument document) {
		// TODO: format HiddenRegions around keywords, attributes, cross references, etc. 
		commonFormatting(protocol, document)
		for (ProtocolBehaviourFeature protocolBehaviourFeature : protocol.getProtocolBehaviourFeatures()) {
			format(protocolBehaviourFeature, document);
			protocolBehaviourFeature.append[newLine]
		}
	}

	def dispatch void format(Signal signal, extension IFormattableDocument document) {
		// TODO: format HiddenRegions around keywords, attributes, cross references, etc. 
		for (Parameter parameters : signal.getParameters()) {
			format(parameters, document);
		}
	}

	def dispatch void format(StateMachine statemachine, extension IFormattableDocument document) {
		// TODO: format HiddenRegions around keywords, attributes, cross references, etc. 
		commonFormatting(statemachine, document)
		statemachine.append[newLine]
		format(statemachine.top, document);
	}

	def dispatch void format(CompositeState compositestate, extension IFormattableDocument document) {
		// TODO: format HiddenRegions around keywords, attributes, cross references, etc. 
		commonFormatting(compositestate, document)
		format(compositestate.initial, document);
		compositestate.initial.append[newLine]
		format(compositestate.deepHistory, document);
		compositestate.deepHistory.append[newLine]
		for (JunctionPoint junctionPoint : compositestate.junctionPoints) {
			format(junctionPoint, document);
//			junctionPoint.append[newLine]
		}
		for (ChoicePoint choicePoint : compositestate.choicePoints) {
			format(choicePoint, document);
//			choicePoint.append[newLine]
		}
		for (State substate : compositestate.substates) {
			format(substate, document);
			substate.append[newLine]
		}
		for (Transition transition : compositestate.transitions) {
			format(transition, document);
			transition.append[newLine]
		}
	}

	def dispatch void format(State state, extension IFormattableDocument document) {
		// TODO: format HiddenRegions around keywords, attributes, cross references, etc. 
		commonFormatting(state, document)
		format(state.entryAction, document);
		state.entryAction.append[newLine]
		format(state.exitAction, document);
		state.exitAction.append[newLine]
		for (ExitPoint exitPoints : state.exitPoints) {
			format(exitPoints, document);
		}
		for (EntryPoint entryPoints : state.entryPoints) {
			format(entryPoints, document);
		}
	}

	def dispatch void format(Transition transition, extension IFormattableDocument document) {
		// TODO: format HiddenRegions around keywords, attributes, cross references, etc. 
		//commonFormatting(transition, document)
		for (Trigger trigger : transition.triggers) {
			format(trigger, document);
		}
		format(transition.getGuard(), document);
		format(transition.getActionChain(), document);
	}

	def dispatch void format(Trigger trigger, extension IFormattableDocument document) {
		//trigger.regionFor.keyword("triggers").append[setNewLines(0,1,2)]
	}

	def dispatch void format(Guard guard, extension IFormattableDocument document) {
		// TODO: format HiddenRegions around keywords, attributes, cross references, etc. 
		format(guard.getBody(), document);
	}

	def dispatch void format(ActionChain actionchain, extension IFormattableDocument document) {
		// TODO: format HiddenRegions around keywords, attributes, cross references, etc. 
		//actionchain.regionFor.keyword("action").append[setNewLines(0,1,2)]
		for (AbstractAction actions : actionchain.actions) {
			format(actions, document);
		}
	}

	def dispatch void format(Interaction interaction, extension IFormattableDocument document) {
		// TODO: format HiddenRegions around keywords, attributes, cross references, etc. 
		commonFormatting(interaction, document)
		for (Lifeline lifeline : interaction.getLifelines()) {
			format(lifeline, document);
			lifeline.append[newLine]
		}
		for (InteractionFragment fragment : interaction.getFragments()) {
			format(fragment, document);
			fragment.append[newLine]
		}
		for (Message message : interaction.getMessages()) {
			format(message, document);
			message.append[newLine]
		}
	}

	def dispatch void format(TypeDefinition typedefinition, extension IFormattableDocument document) {
		// TODO: format HiddenRegions around keywords, attributes, cross references, etc. 
		format(typedefinition.getType(), document);
	}

	def dispatch void format(Annotation annotation, extension IFormattableDocument document) {
		// TODO: format HiddenRegions around keywords, attributes, cross references, etc. 
		commonFormatting(annotation, document)
		for (AnnotationParameter parameters : annotation.getParameters()) {
			format(parameters, document);
		}
	}

	def dispatch void format(NamedElement namedelement, extension IFormattableDocument document) {
		// TODO: format HiddenRegions around keywords, attributes, cross references, etc. 
		for (Annotation annotations : namedelement.getAnnotations()) {
			format(annotations, document);
		}
		for (Dependency dependencies : namedelement.getDependencies()) {
			format(dependencies, document);
		}
	}
}
