/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.cpp.validation;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrusrt.codegen.cpp.UMLPrettyPrinter;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTGuard;
import org.eclipse.papyrusrt.xtumlrt.external.predefined.UMLRTStateMachProfileUtil;
import org.eclipse.papyrusrt.xtumlrt.trans.TransformValidator;
import org.eclipse.papyrusrt.xtumlrt.util.ContainmentUtils;
import org.eclipse.papyrusrt.xtumlrt.util.DetailedException;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Trigger;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class PreUML2xtumlrtValidator
implements TransformValidator<List<EObject>> {
    @Extension
    private UMLPrettyPrinter prettyPrinter = new UMLPrettyPrinter();

    public MultiStatus validate(List<EObject> context) {
        MultiStatus _xblockexpression = null;
        final MultiStatus status = new MultiStatus("org.eclipse.papyrusrt.codegen", 1, "UML-RT Code Generator Invoked", null);
        for (EObject e : context) {
            TreeIterator _eAllContents = e.eAllContents();
            Procedures.Procedure1<EObject> _function = new Procedures.Procedure1<EObject>(){

                public void apply(EObject it) {
                    PreUML2xtumlrtValidator.this.validateElement(it, status);
                    PreUML2xtumlrtValidator.this.validateDuplicateElement(it, status);
                }
            };
            IteratorExtensions.forEach((Iterator)_eAllContents, (Procedures.Procedure1)_function);
        }
        _xblockexpression = status;
        return _xblockexpression;
    }

    protected void _validateElement(EObject e, MultiStatus result) {
    }

    protected void _validateDuplicateElement(final NamedElement element, MultiStatus result) {
        Functions.Function1<NamedElement, Boolean> _function;
        Namespace _namespace;
        EList _ownedMembers;
        Iterable _filter;
        boolean unique;
        if (element.getNamespace() != null && !Strings.isNullOrEmpty((String)element.getName()) && !(unique = IterableExtensions.isEmpty((Iterable)(_filter = IterableExtensions.filter((Iterable)(_ownedMembers = (_namespace = element.getNamespace()).getOwnedMembers()), (Functions.Function1)(_function = new Functions.Function1<NamedElement, Boolean>(){

            public Boolean apply(NamedElement e) {
                return e != element && e.eClass() == element.eClass() && Objects.equal((Object)e.getName(), (Object)element.getName());
            }
        })))))) {
            String _qualifiedName = element.getQualifiedName();
            String _plus = "More than one element named " + _qualifiedName;
            String _plus_1 = String.valueOf(_plus) + " exist in the same namespace";
            Status status = this.createWarningStatus(_plus_1);
            result.add((IStatus)status);
        }
    }

    protected void _validateDuplicateElement(Object element, MultiStatus result) {
    }

    protected void _validateElement(Constraint o, MultiStatus result) {
        UMLRTGuard guard = UMLRTGuard.getInstance((Constraint)o);
        if (guard != null && !guard.getBodies().containsKey("C++")) {
            String qualifiedName = this.getValidQualifiedName((EObject)o);
            Status status = this.createErrorStatus("Guard " + qualifiedName + " must have C++ specification");
            result.add((IStatus)status);
        }
    }

    protected void _validateElement(MultiplicityElement element, MultiStatus result) {
        ValueSpecification upper;
        ValueSpecification lower = element.getLowerValue();
        if (lower != null) {
            this.validateElement((EObject)lower, result);
        }
        if ((upper = element.getUpperValue()) != null) {
            this.validateElement((EObject)upper, result);
        }
    }

    protected void _validateElement(State state, MultiStatus result) {
        Iterable _allOwningElementsUptoType = ContainmentUtils.getAllOwningElementsUptoType((Element)state, StateMachine.class);
        Functions.Function1<Element, Boolean> _function = new Functions.Function1<Element, Boolean>(){

            public Boolean apply(Element it) {
                return it instanceof State;
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_allOwningElementsUptoType, (Functions.Function1)_function);
        Functions.Function1<Element, State> _function_1 = new Functions.Function1<Element, State>(){

            public State apply(Element it) {
                return (State)it;
            }
        };
        Iterable containingStates = IterableExtensions.map((Iterable)_filter, (Functions.Function1)_function_1);
        Functions.Function1<State, Iterable<Transition>> _function_2 = new Functions.Function1<State, Iterable<Transition>>(){

            public Iterable<Transition> apply(State it) {
                return UMLRTStateMachProfileUtil.getAllOutgoingTransitions((State)it);
            }
        };
        Iterable _map = IterableExtensions.map((Iterable)containingStates, (Functions.Function1)_function_2);
        Iterable allOutgoingTransitionsHierarchy = Iterables.concat((Iterable)_map);
        Iterable _allOutgoingTransitions = UMLRTStateMachProfileUtil.getAllOutgoingTransitions((State)state);
        for (final Transition transition : _allOutgoingTransitions) {
            boolean _not;
            Functions.Function1<Transition, Boolean> _function_3 = new Functions.Function1<Transition, Boolean>(){

                public Boolean apply(Transition it) {
                    return PreUML2xtumlrtValidator.this.conflict(it, transition);
                }
            };
            Iterable otherEquivalentTransitions = IterableExtensions.filter((Iterable)allOutgoingTransitionsHierarchy, (Functions.Function1)_function_3);
            boolean _isEmpty = IterableExtensions.isEmpty((Iterable)otherEquivalentTransitions);
            boolean bl = _not = !_isEmpty;
            if (!_not) continue;
            String qualifiedName = this.getValidQualifiedName((EObject)state);
            String conflictingTransitions = this.prettyPrinter.multiLineListText(otherEquivalentTransitions);
            String _text = this.prettyPrinter.text((NamedElement)transition);
            String _plus = "State " + qualifiedName + " has at least two conflicting (ambiguous) outgoing transitions with the same trigger and guard. \n" + "Transition " + _text;
            String _plus_1 = String.valueOf(_plus) + "conflicts with the following:\n";
            String _plus_2 = String.valueOf(_plus_1) + conflictingTransitions;
            String _plus_3 = String.valueOf(_plus_2) + "\n";
            String _plus_4 = String.valueOf(_plus_3) + "The transition with the deepest source will be selected and the others ignored.\n";
            String _plus_5 = String.valueOf(_plus_4) + "If there is more than one such transitions any one of them will be selected and others will be ignored.\n";
            String _plus_6 = String.valueOf(_plus_5) + "Note that the transitions may have a different source, namely a composite state that contains ";
            String _plus_7 = String.valueOf(_plus_6) + qualifiedName;
            String _plus_8 = String.valueOf(_plus_7) + ".\n";
            Status status = this.createWarningStatus(_plus_8);
            result.add((IStatus)status);
            return;
        }
    }

    private boolean conflict(Transition transition1, Transition transition2) {
        return transition1 != transition2 && this.commonTrigger(transition1, transition2) && this.sameGuard(transition1, transition2);
    }

    private boolean sameGuard(Transition transition1, Transition transition2) {
        Constraint _guard_1;
        boolean _or = false;
        Constraint _guard = transition1.getGuard();
        boolean _equals = Objects.equal((Object)_guard, (Object)(_guard_1 = transition2.getGuard()));
        if (_equals) {
            _or = true;
        } else {
            boolean _equals_1;
            Constraint _guard_2 = transition1.getGuard();
            ValueSpecification _specification = null;
            if (_guard_2 != null) {
                _specification = _guard_2.getSpecification();
            }
            Constraint _guard_3 = transition2.getGuard();
            ValueSpecification _specification_1 = null;
            if (_guard_3 != null) {
                _specification_1 = _guard_3.getSpecification();
            }
            _or = _equals_1 = Objects.equal((Object)_specification, (Object)_specification_1);
        }
        return _or;
    }

    private boolean commonTrigger(Transition transition1, final Transition transition2) {
        EList _triggers = transition1.getTriggers();
        Functions.Function1<Trigger, Boolean> _function = new Functions.Function1<Trigger, Boolean>(){

            public Boolean apply(final Trigger t1) {
                EList _triggers = transition2.getTriggers();
                Functions.Function1<Trigger, Boolean> _function = new Functions.Function1<Trigger, Boolean>(){

                    public Boolean apply(Trigger t2) {
                        return PreUML2xtumlrtValidator.this.equivalentTrigger(t1, t2);
                    }
                };
                return IterableExtensions.exists((Iterable)_triggers, (Functions.Function1)_function);
            }
        };
        return IterableExtensions.exists((Iterable)_triggers, (Functions.Function1)_function);
    }

    private boolean equivalentTrigger(Trigger trigger1, final Trigger trigger2) {
        return Objects.equal((Object)trigger1, (Object)trigger2) || Objects.equal((Object)trigger1.getEvent(), (Object)trigger2.getEvent()) && IterableExtensions.exists((Iterable)trigger1.getPorts(), (Functions.Function1)new Functions.Function1<Port, Boolean>(){

            public Boolean apply(Port it) {
                EList _ports = trigger2.getPorts();
                return _ports.contains((Object)it);
            }
        });
    }

    protected Status createErrorStatus(String msg) {
        Status status;
        Status _xblockexpression = null;
        DetailedException exception = new DetailedException(msg);
        String _message = exception.getMessage();
        _xblockexpression = status = new Status(4, "org.eclipse.papyrusrt.codegen", _message, (Throwable)exception);
        return _xblockexpression;
    }

    protected Status createWarningStatus(String msg) {
        Status status;
        Status _xblockexpression = null;
        DetailedException exception = new DetailedException(msg);
        String _message = exception.getMessage();
        _xblockexpression = status = new Status(2, "org.eclipse.papyrusrt.codegen", _message, (Throwable)exception);
        return _xblockexpression;
    }

    protected String getValidQualifiedName(EObject context) {
        String _xblockexpression = null;
        String qualifiedName = "";
        EObject container = context;
        while (container != null) {
            EObject _eContainer;
            if (container instanceof NamedElement) {
                boolean _isNullOrEmpty;
                boolean _notEquals;
                String name = ((NamedElement)container).getName();
                boolean bl = _notEquals = !Objects.equal((Object)qualifiedName, (Object)"");
                if (_notEquals) {
                    qualifiedName = "::" + qualifiedName;
                }
                if (_isNullOrEmpty = Strings.isNullOrEmpty((String)name)) {
                    String _plus_2;
                    EClass _eClass = ((NamedElement)container).eClass();
                    String _name = _eClass.getName();
                    String _plus = "[" + _name;
                    String _plus_1 = String.valueOf(_plus) + "]";
                    qualifiedName = _plus_2 = String.valueOf(_plus_1) + qualifiedName;
                } else {
                    qualifiedName = String.valueOf(name) + qualifiedName;
                }
            }
            container = _eContainer = container.eContainer();
        }
        _xblockexpression = qualifiedName;
        return _xblockexpression;
    }

    protected void validateElement(EObject o, MultiStatus result) {
        if (o instanceof Constraint) {
            this._validateElement((Constraint)o, result);
            return;
        }
        if (o instanceof State) {
            this._validateElement((State)o, result);
            return;
        }
        if (o instanceof MultiplicityElement) {
            this._validateElement((MultiplicityElement)o, result);
            return;
        }
        if (o != null) {
            this._validateElement(o, result);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(o, result).toString());
    }

    protected void validateDuplicateElement(Object element, MultiStatus result) {
        if (element instanceof NamedElement) {
            this._validateDuplicateElement((NamedElement)element, result);
            return;
        }
        if (element != null) {
            this._validateDuplicateElement(element, result);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(element, result).toString());
    }
}

