/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.ui.databinding;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.services.edit.ui.databinding.PapyrusObservableList;
import org.eclipse.papyrusrt.umlrt.tooling.ui.databinding.IFilteredObservableList;

public class PapyrusRTObservableList
extends PapyrusObservableList
implements IFilteredObservableList {
    private final List<Predicate> filters = new ArrayList<Predicate>(3);

    public PapyrusRTObservableList(List<?> wrappedList, EditingDomain domain, EObject source, EStructuralFeature feature) {
        super(wrappedList, domain, source, feature, GMFtoEMFCommandWrapper::wrap);
    }

    public boolean addFilter(Predicate filter) {
        boolean result;
        boolean bl = result = !this.filters.contains(filter) && this.filters.add(filter);
        if (result) {
            this.refreshCacheList();
        }
        return result;
    }

    public boolean removeFilter(Predicate filter) {
        boolean result = this.filters.remove(filter);
        if (result) {
            this.refreshCacheList();
        }
        return result;
    }

    protected void refreshCacheList() {
        if (this.filters.isEmpty()) {
            super.refreshCacheList();
        } else if (!this.isDisposed()) {
            this.wrappedList.clear();
            Stream toAdd = this.concreteList.stream();
            for (Predicate next : this.filters) {
                toAdd = toAdd.filter(next);
            }
            toAdd.forEach(this.wrappedList::add);
            this.fireListChange(null);
        }
    }
}

