/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.ui.databinding.properties;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IDiff;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListDiff;
import org.eclipse.core.databinding.observable.list.ListDiffEntry;
import org.eclipse.core.databinding.observable.list.ListDiffVisitor;
import org.eclipse.core.databinding.property.INativePropertyListener;
import org.eclipse.core.databinding.property.IProperty;
import org.eclipse.core.databinding.property.ISimplePropertyListener;
import org.eclipse.core.databinding.property.SimplePropertyEvent;
import org.eclipse.core.databinding.property.list.SimpleListProperty;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.infra.tools.util.TypeUtils;
import org.eclipse.papyrusrt.umlrt.core.commands.ExclusionCommand;
import org.eclipse.papyrusrt.umlrt.tooling.ui.databinding.IFilteredObservableList;
import org.eclipse.papyrusrt.umlrt.tooling.ui.databinding.properties.IFilteredListProperty;
import org.eclipse.papyrusrt.umlrt.tooling.ui.util.InheritanceUIComparator;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTInheritanceKind;
import org.eclipse.papyrusrt.umlrt.uml.util.UMLRTExtensionUtil;
import org.eclipse.uml2.uml.Element;

public abstract class PapyrusRTListProperty<S, T>
extends SimpleListProperty<S, T>
implements IFilteredListProperty<S, T> {
    protected final Class<T> elementType;
    protected final EStructuralFeature sourceFeature;
    protected final EStructuralFeature feature;
    private List<T> listView;

    public PapyrusRTListProperty(Class<T> elementType, EStructuralFeature sourceFeature, EStructuralFeature feature) {
        this.elementType = elementType;
        this.sourceFeature = sourceFeature;
        this.feature = feature;
    }

    public Object getElementType() {
        return this.elementType;
    }

    public abstract String getPropertyName();

    @Override
    public IObservableList<T> observe(Realm realm, S source) {
        return IFilteredObservableList.wrap(super.observe(realm, source));
    }

    protected List<T> doGetList(S source) {
        if (this.listView == null) {
            Stream<T> elements = this.stream(source);
            this.listView = elements.sorted(this.inheritanceComparator()).collect(Collectors.toList());
        }
        return this.listView;
    }

    protected Stream<T> stream(S source) {
        EContentsEList result = UMLRTExtensionUtil.getUMLRTContents((EObject)this.unwrapSource(source), (EStructuralFeature)this.sourceFeature, (EStructuralFeature[])new EStructuralFeature[0]);
        return result.stream();
    }

    protected UMLRTInheritanceKind getInheritanceKindOf(T element) {
        return UMLRTInheritanceKind.of((Element)this.unwrap(element));
    }

    protected Comparator<T> inheritanceComparator() {
        return Comparator.comparing(this::unwrap, new InheritanceUIComparator());
    }

    protected EList<T> eList(S source) {
        return this.eList((EObject)source, this.sourceFeature);
    }

    protected abstract Element unwrapSource(S var1);

    protected abstract Element unwrap(T var1);

    protected abstract Object wrap(Element var1);

    protected <E> EList<E> eList(Element uml) {
        return this.eList(this.umlOwner(uml), this.feature);
    }

    protected EObject umlOwner(Element uml) {
        return uml;
    }

    private <E> EList<E> eList(EObject source, EStructuralFeature feature) {
        return (EList)source.eGet(feature);
    }

    protected void doSetList(S source, List<T> list, ListDiff<T> diff) {
        TransactionalEditingDomain domain;
        CompositeTransactionalCommand command;
        List<ICommand> commands = this.getCommands(source, diff);
        if (!commands.isEmpty() && (command = new CompositeTransactionalCommand(domain = TransactionUtil.getEditingDomain((EObject)this.unwrapSource(source)), "Edit " + this.getPropertyName(), commands)).canExecute()) {
            domain.getCommandStack().execute(GMFtoEMFCommandWrapper.wrap((ICommand)command.reduce()));
            this.listView = null;
            this.doGetList(source);
        }
    }

    public INativePropertyListener<S> adaptListener(ISimplePropertyListener<S, ListDiff<T>> listener) {
        return new NativeListener(listener);
    }

    protected List<? extends ICommand> getCommands(final S source, ListDiff<T> diff) {
        final TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)this.unwrapSource(source));
        final ArrayList result = new ArrayList();
        diff.accept(new ListDiffVisitor<T>(){

            public void handleMove(int oldIndex, int newIndex, final T element) {
                EList newContainment;
                Element elementAtOldPosition = PapyrusRTListProperty.this.unwrap(PapyrusRTListProperty.this.listView.get(oldIndex));
                Element elementAtNewPosition = PapyrusRTListProperty.this.unwrap(PapyrusRTListProperty.this.listView.get(newIndex));
                EList containment = (EList)elementAtOldPosition.eContainer().eGet((EStructuralFeature)elementAtOldPosition.eContainmentFeature());
                if (containment == (newContainment = (EList)elementAtNewPosition.eContainer().eGet((EStructuralFeature)elementAtNewPosition.eContainmentFeature()))) {
                    oldIndex = containment.indexOf((Object)elementAtOldPosition);
                    newIndex = containment.indexOf((Object)elementAtNewPosition);
                    if (oldIndex >= 0 && newIndex >= 0) {
                        class MoveCommand
                        extends AbstractTransactionalCommand {
                            private EList<?> list;
                            private int oldIndex;
                            private int newIndex;

                            MoveCommand(TransactionalEditingDomain domain, String label, EList<?> list, int oldIndex, int newIndex) {
                                super(domain, label, MoveCommand.getWorkspaceFiles((EObject)(var1_1).PapyrusRTListProperty.this.unwrapSource(var7_7)));
                                this.list = list;
                                this.oldIndex = oldIndex;
                                this.newIndex = newIndex;
                            }

                            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                                this.list.move(this.newIndex, this.oldIndex);
                                return CommandResult.newOKCommandResult((Object)element);
                            }
                        }
                        result.add(new MoveCommand(domain, "Move " + PapyrusRTListProperty.this.getPropertyName(), containment, oldIndex, newIndex, source));
                    }
                }
            }

            public void handleRemove(int index, T element) {
                switch (PapyrusRTListProperty.this.getInheritanceKindOf(element)) {
                    case INHERITED: 
                    case REDEFINED: {
                        result.add(ExclusionCommand.getExclusionCommand((TransactionalEditingDomain)domain, (Element)PapyrusRTListProperty.this.unwrap(element), (boolean)true));
                        break;
                    }
                    case NONE: {
                        DestroyElementRequest request = new DestroyElementRequest(domain, (EObject)PapyrusRTListProperty.this.unwrap(element), false);
                        IElementEditService edit = ElementEditServiceUtils.getCommandProvider((EObject)PapyrusRTListProperty.this.unwrap(element));
                        ICommand destroy = edit.getEditCommand((IEditCommandRequest)request);
                        result.add(destroy);
                        break;
                    }
                }
            }

            public void handleAdd(int index, T element) {
                final EList list = PapyrusRTListProperty.this.eList(source);
                class AddCommand
                extends AbstractTransactionalCommand {
                    private T element;

                    AddCommand(TransactionalEditingDomain domain, String label, T element) {
                        super(domain, label, AddCommand.getWorkspaceFiles((EObject)(var1_1).PapyrusRTListProperty.this.unwrapSource(var5_5)));
                        this.element = element;
                    }

                    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                        if (!list.contains(this.element)) {
                            PapyrusRTListProperty.this.eList(PapyrusRTListProperty.this.unwrapSource(source)).add((Object)PapyrusRTListProperty.this.unwrap(this.element));
                        }
                        return CommandResult.newOKCommandResult(this.element);
                    }
                }
                result.add(new AddCommand(domain, "Add " + PapyrusRTListProperty.this.getPropertyName(), element));
            }
        });
        return result;
    }

    protected class NativeListener
    extends AdapterImpl
    implements INativePropertyListener<S> {
        private final ISimplePropertyListener<S, ListDiff<T>> listener;
        private S source;

        protected NativeListener(ISimplePropertyListener<S, ListDiff<T>> listener) {
            this.listener = listener;
        }

        protected final S getSource() {
            return this.source;
        }

        public void addTo(S source) {
            ((Notifier)source).eAdapters().add((Object)this);
            this.source = source;
            this.addToMembers(source);
        }

        public void removeFrom(S source) {
            if (this.source == source) {
                this.removeFromMembers(source);
                ((Notifier)source).eAdapters().remove((Object)this);
                this.source = null;
            }
        }

        protected void addToMembers(S source) {
            PapyrusRTListProperty.this.eList(source).forEach(this::addToElement);
        }

        protected void removeFromMembers(S source) {
            PapyrusRTListProperty.this.eList(source).forEach(this::removeFromElement);
        }

        protected void addToElement(T element) {
            this.addAdapter((Notifier)PapyrusRTListProperty.this.unwrap(element));
        }

        protected void addAdapter(Notifier notifier) {
            EList adapters = notifier.eAdapters();
            if (!adapters.contains((Object)this)) {
                adapters.add(this);
            }
        }

        protected void removeFromElement(T element) {
            this.removeAdapter((Notifier)PapyrusRTListProperty.this.unwrap(element));
        }

        protected void removeAdapter(Notifier notifier) {
            notifier.eAdapters().remove((Object)this);
        }

        public void notifyChanged(Notification msg) {
            List<Object> added = Collections.emptyList();
            List<Object> removed = Collections.emptyList();
            List changed = Collections.emptyList();
            if (PapyrusRTListProperty.this.listView != null && !msg.isTouch()) {
                Object affected;
                if (msg.getNotifier() == this.source && msg.getFeature() == PapyrusRTListProperty.this.sourceFeature) {
                    switch (msg.getEventType()) {
                        case 3: {
                            Object newElement = PapyrusRTListProperty.this.elementType.cast(msg.getNewValue());
                            this.addToElement(newElement);
                            added = Collections.singletonList(newElement);
                            break;
                        }
                        case 5: {
                            List<Object> newElements = (List<Object>)msg.getNewValue();
                            newElements.forEach(this::addToElement);
                            added = newElements;
                            break;
                        }
                        case 4: {
                            Object oldElement = PapyrusRTListProperty.this.elementType.cast(msg.getOldValue());
                            this.removeFromElement(oldElement);
                            removed = Collections.singletonList(oldElement);
                            break;
                        }
                        case 6: {
                            List<Object> oldElements = (List<Object>)msg.getOldValue();
                            oldElements.forEach(this::removeFromElement);
                            removed = oldElements;
                            break;
                        }
                        case 7: {
                            Object movedElement = PapyrusRTListProperty.this.elementType.cast(msg.getNewValue());
                            removed = Collections.singletonList(movedElement);
                            added = Collections.singletonList(movedElement);
                            break;
                        }
                        case 1: 
                        case 9: {
                            Object newElement = PapyrusRTListProperty.this.elementType.cast(msg.getNewValue());
                            this.addToElement(newElement);
                            Object oldElement = PapyrusRTListProperty.this.elementType.cast(msg.getOldValue());
                            this.removeFromElement(oldElement);
                            removed = Collections.singletonList(oldElement);
                            added = Collections.singletonList(newElement);
                        }
                    }
                } else if (!(msg.getNotifier() == this.source && this.handleAdditionalFeature(msg) || (affected = this.getAffectedElement(msg)) == null)) {
                    changed = Collections.singletonList(affected);
                }
            }
            if (!added.isEmpty() || !removed.isEmpty()) {
                ArrayList oldListView = new ArrayList(PapyrusRTListProperty.this.listView);
                PapyrusRTListProperty.this.listView = null;
                ListDiff diff = Diffs.computeListDiff(oldListView, PapyrusRTListProperty.this.doGetList(this.source));
                if (!diff.isEmpty()) {
                    this.listener.handleEvent(new SimplePropertyEvent(SimplePropertyEvent.CHANGE, this.source, (IProperty)PapyrusRTListProperty.this, (IDiff)diff));
                }
            } else if (!changed.isEmpty()) {
                Object changed_ = changed.get(0);
                int position = PapyrusRTListProperty.this.listView.indexOf(changed_);
                if (position >= 0) {
                    this.listener.handleEvent(new SimplePropertyEvent(SimplePropertyEvent.CHANGE, this.source, (IProperty)PapyrusRTListProperty.this, (IDiff)Diffs.createListDiff((ListDiffEntry)Diffs.createListDiffEntry((int)position, (boolean)false, changed_), (ListDiffEntry)Diffs.createListDiffEntry((int)position, (boolean)true, changed_))));
                }
            }
        }

        protected boolean handleAdditionalFeature(Notification notification) {
            return false;
        }

        protected T getAffectedElement(Notification notification) {
            Object result = null;
            if (notification.getNotifier() instanceof Element) {
                result = TypeUtils.as((Object)PapyrusRTListProperty.this.wrap((Element)notification.getNotifier()), PapyrusRTListProperty.this.elementType);
            }
            return result;
        }
    }
}

