/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.views.codesnippet.tabs;

import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.uml.properties.expression.ExpressionList;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.statemachine.Activator;
import org.eclipse.papyrusrt.umlrt.tooling.views.codesnippet.tabs.AbstractCodeSnippetTab;
import org.eclipse.papyrusrt.umlrt.tooling.views.codesnippet.utils.CodeSnippetTabUtil;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTFactory;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTInheritanceKind;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTOpaqueBehavior;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTTransition;
import org.eclipse.swt.graphics.Image;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Transition;

public class TransitionEffectTab
extends AbstractCodeSnippetTab {
    @Override
    public String getTitle() {
        return "Effect";
    }

    @Override
    protected void doSetInput(EObject input) {
        Transition t = CodeSnippetTabUtil.getTransition(input);
        if (t != null && t.getEffect() == input) {
            this.defaultSelection = true;
        }
        this.input = t;
    }

    @Override
    protected Image getImage() {
        UMLRTInheritanceKind inheritance = UMLRTInheritanceKind.NONE;
        Transition transition = (Transition)this.input;
        Behavior effect = transition.getEffect();
        if (effect != null) {
            return this.getLabelProvider().getImage((Object)effect);
        }
        return Activator.getImage((String)Activator.getEffectSmallKey((UMLRTInheritanceKind)inheritance));
    }

    @Override
    protected IObservable getFeatureObservable() {
        if (this.meForFeatureObservable == null) {
            this.meForFeatureObservable = this.rtModelFactory.createFromSource((Object)this.input, null);
        }
        return this.meForFeatureObservable.getObservable("effect");
    }

    @Override
    protected ExpressionList getExpressionObservableList() {
        Transition transition = (Transition)this.input;
        return this.getExpressionList((EObject)transition.getEffect());
    }

    @Override
    protected void commit(ExpressionList.Expression expr) {
        UMLRTTransition transition = UMLRTFactory.createTransition((Transition)((Transition)this.input));
        UMLRTOpaqueBehavior effect = transition.getEffect();
        if (effect == null) {
            effect = transition.createEffect(expr.getLanguage(), expr.getBody());
            effect.setName(this.getTitle());
        } else {
            effect.getBodies().put(expr.getLanguage(), expr.getBody());
        }
    }

    @Override
    protected IObservable getSpecificationObservable() {
        return this.getSpecificationObservable((EObject)((Transition)this.input).getEffect());
    }
}

