/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.uml.internal.facade.impl;

import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrusrt.umlrt.uml.FacadeObject;
import org.eclipse.papyrusrt.umlrt.uml.internal.facade.impl.FacadeObjectEList;
import org.eclipse.papyrusrt.umlrt.uml.internal.facade.impl.FacadeObjectImpl;
import org.eclipse.papyrusrt.umlrt.uml.internal.facade.impl.FacadeType;
import org.eclipse.papyrusrt.umlrt.uml.internal.impl.InternalUMLRTElement;
import org.eclipse.uml2.uml.Element;

class FacadeReference<T extends Element, S extends EObject, R extends FacadeObject, F extends R> {
    private final FacadeType<T, S, ? extends F> type;
    private final int facadeReferenceID;
    private final Class<R> referenceType;
    private final EReference feature;
    private final EReference extension;
    private final EClass metaclass;

    FacadeReference(FacadeType<T, S, ? extends F> type, int facadeReferenceID, Class<R> referenceType, EReference feature, EReference extension, EClass metaclass) {
        this.type = type;
        this.facadeReferenceID = facadeReferenceID;
        this.referenceType = referenceType;
        this.feature = feature;
        this.extension = extension;
        this.metaclass = metaclass;
    }

    FacadeType<T, S, ? extends F> getType() {
        return this.type;
    }

    EClass getEReferenceType() {
        return this.metaclass;
    }

    List<T> getUML(Element element) {
        return (List)element.eGet((EStructuralFeature)this.feature);
    }

    List<T> getExtension(Element element) {
        return !(element instanceof InternalUMLRTElement) ? ECollections.emptyEList() : (List)element.eGet((EStructuralFeature)this.extension);
    }

    Stream<T> getAll(Element element) {
        return this.extension == null ? this.getUML(element).stream().filter(arg_0 -> ((EClass)this.metaclass).isInstance(arg_0)) : Stream.concat(this.getUML(element).stream(), this.getExtension(element).stream()).filter(arg_0 -> ((EClass)this.metaclass).isInstance(arg_0));
    }

    Stream<R> facades(Element element, boolean withExclusions) {
        Stream<FacadeObject> result = this.getAll(element).map(this.type::getFacade).filter(this.referenceType::isInstance).map(this.referenceType::cast);
        if (!withExclusions) {
            Predicate<FacadeObject> isExcluded = FacadeObject::isExcluded;
            Predicate<FacadeObject> notExcluded = isExcluded.negate();
            result = result.filter(notExcluded);
        }
        return result;
    }

    List<R> getFacades(FacadeObjectImpl owner, boolean withExclusions) {
        return (List)this.facades(owner.toUML(), withExclusions).collect(Collectors.collectingAndThen(Collectors.toList(), list -> this.elist(owner, (List<R>)list)));
    }

    private EList<R> elist(FacadeObjectImpl owner, List<R> list) {
        return new FacadeObjectEList<R>(owner, this.referenceType, this.facadeReferenceID, list);
    }

    List<R> getFacades(FacadeObjectImpl owner, boolean withExclusions, UnaryOperator<R> andThen) {
        return (List)this.facades(owner.toUML(), withExclusions).map(andThen).collect(Collectors.collectingAndThen(Collectors.toList(), list -> this.elist(owner, (List<R>)list)));
    }

    List<R> getFacades(FacadeObjectImpl owner) {
        return this.getFacades(owner, false);
    }

    List<R> getFacades(FacadeObjectImpl owner, UnaryOperator<R> andThen) {
        return this.getFacades(owner, false, andThen);
    }

    public String toString() {
        return String.format("FacadeReference(name=%s, type=%s)", this.feature.getName(), this.type);
    }

    static class Indirect<T extends Element, S extends EObject, R extends FacadeObject, F extends R>
    extends FacadeReference<T, S, R, F> {
        private final Function<? super Element, ? extends Element> indirection;

        Indirect(FacadeType<T, S, ? extends F> type, int facadeReferenceID, Class<R> referenceType, EReference feature, EReference extension, EClass metaclass, Function<? super Element, ? extends Element> indirection) {
            super(type, facadeReferenceID, referenceType, feature, extension, metaclass);
            this.indirection = indirection;
        }

        @Override
        List<T> getUML(Element element) {
            Element owner = this.indirection.apply((Element)element);
            return owner == null ? ECollections.emptyEList() : super.getUML(owner);
        }

        @Override
        List<T> getExtension(Element element) {
            Element owner = this.indirection.apply((Element)element);
            return owner == null ? ECollections.emptyEList() : super.getExtension(owner);
        }
    }
}

