/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.uml.internal.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.papyrusrt.umlrt.uml.internal.impl.InternalUMLRTElement;
import org.eclipse.papyrusrt.umlrt.uml.internal.util.InheritableEList;
import org.eclipse.papyrusrt.umlrt.uml.internal.util.InheritableEcoreEList;
import org.eclipse.papyrusrt.umlrt.uml.internal.util.NotificationForwarder;

public abstract class InheritableEObjectEList<E extends EObject>
extends InheritableEcoreEList<E>
implements InheritableEList<E>,
Adapter {
    private static final long serialVersionUID = 1L;

    public InheritableEObjectEList(InternalEObject owner, int featureID) {
        super(owner, featureID);
    }

    protected abstract E createRedefinition(E var1);

    @Override
    protected NotificationChain setInherited(List<E> elements, NotificationChain msgs) {
        if (!this.isEmpty()) {
            this.clear();
        }
        this.doAddAllUnique(elements);
        if (this.hasNavigableInverse() || this.isContainment()) {
            int inverseID = this.hasNavigableInverse() ? this.getInverseFeatureID() : -1 - this.getFeatureID();
            for (EObject next : elements) {
                msgs = ((InternalEObject)next).eInverseAdd(this.owner, inverseID, null, msgs);
            }
        }
        if (this.isNotificationRequired()) {
            int i = 0;
            while (i < elements.size()) {
                EObject next;
                next = (EObject)elements.get(i);
                ENotificationImpl notif = new ENotificationImpl(this.owner, 9, this.getEStructuralFeature(), (Object)next, (Object)next, i);
                if (msgs == null) {
                    msgs = notif;
                } else {
                    msgs.add((Notification)notif);
                }
                ++i;
            }
        }
        return msgs;
    }

    @Override
    protected E redefineSingle(E inherited) {
        return this.createRedefinition(inherited);
    }

    @Override
    protected List<E> redefineMany(List<E> inherited) {
        int count = inherited.size();
        ArrayList<EObject> result = new ArrayList<EObject>(count);
        List existing = this.delegateList();
        int i = 0;
        while (i < count) {
            if (i >= existing.size()) break;
            EObject next = (EObject)existing.get(i);
            result.add(next);
            if (this.isContainment() && next instanceof InternalUMLRTElement) {
                ((InternalUMLRTElement)next).rtUnsetAll();
            }
            ++i;
        }
        while (i < count) {
            result.add(this.createRedefinition((EObject)inherited.get(i)));
            ++i;
        }
        return result;
    }

    @Override
    protected void redefined(E element) {
        NotificationForwarder.initialize(element);
    }

    @Override
    protected void unredefined(E element) {
        NotificationForwarder.initialize(element);
    }

    public static abstract class Containment<E extends EObject>
    extends InheritableEObjectEList<E> {
        private static final long serialVersionUID = 1L;

        public Containment(InternalEObject owner, int featureID) {
            super(owner, featureID);
        }

        protected boolean hasInverse() {
            return true;
        }

        protected boolean hasNavigableInverse() {
            return false;
        }

        protected boolean isContainment() {
            return true;
        }
    }

    public static abstract class Resolving<E extends EObject>
    extends InheritableEObjectEList<E> {
        private static final long serialVersionUID = 1L;

        public Resolving(InternalEObject owner, int featureID) {
            super(owner, featureID);
        }

        protected abstract E resolveInheritance(E var1);

        protected abstract E unresolveInheritance(E var1);

        @Override
        protected E createRedefinition(E inherited) {
            return this.resolveInheritance(inherited);
        }

        public void addUnique(E object) {
            super.addUnique(this.unresolveInheritance((T)object));
        }

        public void addUnique(int index, E object) {
            super.addUnique(index, this.unresolveInheritance((T)object));
        }

        public boolean addAllUnique(Collection<? extends E> collection) {
            return super.addAllUnique(this.unresolveInheritance((T)collection));
        }

        protected final <T> Collection<T> unresolveInheritance(Collection<T> collection) {
            return collection.stream().map(this::unresolveInheritance).collect(Collectors.toList());
        }

        public boolean addAllUnique(int index, Collection<? extends E> collection) {
            return super.addAllUnique(index, this.unresolveInheritance((T)collection));
        }

        public boolean addAllUnique(Object[] objects, int start, int end) {
            return super.addAllUnique(this.unresolveInheritance(objects, start, end));
        }

        protected final Collection<E> unresolveInheritance(Object[] objects, int start, int end) {
            ArrayList<EObject> result = new ArrayList<EObject>(end - start);
            int i = start;
            while (i < end) {
                result.add(this.unresolveInheritance((T)((EObject)objects[i])));
                ++i;
            }
            return result;
        }

        public boolean addAllUnique(int index, Object[] objects, int start, int end) {
            return super.addAllUnique(index, this.unresolveInheritance(objects, start, end));
        }

        public E setUnique(int index, E object) {
            return (E)((EObject)super.setUnique(index, this.unresolveInheritance((T)object)));
        }

        public E get(int index) {
            return (E)this.resolveInheritance((EObject)super.get(index));
        }

        public int indexOf(Object object) {
            return super.indexOf(this.unresolveInheritance((T)object));
        }

        protected final <T> T unresolveInheritance(T object) {
            return (T)(this.isInstance(object) ? this.unresolveInheritance((T)((EObject)object)) : object);
        }

        public boolean contains(Object object) {
            return super.contains(this.unresolveInheritance((T)object));
        }

        public boolean containsAll(Collection<?> collection) {
            return super.containsAll(this.unresolveInheritance((T)collection));
        }

        protected boolean useEquals() {
            return false;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof List)) {
                return false;
            }
            List list = (List)object;
            int size = this.size();
            if (list.size() != size) {
                return false;
            }
            Iterator other = list.iterator();
            int i = 0;
            while (i < size) {
                if (this.get(i) != other.next()) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        public int hashCode() {
            return Objects.hash(this.toArray());
        }

        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            int i = 0;
            while (i < size) {
                result[i] = this.get(i);
                ++i;
            }
            return result;
        }

        public <T> T[] toArray(T[] array) {
            int size = this.size();
            T[] result = array.length >= size ? array : (Object[])Array.newInstance(array.getClass().getComponentType(), size);
            int i = 0;
            while (i < size) {
                result[i] = this.get(i);
                ++i;
            }
            if (result.length > size) {
                result[size] = null;
            }
            return result;
        }

        public String toString() {
            return this.stream().map(String::valueOf).collect(Collectors.joining(", ", "[", "]"));
        }
    }
}

