/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.xtumlrt.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrusrt.xtumlrt.common.NamedElement;
import org.eclipse.papyrusrt.xtumlrt.util.ContainmentUtils;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;

public final class NamesUtil {
    private static final NamesUtil INSTANCE = new NamesUtil();
    private static final String NAME_FEATURE = "name";
    private static final String SEPARATOR = "::";
    private final HashMap<ArrayList<?>, String> _createCache_cachedEffectiveName = CollectionLiterals.newHashMap((Pair[])new Pair[0]);

    public static boolean isNamedElement(EObject element) {
        boolean _xifexpression = false;
        if (element != null) {
            boolean _or = false;
            if (element instanceof ENamedElement || element instanceof NamedElement || element instanceof org.eclipse.uml2.uml.NamedElement) {
                _or = true;
            } else {
                EClass _eClass = element.eClass();
                EList _eAllStructuralFeatures = null;
                if (_eClass != null) {
                    _eAllStructuralFeatures = _eClass.getEAllStructuralFeatures();
                }
                boolean _contains = false;
                if (_eAllStructuralFeatures != null) {
                    _contains = _eAllStructuralFeatures.contains((Object)NAME_FEATURE);
                }
                _or = _contains;
            }
            _xifexpression = _or;
        } else {
            _xifexpression = false;
        }
        return _xifexpression;
    }

    public static String basicGetName(EObject element) {
        String _xblockexpression = null;
        EClass _eClass = null;
        if (element != null) {
            _eClass = element.eClass();
        }
        EStructuralFeature _eStructuralFeature = null;
        if (_eClass != null) {
            _eStructuralFeature = _eClass.getEStructuralFeature(NAME_FEATURE);
        }
        EStructuralFeature nameFeature = _eStructuralFeature;
        String _xifexpression = null;
        if (nameFeature != null) {
            String _xblockexpression_1 = null;
            Object _eGet = null;
            if (element != null) {
                _eGet = element.eGet(nameFeature);
            }
            Object nameValue = _eGet;
            String _xifexpression_1 = null;
            _xifexpression_1 = nameValue instanceof String ? (String)nameValue : null;
            _xifexpression = _xblockexpression_1 = _xifexpression_1;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public static boolean hasName(EObject element) {
        boolean _xifexpression = false;
        boolean _isNamedElement = NamesUtil.isNamedElement(element);
        if (_isNamedElement) {
            boolean _xblockexpression = false;
            String name = NamesUtil.basicGetName(element);
            _xifexpression = _xblockexpression = name != null && !name.trim().isEmpty();
        } else {
            _xifexpression = false;
        }
        return _xifexpression;
    }

    public static String getEffectiveName(EObject element) {
        String _xifexpression = null;
        boolean _hasName = NamesUtil.hasName(element);
        if (_hasName) {
            _xifexpression = NamesUtil.basicGetName(element);
        } else {
            String _xblockexpression = null;
            EObject container = element.eContainer();
            String _xifexpression_1 = null;
            if (container == null) {
                EClass _eClass = element.eClass();
                _xifexpression_1 = _eClass.getName();
            } else {
                boolean _tripleEquals;
                String _xblockexpression_1 = null;
                EStructuralFeature feature = element.eContainingFeature();
                String _xifexpression_2 = null;
                int _upperBound = feature.getUpperBound();
                boolean bl = _tripleEquals = _upperBound == 1;
                if (_tripleEquals) {
                    String _name = feature.getName();
                    _xifexpression_2 = NamesUtil.singular(_name);
                } else {
                    String _xblockexpression_2 = null;
                    Object featureValue = container.eGet(feature);
                    String _xifexpression_3 = null;
                    if (featureValue instanceof List) {
                        String _name_1 = feature.getName();
                        String _singular = NamesUtil.singular(_name_1);
                        int _indexOf = ((List)featureValue).indexOf(element);
                        _xifexpression_3 = String.valueOf(_singular) + Integer.valueOf(_indexOf);
                    } else {
                        String _name_2 = feature.getName();
                        _xifexpression_3 = String.valueOf(_name_2) + "_value";
                    }
                    _xifexpression_2 = _xblockexpression_2 = _xifexpression_3;
                }
                _xifexpression_1 = _xblockexpression_1 = _xifexpression_2;
            }
            _xifexpression = _xblockexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    public static String getEffectiveQualifiedName(EObject element) {
        Iterable<EObject> _eAllContainers = ContainmentUtils.getEAllContainers(element);
        Functions.Function1<EObject, String> _function = new Functions.Function1<EObject, String>(){

            public String apply(EObject it) {
                return NamesUtil.getEffectiveName(it);
            }
        };
        Iterable _map = IterableExtensions.map(_eAllContainers, (Functions.Function1)_function);
        Functions.Function2<String, String, String> _function_1 = new Functions.Function2<String, String, String>(){

            public String apply(String a, String b) {
                return String.valueOf(a) + NamesUtil.SEPARATOR + b;
            }
        };
        return (String)IterableExtensions.reduce((Iterable)_map, (Functions.Function2)_function_1);
    }

    public static EObject getFirstNamedContainer(EObject element) {
        EObject _xifexpression = null;
        boolean _hasName = NamesUtil.hasName(element);
        if (_hasName) {
            _xifexpression = element;
        } else {
            EObject _eContainer = element.eContainer();
            EObject _firstNamedContainer = null;
            if (_eContainer != null) {
                _firstNamedContainer = NamesUtil.getFirstNamedContainer(_eContainer);
            }
            _xifexpression = _firstNamedContainer;
        }
        return _xifexpression;
    }

    public static String getCachedEffectiveName(EObject element) {
        return INSTANCE.cachedEffectiveName(element);
    }

    public static String singular(String string) {
        String _xifexpression = null;
        if (string != null) {
            boolean _not;
            String _xblockexpression = null;
            String trimmed = string.trim();
            String _xifexpression_1 = null;
            boolean _isEmpty = trimmed.isEmpty();
            boolean bl = _not = !_isEmpty;
            if (_not) {
                String _xblockexpression_1 = null;
                int len = trimmed.length();
                String _xifexpression_2 = null;
                boolean _endsWith = trimmed.endsWith("ies");
                if (_endsWith) {
                    String _substring = trimmed.substring(0, len - 3);
                    _xifexpression_2 = String.valueOf(_substring) + "y";
                } else {
                    String _xifexpression_3 = null;
                    boolean _endsWith_1 = trimmed.endsWith("ves");
                    if (_endsWith_1) {
                        String _substring_1 = trimmed.substring(0, len - 3);
                        _xifexpression_3 = String.valueOf(_substring_1) + "f";
                    } else {
                        String _xifexpression_4 = null;
                        boolean _endsWith_2 = trimmed.endsWith("es");
                        if (_endsWith_2) {
                            _xifexpression_4 = trimmed.substring(0, len - 2);
                        } else {
                            String _xifexpression_5 = null;
                            boolean _endsWith_3 = trimmed.endsWith("s");
                            _xifexpression_5 = _endsWith_3 ? trimmed.substring(0, len - 1) : trimmed;
                            _xifexpression_4 = _xifexpression_5;
                        }
                        _xifexpression_3 = _xifexpression_4;
                    }
                    _xifexpression_2 = _xifexpression_3;
                }
                _xifexpression_1 = _xblockexpression_1 = _xifexpression_2;
            }
            _xifexpression = _xblockexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String cachedEffectiveName(EObject element) {
        String _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new EObject[]{element});
        HashMap<ArrayList<?>, String> hashMap = this._createCache_cachedEffectiveName;
        synchronized (hashMap) {
            if (this._createCache_cachedEffectiveName.containsKey(_cacheKey)) {
                return this._createCache_cachedEffectiveName.get(_cacheKey);
            }
            _result = NamesUtil.getEffectiveName(element);
            this._createCache_cachedEffectiveName.put(_cacheKey, _result);
        }
        this._init_cachedEffectiveName(_result, element);
        return _result;
    }

    private void _init_cachedEffectiveName(String it, EObject element) {
    }
}

