/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.core.types.advice;

import com.google.common.base.Strings;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.SetValueCommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrusrt.umlrt.core.utils.CapsulePartUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.CapsuleUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.ModelUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.NewElementUtil;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.LiteralInteger;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;

public class CapsulePartSetTypeAdvice
extends AbstractEditHelperAdvice {
    public boolean approveRequest(IEditCommandRequest request) {
        if (request instanceof SetRequest) {
            SetRequest setRequest = (SetRequest)request;
            EStructuralFeature feature = setRequest.getFeature();
            if (UMLPackage.eINSTANCE.getTypedElement_Type().equals(feature)) {
                Object newValue = ((SetRequest)request).getValue();
                if (newValue instanceof Classifier) {
                    return CapsuleUtils.isCapsule((Classifier)newValue);
                }
                return false;
            }
            return super.approveRequest((IEditCommandRequest)setRequest);
        }
        return super.approveRequest(request);
    }

    protected ICommand getAfterSetCommand(SetRequest request) {
        CompositeCommand compositeCommand = new CompositeCommand("Set CapsulePart Type");
        EStructuralFeature feature = request.getFeature();
        if (UMLPackage.eINSTANCE.getTypedElement_Type().equals(feature)) {
            Object newValue = request.getValue();
            EObject elementToEdit = request.getElementToEdit();
            if (elementToEdit instanceof Property && newValue instanceof Type) {
                String name;
                Type newType = (Type)newValue;
                Property property = (Property)elementToEdit;
                if (CapsulePartUtils.completesCycle(newType, property)) {
                    LiteralInteger newLowerValue = (LiteralInteger)ModelUtils.create((EObject)property, UMLPackage.Literals.LITERAL_INTEGER);
                    newLowerValue.setValue(0);
                    SetValueCommand setLowerBoundsCommand = new SetValueCommand(new SetRequest(request.getElementToEdit(), (EStructuralFeature)UMLPackage.eINSTANCE.getMultiplicityElement_LowerValue(), (Object)newLowerValue));
                    compositeCommand.add((IUndoableOperation)setLowerBoundsCommand);
                }
                if ((Strings.isNullOrEmpty((String)property.getName()) || NewElementUtil.isCreatedElement((EObject)property)) && !Strings.isNullOrEmpty((String)(name = newType.getName()))) {
                    String newName = NewElementUtil.getUniqueName(property, newType);
                    SetValueCommand setNameCommand = new SetValueCommand(new SetRequest(request.getElementToEdit(), (EStructuralFeature)UMLPackage.eINSTANCE.getNamedElement_Name(), (Object)newName));
                    compositeCommand.add((IUndoableOperation)setNameCommand);
                }
            }
        }
        return compositeCommand.isEmpty() ? super.getAfterSetCommand(request) : compositeCommand;
    }
}

