/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.core.utils;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;

public class MultipleAdapter
extends AdapterImpl {
    private final List<Notifier> targets;

    public MultipleAdapter() {
        this(1);
    }

    public MultipleAdapter(int expectedTargetCount) {
        this.targets = Lists.newArrayListWithExpectedSize((int)expectedTargetCount);
    }

    public void dispose() {
        if (!this.targets.isEmpty()) {
            Notifier[] iterationSafeCopy = (Notifier[])Iterables.toArray(this.targets, Notifier.class);
            int i = 0;
            while (i < iterationSafeCopy.length) {
                iterationSafeCopy[i].eAdapters().remove((Object)this);
                ++i;
            }
        }
    }

    public List<Notifier> getTargets() {
        return Collections.unmodifiableList(this.targets);
    }

    public void setTarget(Notifier newTarget) {
        this.targets.add(newTarget);
    }

    public void unsetTarget(Notifier oldTarget) {
        this.targets.remove(oldTarget);
    }

    public Notifier getTarget() {
        return this.targets.isEmpty() ? null : this.targets.get(0);
    }
}

