/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.core.utils;

import org.eclipse.uml2.uml.LiteralInteger;
import org.eclipse.uml2.uml.LiteralReal;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.LiteralUnlimitedNatural;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;

public class RTPropertyUtils {
    private RTPropertyUtils() {
    }

    public static boolean isReplicated(Property property) {
        return !RTPropertyUtils.isSingular(property.getUpperValue());
    }

    public static boolean isOptional(Property property) {
        return RTPropertyUtils.isZero(property.getLowerValue());
    }

    private static boolean isSingular(ValueSpecification multiplicityBound) {
        boolean result = true;
        if (multiplicityBound != null) {
            boolean bl = result = multiplicityBound.eClass().getEPackage() == UMLPackage.eINSTANCE;
            if (result) {
                switch (multiplicityBound.eClass().getClassifierID()) {
                    case 235: {
                        result = ((LiteralInteger)multiplicityBound).getValue() == 1;
                        break;
                    }
                    case 239: {
                        result = ((LiteralUnlimitedNatural)multiplicityBound).getValue() == 1;
                        break;
                    }
                    case 237: {
                        result = ((LiteralReal)multiplicityBound).getValue() == 1.0;
                        break;
                    }
                    case 238: {
                        result = "1".equals(((LiteralString)multiplicityBound).getValue());
                        break;
                    }
                    case 40: {
                        OpaqueExpression opaqueExpr = (OpaqueExpression)multiplicityBound;
                        result = opaqueExpr.isIntegral() && opaqueExpr.value() == 1;
                        break;
                    }
                    default: {
                        result = false;
                    }
                }
            }
        }
        return result;
    }

    private static boolean isZero(ValueSpecification multiplicityBound) {
        boolean result = false;
        if (multiplicityBound != null) {
            boolean bl = result = multiplicityBound.eClass().getEPackage() == UMLPackage.eINSTANCE;
            if (result) {
                switch (multiplicityBound.eClass().getClassifierID()) {
                    case 235: {
                        result = ((LiteralInteger)multiplicityBound).getValue() == 0;
                        break;
                    }
                    case 239: {
                        result = ((LiteralUnlimitedNatural)multiplicityBound).getValue() == 0;
                        break;
                    }
                    case 237: {
                        result = ((LiteralReal)multiplicityBound).getValue() == 0.0;
                        break;
                    }
                    case 238: {
                        result = "0".equals(((LiteralString)multiplicityBound).getValue());
                        break;
                    }
                    case 40: {
                        OpaqueExpression opaqueExpr = (OpaqueExpression)multiplicityBound;
                        result = opaqueExpr.isIntegral() && opaqueExpr.value() == 0;
                        break;
                    }
                    default: {
                        result = false;
                    }
                }
            }
        }
        return result;
    }
}

