/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.compare.umlrt.internal.accessor;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.ResourceAttachmentChange;
import org.eclipse.emf.compare.rcp.ui.contentmergeviewer.accessor.ICompareAccessor;
import org.eclipse.emf.compare.rcp.ui.contentmergeviewer.accessor.legacy.impl.AbstractTypedElementAdapter;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.item.impl.MergeViewerItem;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.IMergeViewer;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.item.IMergeViewerItem;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.papyrusrt.umlrt.tooling.compare.umlrt.internal.UMLRTDiff;
import org.eclipse.swt.graphics.Image;

public class UMLRTDiffAccessor
extends AbstractTypedElementAdapter
implements ICompareAccessor {
    private final IMergeViewer.MergeViewerSide side;
    private final UMLRTDiff diff;

    public UMLRTDiffAccessor(AdapterFactory adapterFactory, UMLRTDiff diff, IMergeViewer.MergeViewerSide side) {
        super(adapterFactory);
        this.side = side;
        this.diff = diff;
    }

    protected IMergeViewer.MergeViewerSide getSide() {
        return this.side;
    }

    protected UMLRTDiff getUMLRTDiff() {
        return this.diff;
    }

    public ImmutableList<? extends IMergeViewerItem> getItems() {
        ImmutableList.Builder ret = ImmutableList.builder();
        EList matches = this.getComparison().getMatches();
        for (Match match : matches) {
            boolean showSide = this.getSide() != IMergeViewer.MergeViewerSide.ANCESTOR || this.getSide() == IMergeViewer.MergeViewerSide.ANCESTOR && match.getOrigin() != null;
            boolean showMatch = this.checkMatch(match);
            if (!showSide || !showMatch) continue;
            ResourceAttachmentChange diff = (ResourceAttachmentChange)Iterables.getFirst((Iterable)Iterables.filter((Iterable)match.getDifferences(), ResourceAttachmentChange.class), null);
            MergeViewerItem.Container container = new MergeViewerItem.Container(this.getComparison(), (Diff)diff, (Object)match.getLeft(), (Object)match.getRight(), (Object)match.getOrigin(), this.getSide(), this.getRootAdapterFactory());
            ret.add((Object)container);
        }
        return ret.build();
    }

    protected boolean checkMatch(Match match) {
        return this.checkEObject(match.getLeft()) || this.checkEObject(match.getRight()) || this.checkEObject(match.getOrigin());
    }

    protected boolean checkEObject(EObject object) {
        if (object == null) {
            return false;
        }
        return this.diff.getDiscriminant() == object || EcoreUtil.isAncestor((EObject)object, (EObject)this.diff.getDiscriminant());
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public Image getImage() {
        return ExtendedImageRegistry.INSTANCE.getImage(this.getItemDelegator().getImage((Object)this.diff.getDiscriminant()));
    }

    public String getType() {
        return "org.eclipse.emf.compare.rcp.ui.eTreeDiff";
    }

    public Comparison getComparison() {
        return this.diff.getMatch().getComparison();
    }

    public IMergeViewerItem getInitialItem() {
        Diff diffToReturn = this.getInitialDiff(this.getUMLRTDiff());
        Match match = null;
        if (ReferenceChange.class.isInstance(diffToReturn)) {
            match = this.getComparison().getMatch(((ReferenceChange)ReferenceChange.class.cast(diffToReturn)).getValue());
        }
        if (match == null) {
            match = this.diff.getMatch();
        }
        return new MergeViewerItem.Container(this.getComparison(), diffToReturn, match, this.getSide(), this.getRootAdapterFactory());
    }

    private Diff getInitialDiff(UMLRTDiff diff) {
        for (Diff refBy : diff.getRefinedBy()) {
            ReferenceChange rc;
            if (!(refBy instanceof ReferenceChange) || !(rc = (ReferenceChange)refBy).getReference().isContainment() || diff.getDiscriminant() != rc.getValue()) continue;
            return rc;
        }
        return diff;
    }
}

