/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.views.codesnippet.tabs;

import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.uml.properties.expression.ExpressionList;
import org.eclipse.papyrusrt.umlrt.core.utils.ModelUtils;
import org.eclipse.papyrusrt.umlrt.tooling.views.codesnippet.tabs.AbstractCodeSnippetTab;
import org.eclipse.papyrusrt.umlrt.tooling.views.codesnippet.utils.CodeSnippetTabUtil;
import org.eclipse.swt.graphics.Image;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.UMLPackage;

public class OperationTab
extends AbstractCodeSnippetTab {
    @Override
    public String getTitle() {
        return "Operation";
    }

    @Override
    protected void doSetInput(EObject input) {
        this.input = CodeSnippetTabUtil.getOperation(input);
    }

    @Override
    protected Image getImage() {
        Operation op = (Operation)this.input;
        if (!op.getMethods().isEmpty()) {
            return this.getLabelProvider().getImage(op.getMethods().get(0));
        }
        return null;
    }

    @Override
    protected IObservable getFeatureObservable() {
        if (this.meForFeatureObservable == null) {
            this.meForFeatureObservable = this.rtModelFactory.createFromSource((Object)this.input, null);
        }
        return this.meForFeatureObservable.getObservable("method");
    }

    @Override
    protected ExpressionList getExpressionObservableList() {
        Operation op = (Operation)this.input;
        if (!op.getMethods().isEmpty()) {
            return this.getExpressionList((EObject)op.getMethods().get(0));
        }
        return null;
    }

    @Override
    protected void commit(ExpressionList.Expression expr) {
        Operation op = (Operation)this.input;
        Class container = (Class)this.input.eContainer();
        if (op.getMethods().isEmpty()) {
            OpaqueBehavior ob = (OpaqueBehavior)ModelUtils.create((EObject)container, (EClass)UMLPackage.Literals.OPAQUE_BEHAVIOR);
            ob.getBodies().add((Object)expr.getBody());
            ob.getLanguages().add((Object)expr.getLanguage());
            container.getOwnedBehaviors().add((Object)ob);
            op.getMethods().add((Object)ob);
        } else {
            OpaqueBehavior ob = (OpaqueBehavior)op.getMethods().get(0);
            int index = ob.getLanguages().indexOf((Object)expr.getLanguage());
            if (index == -1) {
                ob.getLanguages().add((Object)expr.getLanguage());
                index = ob.getLanguages().size() - 1;
            }
            int numFillBody = ob.getLanguages().size() - ob.getBodies().size();
            while (numFillBody-- > 0) {
                ob.getBodies().add((Object)"");
            }
            ob.getBodies().set(index, (Object)expr.getBody());
        }
    }

    @Override
    protected IObservable getSpecificationObservable() {
        Operation op = (Operation)this.input;
        if (!op.getMethods().isEmpty()) {
            return this.getSpecificationObservable((EObject)op.getMethods().get(0));
        }
        return null;
    }
}

