/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.uml.internal.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import org.eclipse.emf.common.util.AbstractEList;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.papyrusrt.umlrt.uml.internal.impl.InternalUMLRTElement;
import org.eclipse.papyrusrt.umlrt.uml.internal.util.NotificationForwarder;
import org.eclipse.papyrusrt.umlrt.uml.internal.util.RedefinedElementsList;
import org.eclipse.uml2.uml.RedefinableElement;

public class RedefinedElementsListImpl<E extends RedefinableElement>
extends EObjectResolvingEList<E>
implements RedefinedElementsList<E> {
    private static final long serialVersionUID = 1L;
    private final Consumer<? super E> onRedefinition;

    public RedefinedElementsListImpl(Class<?> dataClass, InternalUMLRTElement owner, int featureID) {
        this(dataClass, owner, featureID, null);
    }

    public RedefinedElementsListImpl(Class<?> dataClass, InternalUMLRTElement owner, int featureID, Consumer<? super E> onRedefinition) {
        super(dataClass, (InternalEObject)owner, featureID);
        this.onRedefinition = onRedefinition;
    }

    @Override
    public InternalUMLRTElement getRedefinableOwner() {
        return (InternalUMLRTElement)this.getEObject();
    }

    @Override
    public void setRedefinedElement(E redefinedElement) {
        if (redefinedElement == null) {
            if (!this.isEmpty()) {
                this.clear();
            }
        } else if (this.isEmpty()) {
            this.add(redefinedElement);
        } else {
            this.set(0, redefinedElement);
        }
    }

    protected void didAdd(int index, E newObject) {
        super.didAdd(index, newObject);
        InternalUMLRTElement owner = this.getRedefinableOwner();
        if (this.size() == 1 && NotificationForwarder.getInstance(owner) == null) {
            Collection<? extends EStructuralFeature> inherited = owner.rtInheritedFeatures();
            NotificationForwarder.adapt(owner, () -> new NotificationForwarder(owner, (EReference)this.getEStructuralFeature(), inherited));
            if (this.onRedefinition != null) {
                this.onRedefinition.accept(newObject);
            }
        }
    }

    protected void didRemove(int index, E oldObject) {
        super.didRemove(index, oldObject);
        if (this.size() == 0) {
            NotificationForwarder.unadapt(this.getRedefinableOwner());
            if (this.onRedefinition != null) {
                this.onRedefinition.accept(null);
            }
        }
    }

    public E basicGet(int index) {
        RedefinableElement result = (RedefinableElement)super.basicGet(index);
        if (result instanceof InternalUMLRTElement) {
            result = (RedefinableElement)((InternalUMLRTElement)result).rtGetNearestRealDefinition();
        }
        return (E)result;
    }

    public List<E> basicList() {
        return this.isEmpty() ? ECollections.emptyEList() : new BasicEList.UnmodifiableEList(this.size(), IntStream.range(0, this.size()).mapToObj(this::basicGet).toArray());
    }

    public Iterator<E> basicIterator() {
        return new BasicIterator();
    }

    public ListIterator<E> basicListIterator() {
        return new BasicIterator();
    }

    public ListIterator<E> basicListIterator(int index) {
        return new BasicIterator(index);
    }

    protected class BasicIterator
    extends AbstractEList.NonResolvingEListIterator<E> {
        public BasicIterator() {
            super((AbstractEList)RedefinedElementsListImpl.this);
        }

        public BasicIterator(int index) {
            super((AbstractEList)RedefinedElementsListImpl.this, index);
        }

        protected E doNext() {
            try {
                Object next = RedefinedElementsListImpl.this.basicGet(this.cursor);
                this.checkModCount();
                this.lastCursor = this.cursor++;
                return next;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.checkModCount();
                throw new NoSuchElementException();
            }
        }
    }
}

