/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.cpp.structure.model;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.papyrusrt.codegen.CodeGenPlugin;
import org.eclipse.papyrusrt.codegen.cpp.structure.model.Controller;
import org.eclipse.papyrusrt.codegen.instance.model.ICapsuleInstance;

public class ControllerAllocations {
    public static final ControllerAllocations DEFAULT = new ControllerAllocations(){

        @Override
        public String getController(ICapsuleInstance capsule) {
            return "DefaultController";
        }
    };
    private final Map<String, String> allocations = new HashMap<String, String>();
    private final List<Controller> controllers = new ArrayList<Controller>();

    public Iterable<Controller> getControllers() {
        return this.controllers;
    }

    public static ControllerAllocations load(File allocationsFile) {
        if (allocationsFile == null || !allocationsFile.exists()) {
            return null;
        }
        Properties properties = new Properties();
        FileReader reader = null;
        try {
            try {
                reader = new FileReader(allocationsFile);
                properties.load(reader);
            }
            catch (IOException e) {
                CodeGenPlugin.error((Throwable)e);
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e2) {
                        CodeGenPlugin.error((Throwable)e2);
                    }
                }
                return null;
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    CodeGenPlugin.error((Throwable)e);
                }
            }
        }
        HashSet<String> controllerNames = new HashSet<String>();
        ControllerAllocations allocs = new ControllerAllocations();
        for (String key : properties.stringPropertyNames()) {
            String controllerName = properties.getProperty(key);
            allocs.allocations.put(key, controllerName);
            if (!controllerNames.add(controllerName)) continue;
            allocs.controllers.add(new Controller(controllerName));
        }
        return allocs;
    }

    public String getController(ICapsuleInstance capsule) {
        String controllerName = this.allocations.get(capsule.getQualifiedName('.'));
        if (controllerName != null) {
            return controllerName;
        }
        String typeName = capsule.getType().getName();
        controllerName = this.allocations.get(typeName);
        if (controllerName != null) {
            return controllerName;
        }
        return null;
    }
}

