/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.lang.cpp.expr;

import org.eclipse.papyrusrt.codegen.lang.cpp.Expression;
import org.eclipse.papyrusrt.codegen.lang.cpp.Type;
import org.eclipse.papyrusrt.codegen.lang.cpp.dep.DependencyList;
import org.eclipse.papyrusrt.codegen.lang.cpp.expr.ExpressionList;
import org.eclipse.papyrusrt.codegen.lang.cpp.internal.CppFormatter;

public class BlockInitializer
extends Expression {
    private final Type type;
    protected ExpressionList exprs = new ExpressionList(new Expression[0]);

    public BlockInitializer(Type type) {
        this.type = type;
    }

    public BlockInitializer(Type type, Expression ... exprs) {
        this.type = type;
        this.exprs.addAll(exprs);
    }

    public void addExpression(Expression expr) {
        this.exprs.add(expr);
    }

    public void addExpressions(Expression ... exprs) {
        this.exprs.addAll(exprs);
    }

    public int getNumInitializers() {
        return this.exprs.size();
    }

    @Override
    protected Type createType() {
        return this.type;
    }

    @Override
    public Expression.Precedence getPrecedence() {
        return Expression.Precedence.Default;
    }

    @Override
    public boolean addDependencies(DependencyList deps) {
        if (!this.type.isArray() || this.type.dereference().isIndirect() ? !this.type.addDependencies(deps) : !this.type.dereference().addDependencies(deps)) {
            return false;
        }
        return this.exprs == null ? true : this.exprs.addDependencies(deps);
    }

    @Override
    public boolean write(CppFormatter fmt) {
        if (!fmt.openBrace()) {
            return false;
        }
        if (!this.exprs.write(fmt)) {
            return false;
        }
        return fmt.closeBrace(false);
    }
}

