/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.core.validation.java;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.RTConnector;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.ConnectorKind;
import org.eclipse.uml2.uml.Port;

public class ConnectorPortsCompatibilityConstraint
extends AbstractModelConstraint {
    public IStatus validate(IValidationContext ctx) {
        RTConnector target = (RTConnector)ctx.getTarget();
        Connector connector = target.getBase_Connector();
        if (connector.getEnds().size() == 2) {
            Port port1 = (Port)((ConnectorEnd)connector.getEnds().get(0)).getRole();
            Port port2 = (Port)((ConnectorEnd)connector.getEnds().get(1)).getRole();
            String arg = "'" + port1.getQualifiedName() + "' and '" + port2.getQualifiedName() + "'";
            if (!port1.getType().equals(port2.getType())) {
                return ctx.createFailureStatus(new Object[]{arg, "Ports must be typed with compatible protocol."});
            }
            if (connector.getKind().equals((Object)ConnectorKind.ASSEMBLY_LITERAL)) {
                if (port1.isConjugated() == port2.isConjugated()) {
                    return ctx.createFailureStatus(new Object[]{arg, "Assembly connector must have different conjugation between connected ports."});
                }
            } else if (port1.isConjugated() != port2.isConjugated()) {
                return ctx.createFailureStatus(new Object[]{arg, "Delegation connector must have same conjugation between connected ports."});
            }
        }
        return ctx.createSuccessStatus();
    }
}

