/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.compare.internal.diagram;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.utils.MatchUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.BasicCompartment;
import org.eclipse.gmf.runtime.notation.DecorationNode;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrusrt.umlrt.core.utils.RTPortUtils;
import org.eclipse.papyrusrt.umlrt.tooling.compare.internal.UMLRTCompareUtil;
import org.eclipse.papyrusrt.umlrt.tooling.compare.internal.diagram.AbstractCapsuleDiagramChangeHandler;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Stereotype;

public class PortDiagramChangeHandler
extends AbstractCapsuleDiagramChangeHandler {
    @Override
    public double isHandlerFor(Diff diff) {
        if (this.isReferenceChangeOfPortShape(diff) && UMLRTCompareUtil.isViewPersistedChildrenReference(((ReferenceChange)diff).getReference())) {
            return 10.0;
        }
        return Double.NaN;
    }

    private boolean isReferenceChangeOfPortShape(Diff input) {
        if (!(input instanceof ReferenceChange)) {
            return false;
        }
        EObject value = ((ReferenceChange)input).getValue();
        if (!(value instanceof Shape)) {
            return false;
        }
        EObject element = ((Shape)value).getElement();
        return element instanceof Port && RTPortUtils.isRTPort((EObject)element);
    }

    @Override
    public Set<EObject> getShapes(Diff diff) {
        LinkedHashSet<EObject> shapes = new LinkedHashSet<EObject>();
        ReferenceChange refChange = (ReferenceChange)diff;
        Shape portShape = (Shape)refChange.getValue();
        shapes.add((EObject)portShape);
        shapes.addAll(this.collectAdditionalShapesForElement(portShape));
        return shapes;
    }

    @Override
    public Set<EObject> getAutomaticallyCreatedShapes(Diff diff) {
        Set<EObject> shapes = super.getAutomaticallyCreatedShapes(diff);
        EObject portShape = (EObject)MatchUtil.getValue((Diff)diff);
        View container = (View)portShape.eContainer();
        for (Object child : container.getChildren()) {
            View view;
            if (!(child instanceof View) || !this.isStereotypeBraceBasicCompartment(view = (View)child) && !this.isStereotypeCompartmentBasicCompartment(view) && !this.isStereotypeLabelDecorationNode(view) && !this.isCompartmentShapeDisplayBasicCompartment(view)) continue;
            shapes.add((EObject)view);
        }
        return shapes;
    }

    private Collection<EObject> collectAdditionalShapesForElement(Shape portShape) {
        LinkedHashSet<EObject> shapes = new LinkedHashSet<EObject>();
        EObject port = portShape.getElement();
        Diagram diagram = portShape.getDiagram();
        for (Object edge : diagram.getEdges()) {
            if (!this.isStereotypeCommentEdge(edge, port)) continue;
            Edge stereotypeEdge = (Edge)edge;
            shapes.add((EObject)stereotypeEdge);
            View stereotypeCommentShape = stereotypeEdge.getTarget();
            shapes.add((EObject)stereotypeCommentShape);
        }
        return shapes;
    }

    private boolean hasUMLRealTimeStereotypeElement(View view) {
        EObject element = view.getElement();
        return element instanceof Stereotype && "UMLRealTime".equals(((Stereotype)element).getProfile().getName());
    }

    private boolean isStereotypeLabelDecorationNode(View view) {
        return this.hasUMLRealTimeStereotypeElement(view) && view instanceof DecorationNode && "StereotypeLabel".equals(view.getType());
    }

    private boolean isStereotypeBraceBasicCompartment(View view) {
        return this.hasUMLRealTimeStereotypeElement(view) && view instanceof BasicCompartment && "StereotypeBrace".equals(view.getType());
    }

    private boolean isStereotypeCompartmentBasicCompartment(View view) {
        return this.hasUMLRealTimeStereotypeElement(view) && view instanceof BasicCompartment && "StereotypeCompartment".equals(view.getType());
    }

    private boolean isCompartmentShapeDisplayBasicCompartment(View view) {
        return view instanceof BasicCompartment && "compartment_shape_display".equals(view.getType());
    }
}

