/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.editpolicies.stereotype;

import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.LinkedHashSet;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.papyrus.infra.tools.util.TypeUtils;
import org.eclipse.papyrusrt.umlrt.uml.util.UMLRTExtensionUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.util.UMLUtil;

class RTAppliedStereotypeEditPolicyHelper
implements Adapter {
    private static final Class<?>[] GET_VALUE_SIGNATURE = new Class[]{Stereotype.class, String.class};
    private static final Class<?>[] SET_VALUE_SIGNATURE = new Class[]{Stereotype.class, String.class, Object.class};
    private final Element realHostElement;
    private Element reducedHostElement;

    private RTAppliedStereotypeEditPolicyHelper(Element element) {
        this.realHostElement = element;
    }

    static RTAppliedStereotypeEditPolicyHelper getInstance(Element element) {
        RTAppliedStereotypeEditPolicyHelper result = (RTAppliedStereotypeEditPolicyHelper)EcoreUtil.getExistingAdapter((Notifier)element, RTAppliedStereotypeEditPolicyHelper.class);
        if (result == null) {
            result = new RTAppliedStereotypeEditPolicyHelper(element);
            element.eAdapters().add((Object)result);
        }
        return result;
    }

    static Element getUMLElement(IGraphicalEditPart host) {
        NamedElement element;
        Element result = (Element)TypeUtils.as((Object)host.resolveSemanticElement(), Element.class);
        if (result instanceof NamedElement && (RTAppliedStereotypeEditPolicyHelper.hasRTStereotypes((Element)(element = (NamedElement)result)) || UMLRTExtensionUtil.isVirtualElement((Element)element))) {
            result = RTAppliedStereotypeEditPolicyHelper.getInstance((Element)element).getReducedUMLElement();
        }
        return result;
    }

    Element getReducedUMLElement() {
        if (this.reducedHostElement == null) {
            this.createReducedHostElement(UMLRTExtensionUtil.isVirtualElement((Element)this.realHostElement));
        }
        return this.reducedHostElement;
    }

    private void createReducedHostElement(boolean excludeAllStereotypes) {
        Class<?>[] interfaces = RTAppliedStereotypeEditPolicyHelper.getAllInterfaces(this.realHostElement.getClass());
        this.reducedHostElement = (Element)Proxy.newProxyInstance(this.getClass().getClassLoader(), interfaces, (proxy, method, args) -> {
            Object result;
            switch (method.getName()) {
                case "getAppliedStereotypes": {
                    result = excludeAllStereotypes ? ECollections.EMPTY_ELIST : RTAppliedStereotypeEditPolicyHelper.filterStereotypes((EList<Stereotype>)this.realHostElement.getAppliedStereotypes());
                    break;
                }
                case "getStereotypeApplications": {
                    result = excludeAllStereotypes ? ECollections.EMPTY_ELIST : RTAppliedStereotypeEditPolicyHelper.filterStereotypeApplications((EList<EObject>)this.realHostElement.getStereotypeApplications());
                    break;
                }
                case "getValue": {
                    if (Arrays.equals(method.getParameterTypes(), GET_VALUE_SIGNATURE)) {
                        Stereotype stereotype = (Stereotype)args[0];
                        if (excludeAllStereotypes) {
                            throw new IllegalArgumentException(stereotype.getName());
                        }
                        String propertyName = (String)args[1];
                        result = RTAppliedStereotypeEditPolicyHelper.getFilteredValue(this.realHostElement, stereotype, propertyName);
                        break;
                    }
                    result = method.invoke((Object)this.realHostElement, args);
                    break;
                }
                case "setValue": {
                    if (Arrays.equals(method.getParameterTypes(), SET_VALUE_SIGNATURE)) {
                        Stereotype stereotype = (Stereotype)args[0];
                        if (excludeAllStereotypes) {
                            throw new IllegalArgumentException(stereotype.getName());
                        }
                        String propertyName = (String)args[1];
                        Object value = args[2];
                        result = RTAppliedStereotypeEditPolicyHelper.setFilteredValue(this.realHostElement, stereotype, propertyName, value);
                        break;
                    }
                    result = method.invoke((Object)this.realHostElement, args);
                    break;
                }
                default: {
                    result = method.invoke((Object)this.realHostElement, args);
                }
            }
            return result;
        });
    }

    static Class<?>[] getAllInterfaces(Class<?> class_) {
        LinkedHashSet result = new LinkedHashSet();
        while (class_ != Object.class && class_ != null) {
            result.addAll(Arrays.asList(class_.getInterfaces()));
            class_ = class_.getSuperclass();
        }
        return result.toArray(new Class[result.size()]);
    }

    static boolean hasRTStereotypes(Element element) {
        EList applied = element.getAppliedStereotypes();
        return !applied.isEmpty() && applied.stream().anyMatch(RTAppliedStereotypeEditPolicyHelper::isRTStereotype);
    }

    static boolean isRTStereotype(Stereotype stereotype) {
        String nsURI;
        Profile profile = stereotype.getProfile();
        String string = nsURI = profile == null ? null : profile.getURI();
        return "http://www.eclipse.org/papyrus/umlrt".equals(nsURI) || "http://www.eclipse.org/papyrus/umlrt/statemachine".equals(nsURI);
    }

    static boolean isNotRTStereotype(Stereotype stereotype) {
        return !RTAppliedStereotypeEditPolicyHelper.isRTStereotype(stereotype);
    }

    static EList<Stereotype> filterStereotypes(EList<Stereotype> stereotypes) {
        BasicEList result;
        if (stereotypes.isEmpty()) {
            result = stereotypes;
        } else {
            result = new BasicEList(stereotypes.size());
            stereotypes.stream().filter(RTAppliedStereotypeEditPolicyHelper::isNotRTStereotype).forEach(arg_0 -> ((EList)result).add(arg_0));
        }
        return result;
    }

    static boolean isRTStereotypeApplication(EObject stereotypeApplication) {
        Stereotype stereotype = UMLUtil.getStereotype((EObject)stereotypeApplication);
        return stereotype != null && RTAppliedStereotypeEditPolicyHelper.isRTStereotype(stereotype);
    }

    static boolean isNotRTStereotypeApplication(EObject object) {
        return !RTAppliedStereotypeEditPolicyHelper.isRTStereotypeApplication(object);
    }

    static EList<EObject> filterStereotypeApplications(EList<EObject> stereotypeApplications) {
        BasicEList result;
        if (stereotypeApplications.isEmpty()) {
            result = stereotypeApplications;
        } else {
            result = new BasicEList(stereotypeApplications.size());
            stereotypeApplications.stream().filter(RTAppliedStereotypeEditPolicyHelper::isNotRTStereotypeApplication).forEach(arg_0 -> ((EList)result).add(arg_0));
        }
        return result;
    }

    static Object getFilteredValue(Element element, Stereotype stereotype, String propertyName) {
        if (RTAppliedStereotypeEditPolicyHelper.isRTStereotype(stereotype)) {
            throw new IllegalArgumentException(stereotype.getName());
        }
        return element.getValue(stereotype, propertyName);
    }

    static Void setFilteredValue(Element element, Stereotype stereotype, String propertyName, Object value) {
        if (RTAppliedStereotypeEditPolicyHelper.isRTStereotype(stereotype)) {
            throw new IllegalArgumentException(stereotype.getName());
        }
        element.setValue(stereotype, propertyName, value);
        return null;
    }

    public Notifier getTarget() {
        return this.realHostElement;
    }

    public void setTarget(Notifier newTarget) {
        if (newTarget == null) {
            this.reducedHostElement = null;
        } else if (newTarget != this.realHostElement) {
            throw new IllegalStateException("attempt to reuse helper for another element");
        }
    }

    public boolean isAdapterForType(Object type) {
        return type == RTAppliedStereotypeEditPolicyHelper.class;
    }

    public void notifyChanged(Notification notification) {
        this.reducedHostElement = null;
    }
}

