/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.uml.internal.facade.impl;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.DelegatingEcoreEList;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTNamedElement;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTState;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTStateMachine;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTTransition;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTVertex;
import org.eclipse.papyrusrt.umlrt.uml.internal.facade.UMLRTUMLRTPackage;
import org.eclipse.papyrusrt.umlrt.uml.internal.facade.impl.FacadeObjectImpl;
import org.eclipse.papyrusrt.umlrt.uml.internal.facade.impl.FacadeType;
import org.eclipse.papyrusrt.umlrt.uml.internal.facade.impl.UMLRTConnectionPointImpl;
import org.eclipse.papyrusrt.umlrt.uml.internal.facade.impl.UMLRTNamedElementImpl;
import org.eclipse.papyrusrt.umlrt.uml.internal.facade.impl.UMLRTPseudostateImpl;
import org.eclipse.papyrusrt.umlrt.uml.internal.facade.impl.UMLRTStateImpl;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Pseudostate;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.Vertex;

public abstract class UMLRTVertexImpl
extends UMLRTNamedElementImpl
implements UMLRTVertex {
    static final FacadeType<Vertex, EObject, UMLRTVertexImpl> TYPE = new FacadeType.Union<Vertex, UMLRTVertexImpl>(UMLRTVertexImpl.class, UMLPackage.Literals.VERTEX, () -> Arrays.asList(UMLRTStateImpl.TYPE, UMLRTPseudostateImpl.TYPE, UMLRTConnectionPointImpl.TYPE));

    protected UMLRTVertexImpl() {
    }

    public static UMLRTVertexImpl getInstance(Vertex vertex) {
        Pseudostate pseudo;
        UMLRTVertexImpl result = null;
        if (vertex instanceof State) {
            result = UMLRTStateImpl.getInstance((State)vertex);
        } else if (vertex instanceof Pseudostate && (result = UMLRTPseudostateImpl.getInstance(pseudo = (Pseudostate)vertex)) == null) {
            result = UMLRTConnectionPointImpl.getInstance(pseudo);
        }
        return result;
    }

    @Override
    protected EClass eStaticClass() {
        return UMLRTUMLRTPackage.Literals.VERTEX;
    }

    @Override
    public UMLRTNamedElement getRedefinitionContext() {
        UMLRTState state = this.getState();
        if (state != null) {
            return state;
        }
        UMLRTStateMachine stateMachine = this.getStateMachine();
        if (stateMachine != null) {
            return stateMachine;
        }
        return super.getRedefinitionContext();
    }

    protected FacadeObjectImpl.BasicFacadeAdapter<? extends UMLRTVertexImpl> createFacadeAdapter() {
        return new VertexAdapter<UMLRTVertexImpl>(this);
    }

    @Override
    public UMLRTNamedElement getRedefinedElement() {
        if (this.isSetRedefinedVertex()) {
            return this.getRedefinedVertex();
        }
        return super.getRedefinedElement();
    }

    @Override
    public UMLRTState getState() {
        Element owner = this.toUML().getOwner();
        if (owner instanceof Region) {
            owner = owner.getOwner();
        }
        return owner instanceof State ? UMLRTState.getInstance((State)owner) : null;
    }

    @Override
    public List<UMLRTTransition> getOutgoings() {
        EList uml = this.toUML().getOutgoings();
        EList outgoings = (EList)uml.stream().map(UMLRTTransition::getInstance).filter(Objects::nonNull).collect(Collectors.toCollection(UniqueEList.FastCompare::new));
        return new OutgoingList(this, (EStructuralFeature)UMLRTUMLRTPackage.Literals.VERTEX__OUTGOING, (EList<UMLRTTransition>)outgoings);
    }

    @Override
    public UMLRTTransition getOutgoing(String name) {
        return this.getOutgoing(name, false);
    }

    @Override
    public UMLRTTransition getOutgoing(String name, boolean ignoreCase) {
        for (UMLRTTransition outgoing : this.getOutgoings()) {
            if (name != null && (ignoreCase ? !name.equalsIgnoreCase(outgoing.getName()) : !name.equals(outgoing.getName()))) continue;
            return outgoing;
        }
        return null;
    }

    @Override
    public List<UMLRTTransition> getIncomings() {
        EList uml = this.toUML().getIncomings();
        EList incomings = (EList)uml.stream().map(UMLRTTransition::getInstance).filter(Objects::nonNull).collect(Collectors.toCollection(UniqueEList.FastCompare::new));
        return new IncomingList(this, (EStructuralFeature)UMLRTUMLRTPackage.Literals.VERTEX__INCOMING, (EList<UMLRTTransition>)incomings);
    }

    @Override
    public UMLRTTransition getIncoming(String name) {
        return this.getIncoming(name, false);
    }

    @Override
    public UMLRTTransition getIncoming(String name, boolean ignoreCase) {
        for (UMLRTTransition incoming : this.getIncomings()) {
            if (name != null && (ignoreCase ? !name.equalsIgnoreCase(incoming.getName()) : !name.equals(incoming.getName()))) continue;
            return incoming;
        }
        return null;
    }

    @Override
    public UMLRTVertex getRedefinedVertex() {
        return null;
    }

    @Override
    public UMLRTStateMachine getStateMachine() {
        Element owner = this.toUML().getOwner();
        if (owner instanceof Region) {
            owner = owner.getOwner();
        }
        return owner instanceof StateMachine ? UMLRTStateMachine.getInstance((StateMachine)owner) : null;
    }

    @Override
    public Vertex toUML() {
        return (Vertex)super.toUML();
    }

    @Override
    public UMLRTStateMachine containingStateMachine() {
        UMLRTState state;
        UMLRTStateMachine result = this.getStateMachine();
        if (result == null && (state = this.getState()) != null) {
            result = state.containingStateMachine();
        }
        return result;
    }

    @Override
    public UMLRTTransition createTransitionTo(UMLRTVertex target) {
        Region myRegion = UMLRTVertexImpl.getRegion(this.toUML());
        Region region = UMLRTVertexImpl.commonRegion(myRegion, UMLRTVertexImpl.getRegion(target.toUML()));
        if (region == null) {
            region = myRegion;
        }
        Transition result = region.createTransition(null);
        result.setSource(this.toUML());
        result.setTarget(target.toUML());
        return UMLRTTransition.getInstance(result);
    }

    static Region commonRegion(Region r1, Region r2) {
        Region result;
        if (r1 == r2 || UMLRTVertexImpl.isAncestor(r2, r1)) {
            result = r1;
        } else if (UMLRTVertexImpl.isAncestor(r1, r2)) {
            result = r2;
        } else {
            r1 = UMLRTVertexImpl.containingRegion(r1);
            r2 = UMLRTVertexImpl.containingRegion(r2);
            result = r1 != null && r2 != null ? UMLRTVertexImpl.commonRegion(r1, r2) : null;
        }
        return result;
    }

    static boolean isAncestor(Region region, Region possibleAncestor) {
        boolean result;
        boolean bl = result = region == possibleAncestor;
        if (!result) {
            region = UMLRTVertexImpl.containingRegion(region);
            while (!result && region != null) {
                result = region == possibleAncestor;
                region = UMLRTVertexImpl.containingRegion(region);
            }
        }
        return result;
    }

    static Region containingRegion(Region region) {
        return region.getState() == null ? null : region.getState().getContainer();
    }

    static Region getRegion(Vertex vertex) {
        Pseudostate pseudo;
        Region result = null;
        Pseudostate pseudostate = pseudo = vertex instanceof Pseudostate ? (Pseudostate)vertex : null;
        if (pseudo != null && pseudo.getState() != null) {
            result = UMLRTStateImpl.getCompositeRegion(pseudo.getState());
        }
        Element owner = vertex.getOwner();
        while (result == null && owner != null) {
            if (owner instanceof Region) {
                result = (Region)owner;
            }
            owner = owner.getOwner();
        }
        return result;
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 17: {
                return this.getRedefinedVertex();
            }
            case 14: {
                return this.getState();
            }
            case 15: {
                return this.getIncomings();
            }
            case 16: {
                return this.getOutgoings();
            }
            case 18: {
                return this.getStateMachine();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 9: {
                return this.isSetRedefinitionContext();
            }
            case 17: {
                return this.isSetRedefinedVertex();
            }
            case 8: {
                return this.isSetRedefinedElement();
            }
            case 14: {
                return this.getState() != null;
            }
            case 15: {
                return !this.getIncomings().isEmpty();
            }
            case 16: {
                return !this.getOutgoings().isEmpty();
            }
            case 18: {
                return this.getStateMachine() != null;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public boolean isSetRedefinitionContext() {
        return super.isSetRedefinitionContext() || this.eIsSet(14) || this.eIsSet(18);
    }

    public boolean isSetRedefinedVertex() {
        return false;
    }

    @Override
    public boolean isSetRedefinedElement() {
        return super.isSetRedefinedElement() || this.isSetRedefinedVertex();
    }

    protected static class IncomingList
    extends DelegatingEcoreEList<UMLRTTransition> {
        private static final long serialVersionUID = 1L;
        protected final EStructuralFeature eStructuralFeature;
        protected final EList<UMLRTTransition> delegate;

        protected IncomingList(InternalEObject owner, EStructuralFeature eStructuralFeature, EList<UMLRTTransition> delegate) {
            super(owner);
            this.eStructuralFeature = eStructuralFeature;
            this.delegate = delegate;
        }

        public EStructuralFeature getEStructuralFeature() {
            return this.eStructuralFeature;
        }

        public int getFeatureID() {
            return this.owner.eDerivedStructuralFeatureID(this.eStructuralFeature.getFeatureID(), UMLRTVertex.class);
        }

        protected EList<UMLRTTransition> delegateList() {
            return this.delegate;
        }

        protected void delegateAdd(int index, UMLRTTransition transition) {
            int delegateIndex = this.delegate.indexOf((Object)transition);
            if (delegateIndex != -1) {
                if (index != delegateIndex) {
                    this.delegate.move(index, (Object)transition);
                }
            } else if (index < this.delegate.size()) {
                this.delegate.add(index, (Object)transition);
            } else {
                this.delegate.add((Object)transition);
            }
        }

        protected void didAdd(int index, UMLRTTransition newTransition) {
            super.didAdd(index, (Object)newTransition);
            newTransition.setTarget((UMLRTVertex)this.owner);
        }

        protected void didRemove(int index, UMLRTTransition oldTransition) {
            super.didRemove(index, (Object)oldTransition);
            oldTransition.setTarget(null);
        }

        protected void didSet(int index, UMLRTTransition newTransition, UMLRTTransition oldTransition) {
            super.didSet(index, (Object)newTransition, (Object)oldTransition);
            newTransition.setTarget((UMLRTVertex)this.owner);
            oldTransition.setTarget(null);
        }
    }

    protected static class OutgoingList
    extends DelegatingEcoreEList<UMLRTTransition> {
        private static final long serialVersionUID = 1L;
        protected final EStructuralFeature eStructuralFeature;
        protected final EList<UMLRTTransition> delegate;

        protected OutgoingList(InternalEObject owner, EStructuralFeature eStructuralFeature, EList<UMLRTTransition> delegate) {
            super(owner);
            this.eStructuralFeature = eStructuralFeature;
            this.delegate = delegate;
        }

        public EStructuralFeature getEStructuralFeature() {
            return this.eStructuralFeature;
        }

        public int getFeatureID() {
            return this.owner.eDerivedStructuralFeatureID(this.eStructuralFeature.getFeatureID(), UMLRTVertex.class);
        }

        protected EList<UMLRTTransition> delegateList() {
            return this.delegate;
        }

        protected void delegateAdd(int index, UMLRTTransition transition) {
            int delegateIndex = this.delegate.indexOf((Object)transition);
            if (delegateIndex != -1) {
                if (index != delegateIndex) {
                    this.delegate.move(index, (Object)transition);
                }
            } else if (index < this.delegate.size()) {
                this.delegate.add(index, (Object)transition);
            } else {
                this.delegate.add((Object)transition);
            }
        }

        protected void didAdd(int index, UMLRTTransition newTransition) {
            super.didAdd(index, (Object)newTransition);
            newTransition.setSource((UMLRTVertex)this.owner);
        }

        protected void didRemove(int index, UMLRTTransition oldTransition) {
            super.didRemove(index, (Object)oldTransition);
            oldTransition.setSource(null);
        }

        protected void didSet(int index, UMLRTTransition newTransition, UMLRTTransition oldTransition) {
            super.didSet(index, (Object)newTransition, (Object)oldTransition);
            newTransition.setSource((UMLRTVertex)this.owner);
            oldTransition.setSource(null);
        }
    }

    protected static class VertexAdapter<F extends UMLRTVertexImpl>
    extends UMLRTNamedElementImpl.NamedElementAdapter<F> {
        VertexAdapter(F facade) {
            super(facade);
        }
    }
}

