/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.xtumlrt.aexpr.uml;

import java.util.Arrays;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrusrt.xtumlrt.aexpr.eval.AExprEvaluatorException;
import org.eclipse.papyrusrt.xtumlrt.aexpr.parser.AExprParsingException;
import org.eclipse.papyrusrt.xtumlrt.aexpr.uml.UMLScope;
import org.eclipse.papyrusrt.xtumlrt.aexpr.uml.XTUMLRTAExprEvaluator;
import org.eclipse.papyrusrt.xtumlrt.common.CommonElement;
import org.eclipse.papyrusrt.xtumlrt.common.LiteralInteger;
import org.eclipse.papyrusrt.xtumlrt.common.LiteralNatural;
import org.eclipse.papyrusrt.xtumlrt.common.MultiplicityElement;
import org.eclipse.papyrusrt.xtumlrt.common.NamedElement;
import org.eclipse.papyrusrt.xtumlrt.common.OpaqueExpression;
import org.eclipse.papyrusrt.xtumlrt.common.ValueSpecification;
import org.eclipse.papyrusrt.xtumlrt.trans.from.uml.UML2xtumlrtTranslator;
import org.eclipse.papyrusrt.xtumlrt.util.QualifiedNames;
import org.eclipse.papyrusrt.xtumlrt.util.UndefinedValueException;
import org.eclipse.papyrusrt.xtumlrt.util.XTUMLRTLogger;
import org.eclipse.papyrusrt.xtumlrt.util.XTUMLRTUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Pure;

public class XTUMLRTBoundsEvaluator {
    private static final XTUMLRTAExprEvaluator evaluator = new XTUMLRTAExprEvaluator();
    @Accessors
    private static UML2xtumlrtTranslator translator;

    public static void setTranslator(UML2xtumlrtTranslator trans) {
        translator = trans;
        evaluator.setTranslator(translator);
    }

    protected static int _evaluateBound(CommonElement element, LiteralInteger valSpec, boolean upper) {
        return valSpec.getValue();
    }

    protected static int _evaluateBound(CommonElement element, LiteralNatural valSpec, boolean upper) {
        return valSpec.getValue();
    }

    protected static int _evaluateBound(CommonElement element, OpaqueExpression valSpec, boolean upper) {
        String _body = valSpec.getBody();
        return XTUMLRTBoundsEvaluator.evaluateBoundString(element, _body, upper);
    }

    public static int evaluateBoundString(CommonElement element, String boundSpec, boolean upper) {
        try {
            NamedElement who = XTUMLRTUtil.firstNamespaceContainer((EObject)element);
            String _xifexpression = null;
            _xifexpression = upper ? "Upper" : "Lower";
            String _plus = String.valueOf(_xifexpression) + " bound specified for ";
            String _fullName = QualifiedNames.fullName((NamedElement)who);
            String _plus_1 = String.valueOf(_plus) + _fullName;
            String msg = String.valueOf(_plus_1) + " could not be determined";
            try {
                Element _source = translator.getSource((CommonElement)who);
                org.eclipse.uml2.uml.NamedElement umlElement = (org.eclipse.uml2.uml.NamedElement)_source;
                UMLScope _uMLScope = new UMLScope(umlElement);
                int bound = evaluator.eval(boundSpec, _uMLScope);
                if (bound < 0) {
                    throw new UndefinedValueException(msg);
                }
                return bound;
            }
            catch (Throwable _t) {
                if (_t instanceof ClassCastException) {
                    ClassCastException e = (ClassCastException)_t;
                    String _msg = msg;
                    String _name = who.getName();
                    String _plus_2 = " because it was not possible to determine the UML element for '" + _name;
                    String _plus_3 = String.valueOf(_plus_2) + "'.";
                    String _msg_1 = msg = String.valueOf(_msg) + _plus_3;
                    String _message = e.getMessage();
                    String _plus_4 = "The error was: '" + _message;
                    String _plus_5 = String.valueOf(_plus_4) + "'.";
                    msg = String.valueOf(_msg_1) + _plus_5;
                    XTUMLRTLogger.error((String)msg);
                    throw new UndefinedValueException(msg);
                }
                if (_t instanceof NumberFormatException) {
                    NumberFormatException e_1 = (NumberFormatException)_t;
                    String _msg_2 = msg;
                    String _msg_3 = msg = String.valueOf(_msg_2) + " due to a number format exception in the expression '" + boundSpec + "'. ";
                    String _message_1 = e_1.getMessage();
                    String _plus_6 = "The error was: '" + _message_1;
                    String _plus_7 = String.valueOf(_plus_6) + "'.";
                    msg = String.valueOf(_msg_3) + _plus_7;
                    XTUMLRTLogger.error((String)msg);
                    throw new UndefinedValueException(msg);
                }
                if (_t instanceof AExprEvaluatorException) {
                    AExprEvaluatorException e_2 = (AExprEvaluatorException)_t;
                    String _msg_4 = msg;
                    String _msg_5 = msg = String.valueOf(_msg_4) + " due to an evaluation error in the expression '" + boundSpec + "'. ";
                    String _message_2 = e_2.getMessage();
                    String _plus_8 = "The error was: '" + _message_2;
                    String _plus_9 = String.valueOf(_plus_8) + "'.";
                    msg = String.valueOf(_msg_5) + _plus_9;
                    XTUMLRTLogger.error((String)msg);
                    throw new UndefinedValueException(msg);
                }
                if (_t instanceof AExprParsingException) {
                    AExprParsingException e_3 = (AExprParsingException)_t;
                    String _msg_6 = msg;
                    String _msg_7 = msg = String.valueOf(_msg_6) + " due to a parsing error in the expression '" + boundSpec + "'. ";
                    String _message_3 = e_3.getMessage();
                    String _plus_10 = "The error was: '" + _message_3;
                    String _plus_11 = String.valueOf(_plus_10) + "'.";
                    msg = String.valueOf(_msg_7) + _plus_11;
                    XTUMLRTLogger.error((String)msg);
                    throw new UndefinedValueException(msg);
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static int getBound(MultiplicityElement element) throws UndefinedValueException {
        int _evaluateBound_1;
        ValueSpecification lowerBoundSpec = element.getLowerBound();
        ValueSpecification upperBoundSpec = element.getUpperBound();
        int lowerBound = -1;
        int upperBound = -1;
        int bound = -1;
        boolean evaluatedLowerBound = true;
        try {
            int _evaluateBound;
            lowerBound = _evaluateBound = XTUMLRTBoundsEvaluator.evaluateBound((CommonElement)element, lowerBoundSpec, false);
        }
        catch (Throwable _t) {
            if (_t instanceof UndefinedValueException) {
                UndefinedValueException cfr_ignored_0 = (UndefinedValueException)_t;
                evaluatedLowerBound = false;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        bound = upperBound = (_evaluateBound_1 = XTUMLRTBoundsEvaluator.evaluateBound((CommonElement)element, upperBoundSpec, true));
        if (evaluatedLowerBound && lowerBound > upperBound) {
            bound = lowerBound;
        }
        return bound;
    }

    public static <T extends MultiplicityElement & NamedElement> String getBoundString(T element) {
        ValueSpecification lowerBoundSpec = element.getLowerBound();
        ValueSpecification upperBoundSpec = element.getUpperBound();
        int lowerBound = -1;
        int upperBound = -1;
        int bound = 0;
        boolean evaluatedLowerBound = true;
        try {
            int _evaluateBound;
            lowerBound = _evaluateBound = XTUMLRTBoundsEvaluator.evaluateBound(element, lowerBoundSpec, false);
        }
        catch (Throwable _t) {
            if (_t instanceof UndefinedValueException) {
                UndefinedValueException cfr_ignored_0 = (UndefinedValueException)_t;
                evaluatedLowerBound = false;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        try {
            int _evaluateBound_1;
            bound = upperBound = (_evaluateBound_1 = XTUMLRTBoundsEvaluator.evaluateBound(element, upperBoundSpec, true));
            if (evaluatedLowerBound && lowerBound > upperBound) {
                bound = lowerBound;
            }
            return Integer.valueOf(bound).toString();
        }
        catch (Throwable _t_1) {
            if (_t_1 instanceof UndefinedValueException) {
                int _value;
                UndefinedValueException cfr_ignored_1 = (UndefinedValueException)_t_1;
                String _switchResult = null;
                boolean _matched = false;
                if (upperBoundSpec instanceof LiteralInteger) {
                    _matched = true;
                    _value = ((LiteralInteger)upperBoundSpec).getValue();
                    _switchResult = Integer.valueOf(_value).toString();
                }
                if (!_matched && upperBoundSpec instanceof LiteralNatural) {
                    _matched = true;
                    _value = ((LiteralNatural)upperBoundSpec).getValue();
                    _switchResult = Integer.valueOf(_value).toString();
                }
                if (!_matched && upperBoundSpec instanceof OpaqueExpression) {
                    _matched = true;
                    _switchResult = ((OpaqueExpression)upperBoundSpec).getBody();
                }
                if (!_matched) {
                    _switchResult = "?";
                }
                return _switchResult;
            }
            throw Exceptions.sneakyThrow((Throwable)_t_1);
        }
    }

    public static <T extends MultiplicityElement & NamedElement> int getLowerBound(T element) {
        int _xblockexpression = 0;
        ValueSpecification boundSpec = element.getLowerBound();
        _xblockexpression = XTUMLRTBoundsEvaluator.evaluateBound(element, boundSpec, false);
        return _xblockexpression;
    }

    public static <T extends MultiplicityElement & NamedElement> int getUpperBound(T element) {
        int _xblockexpression = 0;
        ValueSpecification boundSpec = element.getUpperBound();
        _xblockexpression = XTUMLRTBoundsEvaluator.evaluateBound(element, boundSpec, true);
        return _xblockexpression;
    }

    public static int evaluateBound(CommonElement element, ValueSpecification valSpec, boolean upper) {
        if (valSpec instanceof LiteralNatural) {
            return XTUMLRTBoundsEvaluator._evaluateBound(element, (LiteralNatural)valSpec, upper);
        }
        if (valSpec instanceof LiteralInteger) {
            return XTUMLRTBoundsEvaluator._evaluateBound(element, (LiteralInteger)valSpec, upper);
        }
        if (valSpec instanceof OpaqueExpression) {
            return XTUMLRTBoundsEvaluator._evaluateBound(element, (OpaqueExpression)valSpec, upper);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(element, valSpec, upper).toString());
    }

    @Pure
    public static UML2xtumlrtTranslator getTranslator() {
        return translator;
    }
}

