/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.core.commands;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.EditHelperContext;
import org.eclipse.gmf.runtime.emf.type.core.IClientContext;
import org.eclipse.gmf.runtime.emf.type.core.requests.AbstractEditCommandRequest;
import org.eclipse.papyrusrt.umlrt.core.commands.ExclusionCommand;
import org.eclipse.papyrusrt.umlrt.core.commands.IExcludeElementRequest;
import org.eclipse.uml2.uml.Element;

public final class ExcludeRequest
extends AbstractEditCommandRequest
implements IExcludeElementRequest {
    public static final String EXCLUDE_DEPENDENTS_REQUEST_PARAMETER = "ExcludeRequest.excludeDependentsRequest";
    public static final String INITIAL_ELEMENT_TO_EXCLUDE_PARAMETER = "ExcludeRequest.initialElementToExclude";
    private final boolean exclude;
    private Element element;

    public ExcludeRequest(TransactionalEditingDomain editingDomain, Element element, boolean exclude) {
        super(Objects.requireNonNull(editingDomain, "editingDomain"));
        this.exclude = exclude;
        this.setElementToExclude(element);
    }

    public ExcludeRequest(Element element, boolean exclude) {
        this(TransactionUtil.getEditingDomain((EObject)element), element, exclude);
    }

    @Override
    public final Element getElementToExclude() {
        return this.element;
    }

    @Override
    public final void setElementToExclude(Element element) {
        this.element = Objects.requireNonNull(element, "element");
        Objects.requireNonNull(element.getOwner(), "element.owner");
    }

    @Override
    public boolean isExclude() {
        return this.exclude;
    }

    public List getElementsToEdit() {
        return Collections.singletonList(this.getElementToExclude());
    }

    public Object getEditHelperContext() {
        IClientContext context = this.getClientContext();
        Element owner = Objects.requireNonNull(this.getElementToExclude().getOwner(), "element.owner");
        Object result = context == null ? owner : new EditHelperContext((EObject)owner, context);
        return result;
    }

    public ICommand getDefaultCommand() {
        return new ExclusionCommand(this.getEditingDomain(), this.getElementToExclude(), this.isExclude());
    }

    public static Function<Element, ExcludeRequest> serialRequest(TransactionalEditingDomain domain, boolean exclude) {
        return ExcludeRequest.serialRequest(element -> new ExcludeRequest(domain, (Element)element, exclude));
    }

    public static Function<Element, ExcludeRequest> serialRequest(boolean exclude) {
        return ExcludeRequest.serialRequest(element -> new ExcludeRequest((Element)element, exclude));
    }

    private static Function<Element, ExcludeRequest> serialRequest(final Function<Element, ExcludeRequest> initializer) {
        return new Function<Element, ExcludeRequest>(){
            private ExcludeRequest request;

            @Override
            public ExcludeRequest apply(Element element) {
                if (this.request == null) {
                    this.request = (ExcludeRequest)initializer.apply(element);
                } else {
                    this.request.setParameter(ExcludeRequest.INITIAL_ELEMENT_TO_EXCLUDE_PARAMETER, null);
                    this.request.setElementToExclude(element);
                }
                return this.request;
            }
        };
    }
}

