/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.ui.widgets;

import com.google.common.base.Strings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.papyrus.infra.widgets.editors.EnumRadio;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public class RTEnumRadioValueEditor
extends EnumRadio {
    public RTEnumRadioValueEditor(Composite parent, int style, String label) {
        super(parent, style, label);
    }

    public RTEnumRadioValueEditor(Composite parent, int style) {
        super(parent, style);
    }

    public void setProviders(IStaticContentProvider contentProvider, ILabelProvider labelProvider) {
        super.setProviders(contentProvider, labelProvider);
        if (labelProvider != null) {
            this.values.entrySet().forEach(entry -> {
                String label = labelProvider.getText(entry.getValue());
                if (!Strings.isNullOrEmpty((String)label)) {
                    ((Button)entry.getKey()).setText(label);
                }
            });
        } else {
            this.values.keySet().forEach(b -> {
                String label = b.getText();
                label = String.valueOf(label.substring(0, 1).toUpperCase()) + label.substring(1);
                label = label.replaceAll("([a-z])(A-Z)", "$1 $2");
                b.setText(String.valueOf(b.getText().substring(0, 1).toUpperCase()) + b.getText().substring(1));
            });
        }
    }

    public void setReadOnly(boolean readOnly) {
        for (Button button : this.values.keySet()) {
            if (!readOnly || button.isDisposed()) continue;
            button.setEnabled(false);
        }
        if (!this.buttonsArea.isDisposed()) {
            this.buttonsArea.setEnabled(!readOnly);
        }
    }

    public void setReadOnly(Object value, boolean readOnly) {
        for (Button button : this.values.keySet()) {
            Object object = this.values.get(button);
            if (object != value || button.isDisposed()) continue;
            button.setEnabled(readOnly);
        }
    }

    public boolean isReadOnly() {
        for (Button button : this.values.keySet()) {
            if (button.isDisposed() || !button.isEnabled()) continue;
            return false;
        }
        return true;
    }
}

