/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.uml.util;

import java.net.URL;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.UMLRealTimePackage;
import org.eclipse.papyrusrt.umlrt.profile.statemachine.UMLRTStateMachines.UMLRTStateMachinesPackage;
import org.eclipse.papyrusrt.umlrt.profile.util.UMLRTResource;
import org.eclipse.papyrusrt.umlrt.uml.internal.impl.UMLRTUMLFactoryImpl;
import org.eclipse.papyrusrt.umlrt.uml.internal.impl.UMLRTUMLRealTimeFactoryImpl;
import org.eclipse.papyrusrt.umlrt.uml.internal.umlext.ExtUMLExtPackage;
import org.eclipse.papyrusrt.umlrt.uml.internal.util.ReificationAdapter;
import org.eclipse.papyrusrt.umlrt.uml.internal.util.UMLRTUMLResourceFactoryImpl;
import org.eclipse.papyrusrt.umlrt.uml.util.UMLRTStereotypeApplicationHelper;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.UMLPlugin;
import org.eclipse.uml2.uml.resource.UMLResource;
import org.eclipse.uml2.uml.resources.util.UMLResourcesUtil;
import org.eclipse.uml2.uml.util.UMLUtil;

public class UMLRTResourcesUtil {
    private UMLRTResourcesUtil() {
    }

    public static ResourceSet init(ResourceSet resourceSet) {
        UMLResourcesUtil.initLocalRegistries((ResourceSet)resourceSet);
        UMLRTResourcesUtil.initLocalRegistries(resourceSet);
        UMLRTResourcesUtil.initLocalStereotypeApplicationHelper(resourceSet);
        return resourceSet;
    }

    public static void initGlobalRegistries() {
        UMLResourcesUtil.initGlobalRegistries();
        UMLRTResourcesUtil.initPackageRegistry(EPackage.Registry.INSTANCE);
        UMLRTResourcesUtil.initEPackageNsURIToProfileLocationMap(UMLPlugin.getEPackageNsURIToProfileLocationMap());
        UMLRTResourcesUtil.initURIConverterURIMap(URIConverter.URI_MAP);
        UMLRTResourcesUtil.initResourceFactoryRegistry(Resource.Factory.Registry.INSTANCE);
    }

    public static void initLocalRegistries(ResourceSet resourceSet) {
        UMLRTResourcesUtil.initPackageRegistry(resourceSet.getPackageRegistry());
        UMLRTResourcesUtil.initEPackageNsURIToProfileLocationMap(UMLPlugin.getEPackageNsURIToProfileLocationMap());
        UMLRTResourcesUtil.initURIConverterURIMap(resourceSet.getURIConverter().getURIMap());
        UMLRTResourcesUtil.initResourceFactoryRegistry(resourceSet.getResourceFactoryRegistry());
    }

    public static void initLocalStereotypeApplicationHelper(ResourceSet resourceSet) {
        UMLRTStereotypeApplicationHelper wrapper = new UMLRTStereotypeApplicationHelper(UMLUtil.StereotypeApplicationHelper.getInstance((Notifier)resourceSet));
        UMLUtil.StereotypeApplicationHelper.setInstance((ResourceSet)resourceSet, (UMLUtil.StereotypeApplicationHelper)wrapper);
    }

    public static EPackage.Registry initPackageRegistry(EPackage.Registry packageRegistry) {
        packageRegistry.put((Object)"http://www.eclipse.org/papyrus/umlrt", (Object)UMLRealTimePackage.eINSTANCE);
        packageRegistry.put((Object)"http://www.eclipse.org/papyrus/umlrt/statemachine", (Object)UMLRTStateMachinesPackage.eINSTANCE);
        packageRegistry.put((Object)"http://www.eclipse.org/papyrus/umlrt/uml-ext", (Object)ExtUMLExtPackage.eINSTANCE);
        UMLRTResourcesUtil.installUMLRTFactory(packageRegistry);
        return packageRegistry;
    }

    public static Resource.Factory.Registry initResourceFactoryRegistry(Resource.Factory.Registry resourceFactoryRegistry) {
        UMLRTResourcesUtil.installUMLRTResourceFactory(resourceFactoryRegistry);
        return resourceFactoryRegistry;
    }

    public static Map<String, URI> initEPackageNsURIToProfileLocationMap(Map<String, URI> ePackageNsURIToProfileLocationMap) {
        ePackageNsURIToProfileLocationMap.put("http://www.eclipse.org/papyrus/umlrt", URI.createURI((String)"pathmap://UML_RT_PROFILE/uml-rt.profile.uml#_1h74oEeVEeO0lv5O1DTHOQ"));
        ePackageNsURIToProfileLocationMap.put("http://www.eclipse.org/papyrus/umlrt/statemachine", URI.createURI((String)"pathmap://UML_RT_PROFILE/UMLRealTimeSM-addendum.profile.uml#_KLcn0FDtEeOA4ecmvfqvaw"));
        ePackageNsURIToProfileLocationMap.put("http://www.eclipse.org/papyrus/umlrt/uml-ext", URI.createURI((String)"pathmap://UML_RT_UML/uml-ext.metamodel.uml#_0"));
        return ePackageNsURIToProfileLocationMap;
    }

    public static Map<URI, URI> initURIConverterURIMap(Map<URI, URI> uriMap) {
        URI baseURI = UMLRTResourcesUtil.getBaseResourceURI(UMLRTResource.class, "pathmap://UML_RT_PROFILE/uml-rt.profile.uml", "umlProfile");
        UMLRTResourcesUtil.mapUMLRTResourceURIs(uriMap, "pathmap://UML_RT_PROFILE/", baseURI.appendSegment("umlProfile"));
        baseURI = UMLRTResourcesUtil.getBaseResourceURI(UMLRTResourcesUtil.class, "pathmap://UML_RT_UML/uml-ext.metamodel.uml", "model");
        UMLRTResourcesUtil.mapUMLRTResourceURIs(uriMap, "pathmap://UML_RT_UML/", baseURI.appendSegment("model"));
        return uriMap;
    }

    private static URI getBaseResourceURI(Class<?> context, String prototypeURI, String folder) {
        URI result;
        URI uri = URI.createURI((String)prototypeURI);
        URL resultURL = context.getClassLoader().getResource(String.format("%s/%s", folder, uri.lastSegment()));
        if (resultURL != null) {
            result = URI.createURI((String)resultURL.toExternalForm(), (boolean)true).trimSegments(2);
        } else {
            resultURL = context.getResource(String.valueOf(context.getSimpleName()) + ".class");
            String baseURL = resultURL.toExternalForm();
            baseURL = baseURL.substring(0, baseURL.lastIndexOf("/bin/"));
            result = URI.createURI((String)baseURL, (boolean)true);
        }
        return result;
    }

    private static void mapUMLRTResourceURIs(Map<URI, URI> uriMap, String uri, URI location) {
        URI prefix = URI.createURI((String)uri);
        if (!prefix.hasTrailingPathSeparator()) {
            prefix = prefix.appendSegment("");
        }
        if (!location.hasTrailingPathSeparator()) {
            location = location.appendSegment("");
        }
        uriMap.put(prefix, location);
        String folder = location.segment(location.segmentCount() - 2);
        String platformURI = String.format("%s/%s/", "org.eclipse.papyrusrt.umlrt.profile", folder);
        uriMap.put(URI.createPlatformPluginURI((String)platformURI, (boolean)true), location);
        uriMap.put(URI.createPlatformResourceURI((String)platformURI, (boolean)true), location);
    }

    public static ResourceSet installUMLRTFactory(ResourceSet resourceSet) {
        UMLRTResourcesUtil.installUMLRTFactory(resourceSet.getPackageRegistry());
        UMLRTResourcesUtil.installUMLRTResourceFactory(resourceSet.getResourceFactoryRegistry());
        return resourceSet;
    }

    public static void installUMLRTFactory(EPackage.Registry packageRegistry) {
        UMLPackage umlPackage = UMLRTUMLFactoryImpl.eINSTANCE.getUMLPackage();
        UMLRTResourcesUtil.installUMLFactory(packageRegistry, umlPackage);
        UMLRealTimePackage umlRealTimePackage = UMLRTUMLRealTimeFactoryImpl.eINSTANCE.getUMLRealTimePackage();
        packageRegistry.put((Object)"http://www.eclipse.org/papyrus/umlrt", (Object)umlRealTimePackage);
    }

    private static void installUMLFactory(EPackage.Registry packageRegistry, UMLPackage umlPackage) {
        packageRegistry.put((Object)"http://www.eclipse.org/uml2/5.0.0/UML", (Object)umlPackage);
        for (Map.Entry next : packageRegistry.entrySet()) {
            if (!(next.getValue() instanceof UMLPackage)) continue;
            next.setValue(umlPackage);
        }
    }

    public static void installUMLRTResourceFactory(Resource.Factory.Registry resourceFactoryRegistry) {
        UMLRTResourcesUtil.installUMLResourceFactory(resourceFactoryRegistry, UMLRTUMLResourceFactoryImpl.INSTANCE);
    }

    private static void installUMLResourceFactory(Resource.Factory.Registry resourceFactoryRegistry, UMLResource.Factory umlResourceFactory) {
        Map extensionToFactoryMap = resourceFactoryRegistry.getExtensionToFactoryMap();
        extensionToFactoryMap.put("uml", umlResourceFactory);
        Map contentTypeToFactoryMap = resourceFactoryRegistry.getContentTypeToFactoryMap();
        contentTypeToFactoryMap.put("org.eclipse.uml2.uml_5_0_0", umlResourceFactory);
    }

    public static ResourceSet uninstallUMLRTFactory(ResourceSet resourceSet) {
        UMLRTResourcesUtil.uninstallUMLRTFactory(resourceSet.getPackageRegistry());
        UMLRTResourcesUtil.uninstallUMLRTResourceFactory(resourceSet.getResourceFactoryRegistry());
        return resourceSet;
    }

    public static void uninstallUMLRTFactory(EPackage.Registry packageRegistry) {
        packageRegistry.put((Object)"http://www.eclipse.org/papyrus/umlrt", (Object)UMLRealTimePackage.eINSTANCE);
        UMLRTResourcesUtil.installUMLFactory(packageRegistry, UMLPackage.eINSTANCE);
    }

    public static void uninstallUMLRTResourceFactory(Resource.Factory.Registry resourceFactoryRegistry) {
        UMLRTResourcesUtil.installUMLResourceFactory(resourceFactoryRegistry, UMLResource.Factory.INSTANCE);
    }

    @Deprecated
    public static void setUndoRedoRecognizer(ResourceSet resourceSet, Predicate<? super Notification> undoRedoRecognizer) {
        ReificationAdapter.getInstance(resourceSet).setUndoRedoRecognizer(undoRedoRecognizer);
    }

    public static void setUndoRedoQuery(ResourceSet resourceSet, BooleanSupplier isUndoRedo) {
        ReificationAdapter.getInstance(resourceSet).setUndoRedoQuery(isUndoRedo);
    }
}

