/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.views.codesnippet.editors;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.papyrusrt.umlrt.core.internal.defaultlanguage.NoDefautLanguage;
import org.eclipse.papyrusrt.umlrt.tooling.views.codesnippet.editors.ILanguageEditor;
import org.eclipse.papyrusrt.umlrt.tooling.views.codesnippet.editors.NoLanguageEditor;
import org.eclipse.papyrusrt.umlrt.tooling.views.codesnippet.editors.TextLanguageEditor;

public final class LanguageEditorRegistry {
    private static LanguageEditorRegistry instance;
    private Map<String, Class<? extends ILanguageEditor>> editorMap = new HashMap<String, Class<? extends ILanguageEditor>>();

    private LanguageEditorRegistry() {
        this.editorMap.put(NoDefautLanguage.INSTANCE.getName(), NoLanguageEditor.class);
        this.editorMap.put("C++", TextLanguageEditor.class);
    }

    public static LanguageEditorRegistry getInstance() {
        if (instance == null) {
            instance = new LanguageEditorRegistry();
        }
        return instance;
    }

    public ILanguageEditor getNewLanguageEditorInstance(String language) {
        Class<? extends ILanguageEditor> clazz = this.editorMap.get(language);
        if (clazz == null) {
            clazz = this.editorMap.get(NoDefautLanguage.INSTANCE.getName());
        }
        if (clazz != null) {
            try {
                return clazz.newInstance();
            }
            catch (IllegalAccessException | InstantiationException reflectiveOperationException) {}
        }
        return null;
    }
}

