/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.uml.internal.impl;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrusrt.umlrt.uml.internal.impl.InternalUMLRTElement;
import org.eclipse.papyrusrt.umlrt.uml.internal.impl.InternalUMLRTNamespace;
import org.eclipse.papyrusrt.umlrt.uml.internal.umlext.ExtElement;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.util.UMLUtil;

public interface InternalUMLRTRedefinitionContext<T extends InternalUMLRTRedefinitionContext<T>>
extends InternalUMLRTNamespace {
    public void rtInherit(T var1);

    public void rtDisinherit(T var1);

    default public void rtAutoDisinherit() {
        T ancestor = this.rtGetAncestor();
        if (ancestor != null) {
            this.rtDisinherit(ancestor);
        }
    }

    default public void rtPruneInheritance(Collection<?> deletedElements) {
        this.rtDescendants().forEach(d -> d.rtPrune(deletedElements));
    }

    default public void rtPrune(Collection<?> deletedElements) {
        List<InternalUMLRTElement> toPrune;
        if (this.rtHasExtension() && !(toPrune = this.rtExtension(ExtElement.class).eContents().stream().filter(InternalUMLRTElement.class::isInstance).map(InternalUMLRTElement.class::cast).filter(rt -> {
            Object redef = rt.rtGetRedefinedElement();
            return redef == null || deletedElements.contains(redef);
        }).collect(Collectors.toList())).isEmpty()) {
            toPrune.forEach(InternalUMLRTElement::rtDelete);
        }
    }

    default public T rtGetAncestor() {
        return (T)((InternalUMLRTRedefinitionContext)this.rtGetRedefinedElement());
    }

    default public void rtSetAncestor(T ancestor) {
        this.umlSetRedefinedElement((InternalUMLRTElement)ancestor);
    }

    public Stream<? extends T> rtDescendants();

    default public <E extends Element> void rtInherit(T ancestor, EReference reference, EReference extension, Class<E> type, Class<? extends EObject> stereotype) {
        Predicate<InternalUMLRTElement> typeFilter = stereotype == null ? type::isInstance : elem -> type.isInstance(elem) && UMLUtil.getStereotypeApplication((Element)((Element)elem), (Class)stereotype) != null;
        Predicate<InternalUMLRTElement> isExcluded = InternalUMLRTElement::rtIsExcluded;
        List redefinitions = this.rtGet(reference, extension).collect(Collectors.toList());
        ancestor.rtGet(reference, extension).filter(typeFilter).filter(isExcluded.negate()).filter(inh -> !this.rtHasRedefinition((InternalUMLRTElement)inh, redefinitions)).forEach(inh -> {
            InternalUMLRTElement resolved = this.rtGet(reference, null).filter(r -> r.rtIsRedefinition() && inh.rtRedefines((InternalUMLRTElement)r.rtGetRedefinedElement().rtGetNearestRealDefinition())).findFirst().orElse(null);
            if (resolved == null) {
                this.rtAddImplicitRedefinition((InternalUMLRTElement)inh, extension);
            } else {
                resolved.umlSetRedefinedElement((InternalUMLRTElement)inh);
            }
        });
    }

    default public Stream<InternalUMLRTElement> rtGet(EReference reference, EReference extension) {
        Stream<InternalUMLRTElement> result = ((List)this.eGet((EStructuralFeature)reference)).stream().filter(InternalUMLRTElement.class::isInstance).map(InternalUMLRTElement.class::cast);
        if (extension != null) {
            result = Stream.concat(result, ((List)this.eGet((EStructuralFeature)extension)).stream().filter(InternalUMLRTElement.class::isInstance).map(InternalUMLRTElement.class::cast));
        }
        return result;
    }

    default public boolean rtHasRedefinition(InternalUMLRTElement inherited, Collection<? extends InternalUMLRTElement> redefinitions) {
        return redefinitions.stream().map(InternalUMLRTElement::rtGetRedefinedElement).anyMatch(inherited::equals);
    }

    default public <R extends InternalUMLRTElement> R rtGetRedefinitionOf(R inherited) {
        return (R)((InternalUMLRTElement)this.getOwnedElements().stream().filter(arg_0 -> ((EClass)inherited.eClass()).isInstance(arg_0)).filter(r -> ((InternalUMLRTElement)r).rtRedefines(inherited)).findFirst().orElse(null));
    }

    default public InternalUMLRTElement rtAddImplicitRedefinition(InternalUMLRTElement inherited, EReference extension) {
        InternalUMLRTElement result = (InternalUMLRTElement)this.create(inherited.eClass());
        List implicitElements = (List)this.eGet((EStructuralFeature)extension);
        result.rtRedefine(inherited);
        implicitElements.add(result);
        result.rtApplyStereotypes(inherited);
        return result;
    }

    default public void rtDisinherit(T general, EReference reference, EReference extension) {
        List redefinitions = this.rtGet(reference, extension).collect(Collectors.toList());
        Consumer<InternalUMLRTElement> autoDisinherit = element -> {
            if (element instanceof InternalUMLRTRedefinitionContext) {
                ((InternalUMLRTRedefinitionContext)element).rtAutoDisinherit();
            }
        };
        redefinitions.stream().filter(redef -> Optional.ofNullable(redef.rtGetRedefinedElement()).filter(inh -> ((Element)inh).getOwner() == general).isPresent()).peek(autoDisinherit).forEach(InternalUMLRTElement::rtDelete);
    }
}

