/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.xtumlrt.aexpr.uml;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.papyrusrt.xtumlrt.aexpr.eval.scopes.Scope;
import org.eclipse.papyrusrt.xtumlrt.aexpr.eval.scopes.Thunk;
import org.eclipse.papyrusrt.xtumlrt.aexpr.names.Name;
import org.eclipse.papyrusrt.xtumlrt.aexpr.names.QualifiedName;
import org.eclipse.papyrusrt.xtumlrt.aexpr.uml.NoResourceFound;
import org.eclipse.papyrusrt.xtumlrt.aexpr.uml.UMLScope;
import org.eclipse.papyrusrt.xtumlrt.aexpr.uml.XTUMLRTThunk;
import org.eclipse.papyrusrt.xtumlrt.common.Attribute;
import org.eclipse.papyrusrt.xtumlrt.common.BaseContainer;
import org.eclipse.papyrusrt.xtumlrt.common.CommonElement;
import org.eclipse.papyrusrt.xtumlrt.common.Entity;
import org.eclipse.papyrusrt.xtumlrt.common.NamedElement;
import org.eclipse.papyrusrt.xtumlrt.common.Package;
import org.eclipse.papyrusrt.xtumlrt.common.StructuredType;
import org.eclipse.papyrusrt.xtumlrt.common.VisibilityKind;
import org.eclipse.papyrusrt.xtumlrt.trans.from.uml.UML2xtumlrtTranslator;
import org.eclipse.papyrusrt.xtumlrt.util.QualifiedNames;
import org.eclipse.papyrusrt.xtumlrt.util.XTUMLRTUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Pure;

public class XTUMLRTScope
implements Scope {
    private NamedElement context;
    @Extension
    @Accessors
    private static UML2xtumlrtTranslator translator;
    private final HashMap<ArrayList<?>, Name> _createCache_canonicalName = CollectionLiterals.newHashMap((Pair[])new Pair[0]);

    public XTUMLRTScope(NamedElement element) {
        this.context = element;
    }

    public Thunk get(Name name) {
        XTUMLRTThunk _xifexpression = null;
        _xifexpression = name instanceof QualifiedName ? this.resolveQualifiedName((QualifiedName)name, this.context) : this.resolveUnqualifiedName(name, this.context);
        return _xifexpression;
    }

    private XTUMLRTThunk _resolveUnqualifiedName(Name nameToLookFor, NamedElement context) {
        return null;
    }

    private XTUMLRTThunk _resolveUnqualifiedName(final Name nameToLookFor, StructuredType context) {
        XTUMLRTThunk _xblockexpression = null;
        EList _attributes = context.getAttributes();
        Functions.Function1<Attribute, Boolean> _function = new Functions.Function1<Attribute, Boolean>(){

            public Boolean apply(Attribute it) {
                String _name = it.getName();
                String _text = nameToLookFor.getText();
                return Objects.equal((Object)_name, (Object)_text);
            }
        };
        Attribute attr = (Attribute)IterableExtensions.findFirst((Iterable)_attributes, (Functions.Function1)_function);
        XTUMLRTThunk _xifexpression = null;
        if (attr != null) {
            _xifexpression = this.thunkForAttribute(attr);
        } else {
            XTUMLRTThunk _xblockexpression_1 = null;
            EObject container = context.eContainer();
            XTUMLRTThunk _xifexpression_1 = null;
            if (container instanceof NamedElement) {
                _xifexpression_1 = this.resolveUnqualifiedName(nameToLookFor, (NamedElement)container);
            }
            _xifexpression = _xblockexpression_1 = _xifexpression_1;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private XTUMLRTThunk resolveQualifiedName(QualifiedName name, NamedElement context) {
        XTUMLRTThunk _xblockexpression = null;
        String[] _segments = null;
        if (name != null) {
            _segments = name.getSegments();
        }
        String _get = null;
        if (_segments != null) {
            _get = _segments[0];
        }
        String targetModelName = _get;
        BaseContainer _root = null;
        if (context != null) {
            _root = XTUMLRTUtil.getRoot((CommonElement)context);
        }
        String _name = null;
        if (_root != null) {
            _name = _root.getName();
        }
        String contextModelName = _name;
        XTUMLRTThunk _xifexpression = null;
        if (targetModelName != null && contextModelName != null) {
            XTUMLRTThunk _xblockexpression_1 = null;
            BaseContainer targetModel = null;
            boolean _equals = Objects.equal((Object)targetModelName, (Object)contextModelName);
            if (_equals) {
                BaseContainer _root_1;
                targetModel = _root_1 = XTUMLRTUtil.getRoot((CommonElement)context);
            } else {
                EObject _findModel = this.findModel(targetModelName, (CommonElement)context);
                targetModel = _findModel;
            }
            _xifexpression = _xblockexpression_1 = this.resolveInModel(name, (EObject)targetModel);
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private EObject findModel(String name, CommonElement context) {
        EObject _xblockexpression = null;
        String resourceName = String.valueOf(name) + "/" + name + ".uml";
        URI uri = URI.createPlatformResourceURI((String)resourceName, (boolean)true);
        ResourceSet resourceSet = this.getResourceSet(context);
        EObject model = this.findModelInResourceSet(name, resourceSet);
        if (model == null) {
            Resource resource = resourceSet.getResource(uri, true);
            if (resource == null) {
                String _string = uri.toString();
                throw new NoResourceFound(_string);
            }
            EList _contents = resource.getContents();
            Iterable _filter = Iterables.filter((Iterable)_contents, org.eclipse.uml2.uml.Package.class);
            org.eclipse.uml2.uml.Package _head = (org.eclipse.uml2.uml.Package)IterableExtensions.head((Iterable)_filter);
            model = _head;
        }
        _xblockexpression = model;
        return _xblockexpression;
    }

    private ResourceSet getResourceSet(CommonElement element) {
        ResourceSet _xblockexpression = null;
        Resource resource = element.eResource();
        if (resource == null) {
            Element _source = null;
            if (translator != null) {
                _source = translator.getSource(element);
            }
            Element source = _source;
            Resource _eResource = null;
            if (source != null) {
                _eResource = source.eResource();
            }
            if ((resource = _eResource) == null) {
                NamedElement _owner = XTUMLRTUtil.getOwner((CommonElement)element);
                String _fullName = QualifiedNames.fullName((NamedElement)_owner);
                throw new NoResourceFound(_fullName);
            }
        }
        _xblockexpression = resource.getResourceSet();
        return _xblockexpression;
    }

    private EObject findModelInResourceSet(String name, ResourceSet set) {
        EList _resources = set.getResources();
        for (Resource resource : _resources) {
            EList _contents = resource.getContents();
            for (EObject eobj : _contents) {
                if (eobj instanceof BaseContainer && Objects.equal((Object)((BaseContainer)eobj).getName(), (Object)name)) {
                    return eobj;
                }
                if (!(eobj instanceof org.eclipse.uml2.uml.Package) || !Objects.equal((Object)((org.eclipse.uml2.uml.Package)eobj).getName(), (Object)name)) continue;
                return eobj;
            }
        }
        return null;
    }

    private XTUMLRTThunk _resolveInModel(QualifiedName name, BaseContainer container) {
        XTUMLRTThunk _xblockexpression = null;
        NamedElement element = this.findElement(name, container);
        XTUMLRTThunk _xifexpression = null;
        if (element instanceof Attribute) {
            _xifexpression = this.thunkForAttribute((Attribute)element);
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private XTUMLRTThunk _resolveInModel(QualifiedName name, org.eclipse.uml2.uml.Package container) {
        XTUMLRTThunk _xblockexpression = null;
        UMLScope umlScope = new UMLScope((org.eclipse.uml2.uml.NamedElement)container);
        Thunk umlThunk = umlScope.get((Name)name);
        Object _value = null;
        if (umlThunk != null) {
            _value = umlThunk.getValue();
        }
        Object umlThunkValue = _value;
        XTUMLRTThunk _xifexpression = null;
        if (umlThunk != null && umlThunkValue != null) {
            XTUMLRTThunk _xifexpression_1 = null;
            if (umlThunkValue instanceof ValueSpecification) {
                Scope _scope = umlThunk.getScope();
                _xifexpression_1 = this.thunkForUMLValueSpecification((ValueSpecification)umlThunkValue, _scope);
            }
            _xifexpression = _xifexpression_1;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private XTUMLRTThunk thunkForUMLValueSpecification(ValueSpecification specification, Scope scope) {
        XTUMLRTThunk _xblockexpression = null;
        CommonElement valSpec = translator.translate((Element)specification);
        XTUMLRTThunk _xifexpression = null;
        if (valSpec instanceof org.eclipse.papyrusrt.xtumlrt.common.ValueSpecification) {
            _xifexpression = new XTUMLRTThunk((org.eclipse.papyrusrt.xtumlrt.common.ValueSpecification)valSpec, scope);
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private NamedElement findElement(QualifiedName name, BaseContainer container) {
        if (container != null) {
            String[] segments;
            String[] _segments = null;
            if (name != null) {
                _segments = name.getSegments();
            }
            if ((segments = _segments) != null && !((List)Conversions.doWrapArray((Object)segments)).isEmpty()) {
                BaseContainer element = container;
                String segment = segments[0];
                int i = 1;
                while (i < segments.length && element != null && Objects.equal((Object)segment, (Object)element.getName())) {
                    String _get;
                    segment = _get = segments[i];
                    NamedElement _visibleNestedMember = this.getVisibleNestedMember((CommonElement)element, segment);
                    element = _visibleNestedMember;
                    ++i;
                }
                return element;
            }
        }
        return null;
    }

    private NamedElement _getVisibleNestedMember(BaseContainer namespace, final String elementName) {
        Package _xblockexpression = null;
        EList _packages = namespace.getPackages();
        Functions.Function1<Package, Boolean> _function = new Functions.Function1<Package, Boolean>(){

            public Boolean apply(Package it) {
                String _name = it.getName();
                return Objects.equal((Object)_name, (Object)elementName);
            }
        };
        Package element = (Package)IterableExtensions.findFirst((Iterable)_packages, (Functions.Function1)_function);
        Package _xifexpression = null;
        if (element != null) {
            _xifexpression = element;
        } else {
            EList _entities = namespace.getEntities();
            Functions.Function1<Entity, Boolean> _function_1 = new Functions.Function1<Entity, Boolean>(){

                public Boolean apply(Entity it) {
                    String _name = it.getName();
                    return Objects.equal((Object)_name, (Object)elementName);
                }
            };
            _xifexpression = (CommonElement)IterableExtensions.findFirst((Iterable)_entities, (Functions.Function1)_function_1);
        }
        _xblockexpression = _xifexpression;
        return (NamedElement)_xblockexpression;
    }

    private NamedElement _getVisibleNestedMember(StructuredType namespace, String elementName) {
        return this.getVisibleAttribute(namespace, elementName);
    }

    private NamedElement _getVisibleNestedMember(CommonElement namespace, String elementName) {
        return null;
    }

    private NamedElement getVisibleAttribute(StructuredType structuredType, final String attributeName) {
        Attribute _xblockexpression = null;
        EList _attributes = structuredType.getAttributes();
        Functions.Function1<Attribute, Boolean> _function = new Functions.Function1<Attribute, Boolean>(){

            public Boolean apply(Attribute it) {
                String _name = it.getName();
                return Objects.equal((Object)_name, (Object)attributeName);
            }
        };
        Attribute element = (Attribute)IterableExtensions.findFirst((Iterable)_attributes, (Functions.Function1)_function);
        Attribute _xifexpression = null;
        if (element != null && Objects.equal((Object)element.getVisibility(), (Object)VisibilityKind.PUBLIC)) {
            _xifexpression = element;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private XTUMLRTThunk thunkForAttribute(Attribute attr) {
        XTUMLRTThunk _xblockexpression = null;
        NamedElement _owner = null;
        if (attr != null) {
            _owner = XTUMLRTUtil.getOwner((CommonElement)attr);
        }
        NamedElement context = _owner;
        org.eclipse.papyrusrt.xtumlrt.common.ValueSpecification _default = null;
        if (attr != null) {
            _default = attr.getDefault();
        }
        org.eclipse.papyrusrt.xtumlrt.common.ValueSpecification attrDefault = _default;
        XTUMLRTScope _xTUMLRTScope = new XTUMLRTScope(context);
        _xblockexpression = new XTUMLRTThunk(attrDefault, _xTUMLRTScope);
        return _xblockexpression;
    }

    public Object context() {
        return this.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Name canonicalName(Name name) {
        QualifiedName _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new Name[]{name});
        HashMap<ArrayList<?>, Name> hashMap = this._createCache_canonicalName;
        synchronized (hashMap) {
            if (this._createCache_canonicalName.containsKey(_cacheKey)) {
                return this._createCache_canonicalName.get(_cacheKey);
            }
            QualifiedName _xifexpression = null;
            if (name instanceof QualifiedName) {
                _xifexpression = (QualifiedName)name;
            } else {
                QualifiedName _xblockexpression = null;
                List _containerList = XTUMLRTUtil.getContainerList((CommonElement)this.context);
                Functions.Function1<CommonElement, String> _function = new Functions.Function1<CommonElement, String>(){

                    public String apply(CommonElement it) {
                        return XTUMLRTScope.this.nameOf(it);
                    }
                };
                List _map = ListExtensions.map((List)_containerList, (Functions.Function1)_function);
                List segments = IterableExtensions.toList((Iterable)_map);
                String _text = name.getText();
                String _text_1 = name.getText();
                Iterable _plus = Iterables.concat((Iterable)segments, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{_text_1})));
                _xifexpression = _xblockexpression = new QualifiedName(_text, (String[])Conversions.unwrapArray((Object)_plus, String.class));
            }
            _result = _xifexpression;
            this._createCache_canonicalName.put(_cacheKey, (Name)_result);
        }
        this._init_canonicalName(_result, name);
        return _result;
    }

    private void _init_canonicalName(QualifiedName it, Name name) {
    }

    private String nameOf(CommonElement element) {
        String _xblockexpression = null;
        String name = "";
        if (element != null) {
            boolean _isEmpty;
            if (element instanceof NamedElement) {
                String _elvis = null;
                String _name = ((NamedElement)element).getName();
                _elvis = _name != null ? _name : "";
                name = _elvis;
            }
            if (_isEmpty = name.isEmpty()) {
                boolean _equals;
                EStructuralFeature feature = element.eContainingFeature();
                int _upperBound = feature.getUpperBound();
                boolean bl = _equals = _upperBound == 1;
                if (_equals) {
                    String _name_1;
                    name = _name_1 = feature.getName();
                } else {
                    EObject container = element.eContainer();
                    Object featureValue = container.eGet(feature);
                    if (featureValue instanceof List) {
                        String _plus;
                        String _name_2 = feature.getName();
                        int _indexOf = ((List)featureValue).indexOf(element);
                        name = _plus = String.valueOf(_name_2) + Integer.valueOf(_indexOf);
                    } else {
                        String _plus_1;
                        String _name_3 = feature.getName();
                        name = _plus_1 = String.valueOf(_name_3) + "_value";
                    }
                }
            }
        }
        _xblockexpression = name;
        return _xblockexpression;
    }

    public Name contextName() {
        QualifiedName _xblockexpression = null;
        List _containerList = XTUMLRTUtil.getContainerList((CommonElement)this.context);
        Functions.Function1<CommonElement, String> _function = new Functions.Function1<CommonElement, String>(){

            public String apply(CommonElement it) {
                return XTUMLRTScope.this.nameOf(it);
            }
        };
        List _map = ListExtensions.map((List)_containerList, (Functions.Function1)_function);
        List segments = IterableExtensions.toList((Iterable)_map);
        String _name = this.context.getName();
        _xblockexpression = new QualifiedName(_name, (String[])Conversions.unwrapArray((Object)segments, String.class));
        return _xblockexpression;
    }

    private XTUMLRTThunk resolveUnqualifiedName(Name nameToLookFor, NamedElement context) {
        if (context instanceof StructuredType) {
            return this._resolveUnqualifiedName(nameToLookFor, (StructuredType)context);
        }
        if (context != null) {
            return this._resolveUnqualifiedName(nameToLookFor, context);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(nameToLookFor, context).toString());
    }

    private XTUMLRTThunk resolveInModel(QualifiedName name, EObject container) {
        if (container instanceof org.eclipse.uml2.uml.Package) {
            return this._resolveInModel(name, (org.eclipse.uml2.uml.Package)container);
        }
        if (container instanceof BaseContainer) {
            return this._resolveInModel(name, (BaseContainer)container);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(name, container).toString());
    }

    private NamedElement getVisibleNestedMember(CommonElement namespace, String elementName) {
        if (namespace instanceof StructuredType) {
            return this._getVisibleNestedMember((StructuredType)namespace, elementName);
        }
        if (namespace instanceof BaseContainer) {
            return this._getVisibleNestedMember((BaseContainer)namespace, elementName);
        }
        if (namespace != null) {
            return this._getVisibleNestedMember(namespace, elementName);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(namespace, elementName).toString());
    }

    @Pure
    public static UML2xtumlrtTranslator getTranslator() {
        return translator;
    }

    public static void setTranslator(UML2xtumlrtTranslator translator) {
        XTUMLRTScope.translator = translator;
    }
}

