/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.compare.internal;

import com.google.common.collect.Collections2;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.internal.postprocessor.factories.IChangeFactory;
import org.eclipse.emf.compare.postprocessor.IPostProcessor;
import org.eclipse.emf.compare.uml2.internal.UMLDiff;
import org.eclipse.papyrusrt.umlrt.tooling.compare.internal.UMLRTCompareUtil;
import org.eclipse.papyrusrt.umlrt.tooling.compare.internal.UMLRTExtensionFactoryRegistry;
import org.eclipse.papyrusrt.umlrt.tooling.compare.umlrt.internal.UMLRTDiagramChange;

public class UMLRTPostProcessor
implements IPostProcessor {
    private Map<Class<? extends Diff>, IChangeFactory> umlRtExtensionFactoriesMap;

    public void postComparison(Comparison comparison, Monitor monitor) {
        this.applyUMLRTDiffExtensions(comparison);
        this.addRequirementsBetweenDiagramDiffsAndModelDiffs(comparison);
    }

    private void applyUMLRTDiffExtensions(Comparison comparison) {
        this.umlRtExtensionFactoriesMap = this.createExtensionFactories();
        this.createUMLRTDiffExtensions(comparison);
        this.fillRequiredDifferences(comparison);
    }

    private Map<Class<? extends Diff>, IChangeFactory> createExtensionFactories() {
        return UMLRTExtensionFactoryRegistry.createExtensionFactories();
    }

    private void createUMLRTDiffExtensions(Comparison comparison) {
        for (Diff diff : comparison.getDifferences()) {
            this.createUMLRTDiffExtension(diff);
        }
    }

    private void createUMLRTDiffExtension(Diff element) {
        for (IChangeFactory factory : this.umlRtExtensionFactoriesMap.values()) {
            Match match;
            Diff extension;
            if (!factory.handles(element) || (extension = factory.create(element)).getRefinedBy().isEmpty() || (match = factory.getParentMatch(element)) == null) continue;
            match.getDifferences().add((Object)extension);
        }
    }

    private void fillRequiredDifferences(Comparison comparison) {
        for (Diff umlDiff : comparison.getDifferences()) {
            Class classDiffElement;
            IChangeFactory diffFactory;
            if (!(umlDiff instanceof UMLDiff) || (diffFactory = this.umlRtExtensionFactoriesMap.get(classDiffElement = umlDiff.eClass().getInstanceClass())) == null) continue;
            diffFactory.fillRequiredDifferences(comparison, umlDiff);
        }
    }

    private void addRequirementsBetweenDiagramDiffsAndModelDiffs(Comparison comparison) {
        for (Match capsuleDiagramMatch : Collections2.filter((Collection)comparison.getMatches(), UMLRTCompareUtil.CAPSULE_DIAGRAM_MATCH)) {
            UnmodifiableIterator diagramChangeIterator = Iterators.filter((Iterator)capsuleDiagramMatch.eAllContents(), UMLRTDiagramChange.class);
            while (diagramChangeIterator.hasNext()) {
                UMLRTDiagramChange umlrtDiagramChange = (UMLRTDiagramChange)diagramChangeIterator.next();
                if (umlrtDiagramChange.getSemanticDiff() == null) continue;
                if (!umlrtDiagramChange.getSemanticDiff().getRefines().isEmpty()) {
                    this.addBidirectionalRequirement((Diff)umlrtDiagramChange, (Diff)umlrtDiagramChange.getSemanticDiff().getRefines().get(0));
                    continue;
                }
                this.addBidirectionalRequirement((Diff)umlrtDiagramChange, umlrtDiagramChange.getSemanticDiff());
            }
        }
    }

    private void addBidirectionalRequirement(Diff diff1, Diff diff2) {
        diff1.getRequires().add((Object)diff2);
        diff1.getRequiredBy().add((Object)diff2);
    }

    public void postConflicts(Comparison comparison, Monitor monitor) {
    }

    public void postMatch(Comparison comparison, Monitor monitor) {
    }

    public void postDiff(Comparison comparison, Monitor monitor) {
    }

    public void postRequirements(Comparison comparison, Monitor monitor) {
    }

    public void postEquivalences(Comparison comparison, Monitor monitor) {
    }
}

