/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.diagram.common.command;

import java.util.Objects;
import java.util.Optional;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.commands.CreateViewCommand;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.utils.EditPartInheritanceUtils;

public class CreateOrReuseViewCommand
extends CreateViewCommand {
    public CreateOrReuseViewCommand(TransactionalEditingDomain editingDomain, CreateViewRequest.ViewDescriptor viewDescriptor, View containerView) {
        super(editingDomain, viewDescriptor, containerView);
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        Optional<View> view = this.findView();
        if (view.isPresent()) {
            this.viewDescriptor.setView(view.get());
            return CommandResult.newOKCommandResult((Object)this.viewDescriptor);
        }
        return super.doExecuteWithResult(monitor, info);
    }

    protected Optional<View> findView() {
        return this.containerView.getChildren().stream().map(View.class::cast).filter(this::representsElement).findFirst();
    }

    public boolean canExecute() {
        return true;
    }

    protected boolean representsElement(View view) {
        if (!this.viewDescriptor.getViewKind().isAssignableFrom(view.getClass()) || !Objects.equals(view.getType(), this.viewDescriptor.getSemanticHint())) {
            return false;
        }
        IAdaptable elementAdapter = this.viewDescriptor.getElementAdapter();
        if (elementAdapter != null) {
            EObject linkedObject = (EObject)elementAdapter.getAdapter(EObject.class);
            if (Objects.equals(EditPartInheritanceUtils.resolveSemanticElement(view), linkedObject)) {
                return true;
            }
        }
        return false;
    }
}

