/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.tables.manager.axis;

import java.util.Optional;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrusrt.umlrt.core.utils.EMFHacks;
import org.eclipse.papyrusrt.umlrt.tooling.tables.manager.axis.RTSynchronizedOnFeatureAxisManager;

public class TransactionalSynchronizedOnFeatureAxisManager
extends RTSynchronizedOnFeatureAxisManager {
    private Runnable listenerRemoval;

    protected void addContextFeatureValueListener() {
        if (EMFHacks.isReadWriteTransactionActive((EObject)this.getTableContext())) {
            super.addContextFeatureValueListener();
        } else {
            this.registerFeatureListener();
            this.registerRefreshListener();
        }
    }

    private void registerFeatureListener() {
        Optional<NotificationFilter> featureFilter = this.getListenFeatures().stream().map(NotificationFilter::createFeatureFilter).reduce(NotificationFilter::or);
        featureFilter.ifPresent(ff -> this.addListener((ResourceSetListener)new ResourceSetListenerImpl(NotificationFilter.createNotifierFilter((Object)this.getTableContext()).and(ff)){

            public boolean isPostcommitOnly() {
                return true;
            }

            public void resourceSetChanged(ResourceSetChangeEvent event) {
                event.getNotifications().forEach(arg_0 -> TransactionalSynchronizedOnFeatureAxisManager.access$0(TransactionalSynchronizedOnFeatureAxisManager.this, arg_0));
            }
        }));
    }

    private void registerRefreshListener() {
        Optional<NotificationFilter> refreshFilter = Optional.ofNullable(this.getRefreshFilter());
        refreshFilter.ifPresent(rf -> this.addListener((ResourceSetListener)new ResourceSetListenerImpl((NotificationFilter)rf){

            public boolean isPostcommitOnly() {
                return true;
            }

            public void resourceSetChanged(ResourceSetChangeEvent event) {
                TransactionalSynchronizedOnFeatureAxisManager.this.refreshTable();
            }
        }));
    }

    protected final void addListener(ResourceSetListener listener) {
        TransactionalEditingDomain contextDomain = this.getContextEditingDomain();
        contextDomain.addResourceSetListener(listener);
        if (this.listenerRemoval == null) {
            this.listenerRemoval = () -> contextDomain.removeResourceSetListener(listener);
        } else {
            Runnable next = this.listenerRemoval;
            this.listenerRemoval = () -> {
                contextDomain.removeResourceSetListener(listener);
                next.run();
            };
        }
    }

    protected NotificationFilter getRefreshFilter() {
        return null;
    }

    protected void refreshTable() {
        this.getTableManager().updateAxisContents(this.getRepresentedContentProvider());
    }

    protected void removeListeners() {
        if (this.listenerRemoval != null) {
            this.listenerRemoval.run();
            this.listenerRemoval = null;
        }
        super.removeListeners();
    }

    static /* synthetic */ void access$0(TransactionalSynchronizedOnFeatureAxisManager transactionalSynchronizedOnFeatureAxisManager, Notification notification) {
        transactionalSynchronizedOnFeatureAxisManager.featureValueHasChanged(notification);
    }
}

