/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.ui.modelelement;

import java.util.function.Predicate;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.papyrus.infra.emf.utils.HistoryUtil;
import org.eclipse.papyrus.infra.properties.ui.providers.CreateInFeatureContentProvider;
import org.eclipse.papyrus.infra.properties.ui.providers.FeatureContentProvider;
import org.eclipse.papyrus.infra.ui.emf.providers.EMFGraphicalContentProvider;
import org.eclipse.papyrus.infra.ui.emf.providers.EMFLabelProvider;
import org.eclipse.papyrus.infra.ui.emf.utils.ProviderHelper;
import org.eclipse.papyrus.infra.widgets.creation.ReferenceValueFactory;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.uml.properties.modelelement.UMLModelElement;
import org.eclipse.papyrus.uml.tools.databinding.NamedElementValidator;
import org.eclipse.papyrus.uml.tools.providers.UMLContainerContentProvider;
import org.eclipse.papyrus.uml.tools.providers.UMLFilteredLabelProvider;
import org.eclipse.papyrusrt.umlrt.core.utils.ProtocolUtils;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.RTMessageKind;
import org.eclipse.papyrusrt.umlrt.tooling.ui.databinding.CompositeValidator;
import org.eclipse.papyrusrt.umlrt.tooling.ui.databinding.facade.CapsuleProperties;
import org.eclipse.papyrusrt.umlrt.tooling.ui.databinding.facade.NamedElementProperties;
import org.eclipse.papyrusrt.umlrt.tooling.ui.databinding.facade.ProtocolProperties;
import org.eclipse.papyrusrt.umlrt.tooling.ui.internal.modelelement.properties.FacadeListPropertyEditorFactory;
import org.eclipse.papyrusrt.umlrt.tooling.ui.internal.modelelement.properties.UMLRTCapsulePartEditorFactory;
import org.eclipse.papyrusrt.umlrt.tooling.ui.internal.modelelement.properties.UMLRTPortEditorFactory;
import org.eclipse.papyrusrt.umlrt.tooling.ui.internal.modelelement.properties.UMLRTProtocolMessageEditorFactory;
import org.eclipse.papyrusrt.umlrt.tooling.ui.internal.providers.FacadeContentProvider;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTCapsule;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTCapsulePart;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTClassifier;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTNamedElement;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTPort;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTProtocol;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTProtocolMessage;
import org.eclipse.papyrusrt.umlrt.uml.util.UMLRTSwitch;
import org.eclipse.uml2.uml.Collaboration;
import org.eclipse.uml2.uml.UMLPackage;

public class UMLRTFacadeModelElement
extends UMLModelElement {
    private static final String NAME = "name";
    private static final String PORT = "port";
    private static final String CAPSULE_PART = "capsulePart";
    private static final String INCOMING = "Incoming";
    private static final String OUTGOING = "Outgoing";
    private static final String IN_OUT = "InOut";
    private static final String SUPERCLASS = "superclass";
    private static final String SUPERTYPE = "supertype";
    UMLRTNamedElement element;

    public UMLRTFacadeModelElement(UMLRTNamedElement source) {
        super((EObject)source.toUML(), (EditingDomain)TransactionUtil.getEditingDomain((EObject)source.toUML()));
        this.element = source;
    }

    public void dispose() {
        super.dispose();
        this.element = null;
    }

    public boolean isOrdered(String propertyPath) {
        switch (propertyPath) {
            case "port": {
                return true;
            }
        }
        return super.isOrdered(propertyPath);
    }

    public EStructuralFeature getFeature(final String propertyPath) {
        return (EStructuralFeature)new UMLRTSwitch<EStructuralFeature>(){

            public EStructuralFeature caseCapsule(UMLRTCapsule object) {
                switch (propertyPath) {
                    case "port": {
                        return UMLPackage.Literals.ENCAPSULATED_CLASSIFIER__OWNED_PORT;
                    }
                    case "capsulePart": {
                        return UMLPackage.Literals.STRUCTURED_CLASSIFIER__OWNED_ATTRIBUTE;
                    }
                    case "superclass": {
                        return UMLPackage.Literals.CLASSIFIER__GENERAL;
                    }
                }
                return null;
            }

            public EStructuralFeature caseProtocol(UMLRTProtocol object) {
                switch (propertyPath) {
                    case "InOut": 
                    case "Outgoing": 
                    case "Incoming": {
                        return UMLPackage.Literals.INTERFACE__OWNED_OPERATION;
                    }
                    case "supertype": {
                        return UMLPackage.Literals.CLASSIFIER__GENERAL;
                    }
                }
                return null;
            }

            public EStructuralFeature defaultCase(Object object) {
                return UMLRTFacadeModelElement.super.getFeature(propertyPath);
            }
        }.doSwitch((Object)this.element);
    }

    public IObservable doGetObservable(final String propertyPath) {
        return (IObservable)new UMLRTSwitch<IObservable>(){

            public IObservable caseCapsule(UMLRTCapsule object) {
                switch (propertyPath) {
                    case "port": {
                        return CapsuleProperties.ports().observe(object);
                    }
                    case "capsulePart": {
                        return CapsuleProperties.capsuleParts().observe(object);
                    }
                    case "superclass": {
                        return CapsuleProperties.superclass().observe((Object)object);
                    }
                }
                return null;
            }

            public IObservable caseProtocol(UMLRTProtocol object) {
                switch (propertyPath) {
                    case "InOut": 
                    case "Outgoing": 
                    case "Incoming": {
                        RTMessageKind msgKind = UMLRTFacadeModelElement.this.getMessageKind(propertyPath);
                        return msgKind != null ? ProtocolProperties.messages(msgKind).observe(object) : null;
                    }
                    case "supertype": {
                        return ProtocolProperties.supertype().observe((Object)object);
                    }
                }
                return null;
            }

            public IObservable caseNamedElement(UMLRTNamedElement object) {
                switch (propertyPath) {
                    case "name": {
                        return NamedElementProperties.name().observe((Object)object);
                    }
                }
                return null;
            }
        }.doSwitch((Object)this.element);
    }

    public ReferenceValueFactory getValueFactory(final String propertyPath) {
        return (ReferenceValueFactory)new UMLRTSwitch<ReferenceValueFactory>(){

            public ReferenceValueFactory caseCapsule(UMLRTCapsule object) {
                FacadeListPropertyEditorFactory<UMLRTCapsulePart> result = null;
                switch (propertyPath) {
                    case "port": {
                        IObservableList ports = (IObservableList)UMLRTFacadeModelElement.this.getObservable(propertyPath);
                        EReference reference = UMLPackage.Literals.ENCAPSULATED_CLASSIFIER__OWNED_PORT;
                        result = this.complete(new UMLRTPortEditorFactory(reference, (IObservableList<UMLRTPort>)ports), reference);
                        break;
                    }
                    case "capsulePart": {
                        IObservableList parts = (IObservableList)UMLRTFacadeModelElement.this.getObservable(propertyPath);
                        EReference reference = UMLPackage.Literals.STRUCTURED_CLASSIFIER__OWNED_ATTRIBUTE;
                        result = this.complete(new UMLRTCapsulePartEditorFactory(reference, (IObservableList<UMLRTCapsulePart>)parts), reference);
                    }
                }
                return result;
            }

            public ReferenceValueFactory caseProtocol(UMLRTProtocol object) {
                FacadeListPropertyEditorFactory<UMLRTProtocolMessage> result = null;
                RTMessageKind msgKind = UMLRTFacadeModelElement.this.getMessageKind(propertyPath);
                if (msgKind != null) {
                    IObservableList messages = (IObservableList)UMLRTFacadeModelElement.this.getObservable(propertyPath);
                    EReference reference = UMLPackage.Literals.INTERFACE__OWNED_OPERATION;
                    result = this.complete(new UMLRTProtocolMessageEditorFactory(reference, msgKind, (IObservableList<UMLRTProtocolMessage>)messages), reference);
                }
                return result;
            }

            private <E extends UMLRTNamedElement> FacadeListPropertyEditorFactory<E> complete(FacadeListPropertyEditorFactory<E> factory, EReference reference) {
                EClass type = reference.getEReferenceType();
                factory.setContainerLabelProvider((ILabelProvider)new UMLFilteredLabelProvider());
                factory.setReferenceLabelProvider((ILabelProvider)new EMFLabelProvider());
                UMLContainerContentProvider contentProvider = new UMLContainerContentProvider(UMLRTFacadeModelElement.this.source, reference);
                ResourceSet rs = UMLRTFacadeModelElement.this.source == null ? null : (UMLRTFacadeModelElement.this.source.eResource() == null ? null : UMLRTFacadeModelElement.this.source.eResource().getResourceSet());
                EMFGraphicalContentProvider provider = ProviderHelper.encapsulateProvider((ITreeContentProvider)contentProvider, (ResourceSet)rs, (String)HistoryUtil.getHistoryID((EObject)UMLRTFacadeModelElement.this.source, (EStructuralFeature)reference, (String)"container"));
                factory.setContainerContentProvider((IStaticContentProvider)provider);
                factory.setReferenceContentProvider((CreateInFeatureContentProvider)new FeatureContentProvider(type));
                return factory;
            }
        }.doSwitch((Object)this.element);
    }

    private RTMessageKind getMessageKind(String propertyPath) {
        RTMessageKind result = null;
        if (this.source instanceof Collaboration) {
            if (propertyPath.endsWith(INCOMING)) {
                result = RTMessageKind.IN;
            } else if (propertyPath.endsWith(OUTGOING)) {
                result = RTMessageKind.OUT;
            } else if (propertyPath.endsWith(IN_OUT)) {
                result = RTMessageKind.IN_OUT;
            }
        }
        return result;
    }

    protected boolean isFeatureEditable(String propertyPath) {
        boolean result = true;
        switch (propertyPath) {
            case "name": {
                result = !this.element.isInherited();
            }
        }
        return result;
    }

    public IStaticContentProvider getContentProvider(final String propertyPath) {
        return (IStaticContentProvider)new UMLRTSwitch<IStaticContentProvider>(){

            public IStaticContentProvider caseCapsule(UMLRTCapsule object) {
                switch (propertyPath) {
                    case "superclass": {
                        Predicate<UMLRTNamedElement> isCapsule = UMLRTCapsule.class::isInstance;
                        Predicate<UMLRTNamedElement> isSource = UMLRTFacadeModelElement.this.element::equals;
                        return new FacadeContentProvider((UMLRTNamedElement)object, (EStructuralFeature)UMLPackage.Literals.CLASSIFIER__GENERAL, isCapsule.and(isSource.negate()));
                    }
                }
                return null;
            }

            public IStaticContentProvider caseProtocol(UMLRTProtocol object) {
                switch (propertyPath) {
                    case "supertype": {
                        Predicate<UMLRTNamedElement> isProtocol = UMLRTProtocol.class::isInstance;
                        Predicate<UMLRTNamedElement> isSource = UMLRTFacadeModelElement.this.element::equals;
                        return new FacadeContentProvider((UMLRTNamedElement)object, (EStructuralFeature)UMLPackage.Literals.CLASSIFIER__GENERAL, isProtocol.and(isSource.negate()));
                    }
                }
                return null;
            }

            public IStaticContentProvider defaultCase(Object object) {
                return UMLRTFacadeModelElement.super.getContentProvider(propertyPath);
            }
        }.doSwitch((Object)this.element);
    }

    public boolean getDirectCreation(String propertyPath) {
        boolean result;
        switch (propertyPath) {
            case "port": {
                result = true;
                break;
            }
            default: {
                result = super.getDirectCreation(propertyPath);
            }
        }
        return result;
    }

    public IValidator getValidator(String propertyPath) {
        IValidator result = super.getValidator(propertyPath);
        if (propertyPath.equals(NAME)) {
            IValidator specific = (IValidator)new UMLRTSwitch<IValidator>(){

                public IValidator caseClassifier(UMLRTClassifier object) {
                    return value -> {
                        boolean valid = value instanceof String && !((String)value).trim().isEmpty();
                        return valid ? Status.OK_STATUS : new Status(4, "org.eclipse.papyrusrt.umlrt.tooling.ui", "Name is required");
                    };
                }

                public IValidator caseProtocol(UMLRTProtocol object) {
                    NamedElementValidator packageValidator = new NamedElementValidator((EObject)ProtocolUtils.getProtocolContainer((Collaboration)object.toUML()));
                    return CompositeValidator.of(this.caseClassifier((UMLRTClassifier)object), arg_0 -> 5.lambda$1((IValidator)packageValidator, arg_0));
                }

                private static /* synthetic */ IStatus lambda$1(IValidator iValidator, Object value) {
                    return iValidator.validate(value);
                }
            }.doSwitch((Object)this.element);
            result = CompositeValidator.of(result, specific);
        }
        return result;
    }
}

