/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.uml.internal.operations;

import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.DelegatingEcoreEList;
import org.eclipse.emf.ecore.util.EcoreEList;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.RTRedefinedElement;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.UMLRealTimePackage;
import org.eclipse.papyrusrt.umlrt.uml.internal.impl.InternalUMLRTElement;
import org.eclipse.papyrusrt.umlrt.uml.internal.impl.InternalUMLRTNamespace;
import org.eclipse.papyrusrt.umlrt.uml.internal.impl.InternalUMLRTRedefinitionContext;
import org.eclipse.papyrusrt.umlrt.uml.internal.operations.ElementRTOperations;
import org.eclipse.papyrusrt.umlrt.uml.internal.umlext.ExtElement;
import org.eclipse.papyrusrt.umlrt.uml.util.UMLRTExtensionUtil;
import org.eclipse.uml2.common.util.CacheAdapter;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.LiteralBoolean;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.RedefinableElement;
import org.eclipse.uml2.uml.util.UMLUtil;

public class RedefinableElementRTOperations
extends UMLUtil {
    protected RedefinableElementRTOperations() {
    }

    public static <R extends InternalUMLRTElement> R getRedefinedElement(R element) {
        InternalUMLRTElement result = null;
        if (element instanceof RedefinableElement) {
            result = null;
            EList redefined = ((RedefinableElement)element).getRedefinedElements();
            EClass metaclass = element.eClass();
            for (RedefinableElement next : redefined) {
                if (next.eClass() != metaclass) continue;
                result = (InternalUMLRTElement)next;
                break;
            }
        }
        return (R)result;
    }

    public static <R extends InternalUMLRTElement & RedefinableElement> R resolveRedefinedElement(InternalUMLRTElement element, R redefinedElement) {
        R candidate;
        InternalUMLRTRedefinitionContext context;
        Object ancestor;
        R result = redefinedElement;
        Element owner = element.rtOwner();
        if (owner instanceof InternalUMLRTRedefinitionContext && (ancestor = (context = (InternalUMLRTRedefinitionContext)owner).rtGetAncestor()) != null && result.rtOwner() != ancestor && (candidate = ancestor.rtGetRedefinitionOf(redefinedElement)) != null) {
            result = candidate;
        }
        return result;
    }

    public static <R extends InternalUMLRTElement, T> T inheritFeature(R element, EStructuralFeature feature) {
        Object result = null;
        if (element != null) {
            if (element.rtIsSet(feature)) {
                result = element.umlGet(feature);
            } else {
                Object redefined;
                Object object = redefined = element instanceof InternalUMLRTRedefinitionContext ? (InternalUMLRTElement)((InternalUMLRTRedefinitionContext)element).rtGetAncestor() : element.rtGetRedefinedElement();
                if (redefined != null) {
                    result = redefined.eGet(feature);
                }
            }
        }
        if (result == null) {
            result = feature.getDefaultValue();
        }
        return (T)result;
    }

    public static <R extends InternalUMLRTElement, T> T inheritFeature(R element, EStructuralFeature feature, CacheAdapter cache) {
        Object result;
        if (cache == null) {
            result = RedefinableElementRTOperations.inheritFeature(element, feature);
        } else {
            Object cached = cache.get(element, (Object)feature);
            if (cached == null) {
                cached = RedefinableElementRTOperations.inheritFeature(element, feature);
                cache.put(element, (Object)feature, cached);
            }
            result = cached;
        }
        return result;
    }

    public static <R extends InternalUMLRTElement, T> T inheritReference(R element, EReference reference, CacheAdapter cache, Function<? super EObject, ? extends EObject> inheritanceResolver) {
        Object result;
        if (cache == null) {
            Object resolved;
            result = resolved = RedefinableElementRTOperations.resolveInheritedReference(RedefinableElementRTOperations.inheritFeature(element, (EStructuralFeature)reference), inheritanceResolver);
        } else {
            Object cached = cache.get(element, (Object)reference);
            if (cached == null) {
                Object resolved;
                cached = resolved = RedefinableElementRTOperations.resolveInheritedReference(RedefinableElementRTOperations.inheritFeature(element, (EStructuralFeature)reference), inheritanceResolver);
                cache.put(element, (Object)reference, cached);
            }
            result = cached;
        }
        return (T)result;
    }

    public static Object resolveInheritedReference(Object value, Function<? super EObject, ? extends EObject> inheritanceResolver) {
        return value instanceof EObject ? RedefinableElementRTOperations.resolveOne((EObject)value, inheritanceResolver) : (value instanceof List ? RedefinableElementRTOperations.resolveMany((List)value, inheritanceResolver) : value);
    }

    private static EObject resolveOne(EObject eObject, Function<? super EObject, ? extends EObject> inheritanceResolver) {
        return inheritanceResolver.apply((EObject)eObject);
    }

    private static List<EObject> resolveMany(List<? extends EObject> eObjects, final Function<? super EObject, ? extends EObject> inheritanceResolver) {
        final EcoreEList delegate = (EcoreEList)eObjects;
        return new DelegatingEcoreEList<EObject>((InternalEObject)delegate.getEObject()){
            private static final long serialVersionUID = 1L;

            protected List<EObject> delegateList() {
                return delegate;
            }

            public int getFeatureID() {
                return delegate.getFeatureID();
            }

            public Object getFeature() {
                return delegate.getFeature();
            }

            protected EObject delegateGet(int index) {
                return (EObject)inheritanceResolver.apply(super.delegateGet(index));
            }
        };
    }

    public static boolean isRedefinition(InternalUMLRTElement element) {
        boolean result = element.rtIsVirtual();
        if (!result) {
            result = element.rtGetRedefinedElement() != null;
        }
        return result;
    }

    public static boolean isExcluded(InternalUMLRTElement element) {
        Element uml;
        boolean result = false;
        Element element2 = uml = element instanceof Element ? (Element)element : UMLUtil.getBaseElement((EObject)element);
        if (!(uml instanceof RedefinableElement)) {
            InternalUMLRTElement context;
            Object root = element.rtGetRootDefinition();
            if (root instanceof Element && root != element && (context = RedefinableElementRTOperations.redefinableOwner(element)) instanceof Namespace) {
                for (Constraint next : ((Namespace)context).getOwnedRules()) {
                    if (!(next.getSpecification() instanceof LiteralBoolean) || ((LiteralBoolean)next.getSpecification()).isValue() || !next.getConstrainedElements().contains(root)) continue;
                    result = true;
                    break;
                }
            }
            return result;
        }
        RTRedefinedElement rtRedef = (RTRedefinedElement)UMLUtil.getStereotypeApplication((Element)uml, RTRedefinedElement.class);
        result = rtRedef != null && rtRedef.getRootFragment() == null;
        return result;
    }

    public static boolean exclude(InternalUMLRTElement element) {
        boolean result = false;
        if (!element.rtIsExcluded() && (result = element instanceof RedefinableElement ? RedefinableElementRTOperations.excludeRedefinable(element) : RedefinableElementRTOperations.excludeExceptional(element))) {
            element.rtGetRedefinitions().skip(1L).collect(Collectors.toList()).forEach(InternalUMLRTElement::rtDelete);
        }
        return result;
    }

    private static boolean excludeRedefinable(InternalUMLRTElement element) {
        boolean result = false;
        Element uml = element.rtGetElement();
        RTRedefinedElement rtRedef = (RTRedefinedElement)UMLUtil.getStereotypeApplication((Element)uml, RTRedefinedElement.class);
        if (rtRedef == null) {
            rtRedef = (RTRedefinedElement)UMLUtil.StereotypeApplicationHelper.getInstance((Notifier)uml).applyStereotype(uml, UMLRealTimePackage.Literals.RT_REDEFINED_ELEMENT);
        }
        if (rtRedef != null) {
            if (rtRedef.getRootFragment() != null) {
                rtRedef.setRootFragment(null);
            }
            result = true;
            InternalUMLRTElement next = element;
            while (next != null && next.rtIsVirtual()) {
                next.rtReify();
                InternalEObject container = next.eInternalContainer();
                next = container instanceof InternalUMLRTElement ? (InternalUMLRTElement)container : null;
            }
        }
        return result;
    }

    private static boolean excludeExceptional(InternalUMLRTElement element) {
        boolean result = false;
        Object root = element.rtGetRootDefinition();
        if (root instanceof Element && root != element) {
            Element rootDefinition = (Element)root;
            InternalUMLRTElement context = RedefinableElementRTOperations.redefinableOwner(element);
            if (context instanceof InternalUMLRTNamespace) {
                ((InternalUMLRTNamespace)context).rtCreateExclusionConstraint(rootDefinition);
                result = true;
                InternalUMLRTElement next = context;
                while (next != null && next.rtIsVirtual()) {
                    next.rtReify();
                    InternalEObject container = next.eInternalContainer();
                    next = container instanceof InternalUMLRTElement ? (InternalUMLRTElement)container : null;
                }
            }
        }
        return result;
    }

    private static InternalUMLRTElement redefinableOwner(InternalUMLRTElement element) {
        InternalUMLRTElement result = null;
        Element owner = element.rtOwner();
        while (result == null) {
            if (owner instanceof InternalUMLRTElement) {
                if (owner instanceof RedefinableElement) {
                    result = (InternalUMLRTElement)owner;
                    continue;
                }
                owner = ((InternalUMLRTElement)owner).rtOwner();
                continue;
            }
            owner = null;
        }
        return result;
    }

    public static boolean reinherit(InternalUMLRTElement element) {
        Element owner;
        boolean result = false;
        if (element.rtIsRedefinition() && (result = element instanceof RedefinableElement ? RedefinableElementRTOperations.reinheritRedefinable(element) : RedefinableElementRTOperations.reinheritExceptional(element)) && (owner = element.rtOwner()) instanceof InternalUMLRTRedefinitionContext) {
            InternalUMLRTRedefinitionContext context = (InternalUMLRTRedefinitionContext)owner;
            context.rtDescendants().forEach(descendant -> descendant.rtInherit(descendant.rtGetAncestor()));
        }
        return result;
    }

    private static boolean reinheritRedefinable(InternalUMLRTElement element) {
        boolean result = element.eContents().stream().filter(InternalUMLRTElement.class::isInstance).map(InternalUMLRTElement.class::cast).reduce(false, (r, e) -> e.rtReinherit() || r != false, Boolean::logicalOr);
        Element uml = element.rtGetElement();
        Object root = element.rtGetRootDefinition();
        RTRedefinedElement rtRedef = (RTRedefinedElement)UMLUtil.getStereotypeApplication((Element)uml, RTRedefinedElement.class);
        if (rtRedef != null) {
            rtRedef.setRootFragment((RedefinableElement)root);
            ElementRTOperations.delete((EObject)rtRedef);
            result = true;
        }
        element.rtVirtualize();
        return result;
    }

    private static boolean reinheritExceptional(InternalUMLRTElement element) {
        InternalUMLRTElement context;
        boolean result = false;
        Object root = element.rtGetRootDefinition();
        if (root instanceof Element && root != element && (context = RedefinableElementRTOperations.redefinableOwner(element)) instanceof Namespace) {
            for (Constraint next : ((Namespace)context).getOwnedRules()) {
                if (!(next.getSpecification() instanceof LiteralBoolean) || ((LiteralBoolean)next.getSpecification()).isValue() || !next.getConstrainedElements().contains(root)) continue;
                ElementRTOperations.delete((EObject)next);
                result = true;
                break;
            }
        }
        return result;
    }

    public static <R extends RedefinableElement & InternalUMLRTElement> void redefine(R element, R redefined) {
        UMLRTExtensionUtil.run(element, () -> {
            ((InternalUMLRTElement)element).umlSetRedefinedElement(redefined);
            RTRedefinedElement inherited = (RTRedefinedElement)UMLUtil.getStereotypeApplication((Element)redefined, RTRedefinedElement.class);
            if (inherited != null) {
                RTRedefinedElement stereo = (RTRedefinedElement)UMLUtil.getStereotypeApplication((Element)element, RTRedefinedElement.class);
                if (stereo == null) {
                    stereo = (RTRedefinedElement)UMLUtil.StereotypeApplicationHelper.getInstance((Notifier)element).applyStereotype((Element)element, UMLRealTimePackage.Literals.RT_REDEFINED_ELEMENT);
                }
                stereo.setRootFragment(inherited.getRootFragment());
            }
            ((InternalUMLRTElement)element).rtAdjustStereotypes();
        });
    }

    public static <R extends RedefinableElement & InternalUMLRTElement> void ensureStereotype(R element) {
        UMLRTExtensionUtil.run(element, () -> {
            RTRedefinedElement stereo = (RTRedefinedElement)UMLUtil.getStereotypeApplication((Element)element, RTRedefinedElement.class);
            if (stereo == null) {
                stereo = (RTRedefinedElement)UMLUtil.StereotypeApplicationHelper.getInstance((Notifier)element).applyStereotype((Element)element, UMLRealTimePackage.Literals.RT_REDEFINED_ELEMENT);
                RedefinableElement root = (RedefinableElement)((InternalUMLRTElement)element).rtGetRootDefinition();
                stereo.setRootFragment(root);
            }
        });
    }

    public static Element getOwner(InternalEObject element) {
        InternalEObject result = element.eInternalContainer();
        if (result instanceof ExtElement) {
            result = ((ExtElement)result).getExtendedElement();
        }
        return result instanceof Element ? (Element)result : null;
    }

    public static <R extends InternalUMLRTElement> R getNearestDefinition(R element, Predicate<? super R> matching) {
        R result = element;
        if (!matching.test(result)) {
            int count = 0;
            Object redefined = result.rtGetRedefinedElement();
            while (redefined != null) {
                if (++count > 100000) {
                    return RedefinableElementRTOperations.getNearestDefinition(redefined, matching);
                }
                if (redefined == element) {
                    throw new IllegalStateException("Redefinition cycle including " + element);
                }
                result = redefined;
                if (matching.test(result)) break;
                redefined = result.rtGetRedefinedElement();
            }
        }
        return result;
    }
}

