/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.xtumlrt.aexpr.lexer;

import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Predicate;
import org.eclipse.papyrusrt.xtumlrt.aexpr.lexer.tokens.Delimiter;
import org.eclipse.papyrusrt.xtumlrt.aexpr.lexer.tokens.EndOfText;
import org.eclipse.papyrusrt.xtumlrt.aexpr.lexer.tokens.Identifier;
import org.eclipse.papyrusrt.xtumlrt.aexpr.lexer.tokens.Keyword;
import org.eclipse.papyrusrt.xtumlrt.aexpr.lexer.tokens.Number;
import org.eclipse.papyrusrt.xtumlrt.aexpr.lexer.tokens.Operator;
import org.eclipse.papyrusrt.xtumlrt.aexpr.lexer.tokens.QualifiedIdentifier;
import org.eclipse.papyrusrt.xtumlrt.aexpr.lexer.tokens.Token;
import org.eclipse.papyrusrt.xtumlrt.aexpr.lexer.tokens.Unknown;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;

public class TokenSequence
implements Iterable<Token> {
    private static final String DEFAULT_QUAL_ID_SEP = ".";
    private static final int DEFAULT_TAB_SIZE = 4;
    private String text;
    private Set<String> keywords;
    private Set<String> operators;
    private String qualifiedIdSeparator;
    private int tabSize;

    public TokenSequence(String text) {
        HashSet _newHashSet_1;
        HashSet _newHashSet;
        this.text = text;
        this.keywords = _newHashSet = CollectionLiterals.newHashSet((Object[])new String[0]);
        this.operators = _newHashSet_1 = CollectionLiterals.newHashSet((Object[])new String[0]);
        this.qualifiedIdSeparator = DEFAULT_QUAL_ID_SEP;
        this.tabSize = 4;
    }

    public TokenSequence(String text, Set<String> keywords, Set<String> operators, String qualIdSeparator, int tabSize) {
        this.text = text;
        this.keywords = keywords;
        this.operators = operators;
        this.qualifiedIdSeparator = qualIdSeparator;
        this.tabSize = tabSize;
    }

    @Override
    public Iterator<Token> iterator() {
        TokensIteratorImpl _xblockexpression = null;
        TokensIteratorImpl it = new TokensIteratorImpl();
        it.setSource(this.text);
        it.setKeywords(this.keywords);
        it.setOperators(this.operators);
        it.setQualIdSeparator(this.qualifiedIdSeparator);
        it.setTabSize(this.tabSize);
        _xblockexpression = it;
        return _xblockexpression;
    }

    public static interface TokensIterator
    extends Iterator<Token> {
        public Token lookAhead();

        public Token consume();
    }

    public static class TokensIteratorImpl
    implements TokensIterator {
        private static final char TAB = '\t';
        private static final char NEWLINE = '\n';
        @Accessors
        private String source;
        private char[] chars;
        private int currentPosition;
        private int advancedPosition;
        private int currentLine;
        private int currentColumn;
        private int advancedLine;
        private int advancedColumn;
        private int tabSize;
        private char observedChar;
        private Token tokenAhead;
        private Set<String> recognizedKeywords;
        private Set<String> recognizedOperators;
        private Set<Character> operatorsFirstChar;
        private Set<Character> validOperatorChars;
        private String qualIdSeparator;

        public TokensIteratorImpl() {
            HashSet _newHashSet_2;
            HashSet _newHashSet_1;
            HashSet _newHashSet;
            this.setSource("");
            this.recognizedKeywords = _newHashSet = CollectionLiterals.newHashSet((Object[])new String[0]);
            this.recognizedOperators = _newHashSet_1 = CollectionLiterals.newHashSet((Object[])((String[])Conversions.unwrapArray(Operator.BUILT_IN_STR, String.class)));
            this.operatorsFirstChar = _newHashSet_2 = CollectionLiterals.newHashSet((Object[])((Character[])Conversions.unwrapArray(Operator.BUILT_IN_CHAR, Character.class)));
            HashSet<Character> _validOperatorChars = this.getValidOperatorChars(this.recognizedOperators);
            this.validOperatorChars = _validOperatorChars;
            this.qualIdSeparator = TokenSequence.DEFAULT_QUAL_ID_SEP;
            this.tabSize = 4;
        }

        public boolean setKeywords(Iterable<String> kwds) {
            return Iterables.addAll(this.recognizedKeywords, kwds);
        }

        public boolean setOperators(Iterable<String> operators) {
            boolean _xblockexpression = false;
            Functions.Function1<String, Boolean> _function = new Functions.Function1<String, Boolean>(){

                public Boolean apply(String it) {
                    return this.validOperatorSymbol(it);
                }
            };
            Iterable ops = IterableExtensions.filter(operators, (Functions.Function1)_function);
            Iterables.addAll(this.recognizedOperators, (Iterable)ops);
            Functions.Function1<String, Character> _function_1 = new Functions.Function1<String, Character>(){

                public Character apply(String it) {
                    return Character.valueOf(it.charAt(0));
                }
            };
            Iterable _map = IterableExtensions.map((Iterable)ops, (Functions.Function1)_function_1);
            Iterables.addAll(this.operatorsFirstChar, (Iterable)_map);
            HashSet<Character> _validOperatorChars = this.getValidOperatorChars(ops);
            _xblockexpression = this.validOperatorChars.addAll(_validOperatorChars);
            return _xblockexpression;
        }

        public String setQualIdSeparator(String sep) {
            this.qualIdSeparator = sep;
            return this.qualIdSeparator;
        }

        public char setSource(String text) {
            char _xblockexpression = '\u0000';
            this.source = text;
            _xblockexpression = this.initialize();
            return _xblockexpression;
        }

        public int setTabSize(int n) {
            this.tabSize = n;
            return this.tabSize;
        }

        private HashSet<Character> getValidOperatorChars(Iterable<String> ops) {
            HashSet _xblockexpression = null;
            HashSet result = CollectionLiterals.newHashSet((Object[])new Character[0]);
            for (String op : ops) {
                char[] _charArray = op.toCharArray();
                result.addAll((Collection)Conversions.doWrapArray((Object)_charArray));
            }
            _xblockexpression = result;
            return _xblockexpression;
        }

        private char initialize() {
            char _xblockexpression = '\u0000';
            char[] _charArray = this.source.toCharArray();
            this.chars = _charArray;
            this.currentPosition = 0;
            this.advancedPosition = 0;
            this.currentLine = 0;
            this.currentColumn = 0;
            _xblockexpression = this.observeChar();
            return _xblockexpression;
        }

        @Override
        public boolean hasNext() {
            int _length = this.chars.length;
            return this.currentPosition < _length;
        }

        @Override
        public Token next() {
            Token _xifexpression = null;
            boolean _hasNext = this.hasNext();
            if (!_hasNext) {
                throw new NoSuchElementException("Reached the end of text.");
            }
            Token _xblockexpression = null;
            this.lookAhead();
            _xifexpression = _xblockexpression = this.consume();
            return _xifexpression;
        }

        @Override
        public Token consume() {
            Token _xblockexpression = null;
            Token nextToken = this.tokenAhead;
            this.moveCurrentPositionForward();
            this.tokenAhead = null;
            _xblockexpression = nextToken;
            return _xblockexpression;
        }

        @Override
        public Token lookAhead() {
            Token _xblockexpression = null;
            if (this.tokenAhead == null) {
                boolean _isEOT;
                boolean _isBracket;
                boolean _isOperatorStart;
                boolean _isIdentifierStart;
                this.resetAdvancedPosition();
                this.skipSpaces();
                this.moveCurrentPositionForward();
                this.observeChar();
                Token _switchResult = null;
                boolean _matched = false;
                boolean _isDigit = this.isDigit(this.observedChar);
                if (_isDigit) {
                    _matched = true;
                    _switchResult = this.nextNumber();
                }
                if (!_matched && (_isIdentifierStart = this.isIdentifierStart(this.observedChar))) {
                    _matched = true;
                    _switchResult = this.nextIdentifierOrKeyword();
                }
                if (!_matched && (_isOperatorStart = this.isOperatorStart(this.observedChar))) {
                    _matched = true;
                    _switchResult = this.nextOperator();
                }
                if (!_matched && (_isBracket = this.isBracket(this.observedChar))) {
                    _matched = true;
                    _switchResult = this.nextBracket();
                }
                if (!_matched && (_isEOT = this.isEOT(this.observedChar))) {
                    _matched = true;
                    _switchResult = this.eot();
                }
                if (!_matched) {
                    _switchResult = this.unknown();
                }
                this.tokenAhead = _switchResult;
            }
            _xblockexpression = this.tokenAhead;
            return _xblockexpression;
        }

        private char observeChar() {
            boolean _lessThan;
            char _xifexpression = '\u0000';
            int _length = this.chars.length;
            boolean bl = _lessThan = this.advancedPosition < _length;
            if (_lessThan) {
                char _get;
                _xifexpression = this.observedChar = (_get = this.chars[this.advancedPosition]);
            } else {
                this.observedChar = '\u0000';
                _xifexpression = '\u0000';
            }
            return _xifexpression;
        }

        private int resetAdvancedPosition() {
            int _xblockexpression = 0;
            this.advancedPosition = this.currentPosition;
            this.advancedLine = this.currentLine;
            _xblockexpression = this.advancedColumn = this.currentColumn;
            return _xblockexpression;
        }

        private int moveCurrentPositionForward() {
            int _xblockexpression = 0;
            this.currentPosition = this.advancedPosition;
            this.currentLine = this.advancedLine;
            _xblockexpression = this.currentColumn = this.advancedColumn;
            return _xblockexpression;
        }

        private Number nextNumber() {
            Predicate<Character> _function = new Predicate<Character>(){

                @Override
                public boolean test(Character it) {
                    return this.isDigit(it.charValue());
                }
            };
            String _nextMultiCharToken = this.nextMultiCharToken(_function);
            return new Number(this.currentLine, this.currentColumn, _nextMultiCharToken);
        }

        private Token nextIdentifierOrKeyword() {
            Token _xblockexpression = null;
            Predicate<Character> _function = new Predicate<Character>(){

                @Override
                public boolean test(Character it) {
                    return this.isIdentifierPart(it.charValue());
                }
            };
            String tokenStr = this.nextMultiCharToken(_function);
            boolean qualified = false;
            while (this.follows(this.qualIdSeparator) && this.moreQualIdSegmentsAhead()) {
                qualified = true;
                String _kenStr = tokenStr;
                Predicate<Character> _function_1 = new Predicate<Character>(){

                    @Override
                    public boolean test(Character it) {
                        return this.isQualIdSeparatorPart(it.charValue());
                    }
                };
                String _nextMultiCharToken = this.nextMultiCharToken(_function_1);
                String _kenStr_1 = tokenStr = String.valueOf(_kenStr) + _nextMultiCharToken;
                Predicate<Character> _function_2 = new Predicate<Character>(){

                    @Override
                    public boolean test(Character it) {
                        return this.isIdentifierPart(it.charValue());
                    }
                };
                String _nextMultiCharToken_1 = this.nextMultiCharToken(_function_2);
                tokenStr = String.valueOf(_kenStr_1) + _nextMultiCharToken_1;
            }
            Token _xifexpression = null;
            if (qualified) {
                QualifiedIdentifier _qualifiedIdentifier = new QualifiedIdentifier(this.currentLine, this.currentColumn, tokenStr);
                Procedures.Procedure1<QualifiedIdentifier> _function_1 = new Procedures.Procedure1<QualifiedIdentifier>(){

                    public void apply(QualifiedIdentifier it) {
                        it.setSeparator(qualIdSeparator);
                    }
                };
                _xifexpression = (Token)ObjectExtensions.operator_doubleArrow((Object)_qualifiedIdentifier, (Procedures.Procedure1)_function_1);
            } else {
                Token _xifexpression_1 = null;
                boolean _isKeyword = this.isKeyword(tokenStr);
                _xifexpression_1 = _isKeyword ? new Keyword(this.currentLine, this.currentColumn, tokenStr) : new Identifier(this.currentLine, this.currentColumn, tokenStr);
                _xifexpression = _xifexpression_1;
            }
            _xblockexpression = _xifexpression;
            return _xblockexpression;
        }

        private Token nextOperator() {
            Token _xblockexpression = null;
            Predicate<Character> _function = new Predicate<Character>(){

                @Override
                public boolean test(Character it) {
                    return this.isOperatorPart(it.charValue());
                }
            };
            String tokenStr = this.nextMultiCharToken(_function);
            Token _xifexpression = null;
            boolean _isMultiCharOperator = this.isMultiCharOperator(tokenStr);
            _xifexpression = _isMultiCharOperator ? new Operator(this.currentLine, this.currentColumn, tokenStr) : new Unknown(this.currentLine, this.currentColumn, tokenStr);
            _xblockexpression = _xifexpression;
            return _xblockexpression;
        }

        private Delimiter nextBracket() {
            String _nextSingleCharToken = this.nextSingleCharToken();
            return new Delimiter(this.currentLine, this.currentColumn, _nextSingleCharToken);
        }

        private EndOfText eot() {
            return new EndOfText(this.currentLine, this.currentColumn);
        }

        private Unknown unknown() {
            Predicate<Character> _function = new Predicate<Character>(){

                @Override
                public boolean test(Character it) {
                    return this.isUnknown(it.charValue());
                }
            };
            String _nextMultiCharToken = this.nextMultiCharToken(_function);
            return new Unknown(this.currentLine, this.currentColumn, _nextMultiCharToken);
        }

        private void skipSpaces() {
            while (this.advancedPosition < this.chars.length && this.isSpace(this.observedChar)) {
                this.advance();
            }
        }

        private String nextSingleCharToken() {
            String _xblockexpression = null;
            String str = "" + Character.valueOf(this.observedChar);
            this.advance();
            _xblockexpression = str;
            return _xblockexpression;
        }

        private String nextMultiCharToken(Predicate<Character> condition) {
            String _xblockexpression = null;
            String str = "";
            while (this.advancedPosition < this.chars.length && condition.test(Character.valueOf(this.observedChar))) {
                String _str = str;
                str = String.valueOf(_str) + Character.valueOf(this.observedChar);
                this.advance();
            }
            _xblockexpression = str;
            return _xblockexpression;
        }

        private char advance() {
            boolean _lessThan;
            char _xifexpression = '\u0000';
            int _length = this.chars.length;
            boolean bl = _lessThan = this.advancedPosition < _length;
            if (_lessThan) {
                char _xblockexpression = '\u0000';
                char observedChar = this.observedChar;
                switch (observedChar) {
                    case '\n': {
                        ++this.advancedLine;
                        this.advancedColumn = 0;
                        break;
                    }
                    case '\t': {
                        int _advancedColumn = this.advancedColumn;
                        this.advancedColumn = _advancedColumn + (this.tabSize - this.advancedColumn % this.tabSize);
                        break;
                    }
                    default: {
                        ++this.advancedColumn;
                    }
                }
                ++this.advancedPosition;
                _xifexpression = _xblockexpression = this.observeChar();
            } else {
                this.observedChar = '\u0000';
                _xifexpression = '\u0000';
            }
            return _xifexpression;
        }

        /*
         * Unable to fully structure code
         */
        private boolean follows(String expected) {
            result = true;
            i = this.advancedPosition;
            j = 0;
            if (expected != null && !expected.isEmpty() && i + expected.length() <= this.chars.length) ** GOTO lbl9
            return false;
lbl-1000:
            // 1 sources

            {
                result = result != false && this.chars[i] == expected.charAt(j);
                ++i;
                ++j;
lbl9:
                // 2 sources

                ** while (j < expected.length() && result)
            }
lbl10:
            // 1 sources

            return result;
        }

        private boolean moreQualIdSegmentsAhead() {
            return this.advancedPosition + this.qualIdSeparator.length() < this.chars.length && this.isIdentifierStart(this.chars[this.advancedPosition + this.qualIdSeparator.length()]);
        }

        private boolean isDigit(char c) {
            return Character.isDigit(c);
        }

        private boolean isIdentifierStart(char c) {
            return Character.isJavaIdentifierStart(c);
        }

        private boolean isIdentifierPart(char c) {
            return Character.isJavaIdentifierPart(c);
        }

        private boolean isOperatorStart(char c) {
            return this.operatorsFirstChar.contains(Character.valueOf(c));
        }

        private boolean isOperatorPart(char c) {
            return this.validOperatorChars.contains(Character.valueOf(c));
        }

        private boolean isMultiCharOperator(String s) {
            return this.recognizedOperators.contains(s);
        }

        private boolean isBracket(char c) {
            return Delimiter.isBracket(c);
        }

        private boolean isSpace(char c) {
            return Character.isWhitespace(c);
        }

        private boolean isEOT(char c) {
            return EndOfText.isEOT(c);
        }

        private boolean isUnknown(char c) {
            return !this.isDigit(c) && !this.isIdentifierStart(c) && !this.isOperatorStart(c) && !this.isBracket(c) && !this.isSpace(c) && !this.isEOT(c);
        }

        private boolean isKeyword(String s) {
            return this.recognizedKeywords.contains(s);
        }

        private boolean isQualIdSeparatorPart(char c) {
            int _indexOf = this.qualIdSeparator.indexOf(c);
            return _indexOf != -1;
        }

        private boolean validOperatorSymbol(String s) {
            char[] _charArray;
            if (s == null || s.isEmpty()) {
                return false;
            }
            char[] cArray = _charArray = s.toCharArray();
            int n = _charArray.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                if (this.isDigit(c) || this.isIdentifierStart(c) || this.isIdentifierPart(c) || this.isQualIdSeparatorPart(c) || this.isBracket(c) || this.isSpace(c) || this.isEOT(c)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }

        @Pure
        public String getSource() {
            return this.source;
        }
    }
}

