/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.xtumlrt.aexpr.printers;

import java.util.Arrays;
import org.eclipse.papyrusrt.xtumlrt.aexpr.ast.AExpr;
import org.eclipse.papyrusrt.xtumlrt.aexpr.ast.BinExpr;
import org.eclipse.papyrusrt.xtumlrt.aexpr.ast.Num;
import org.eclipse.papyrusrt.xtumlrt.aexpr.ast.Op;
import org.eclipse.papyrusrt.xtumlrt.aexpr.ast.OpPrecedence;
import org.eclipse.papyrusrt.xtumlrt.aexpr.ast.UnaryExpr;
import org.eclipse.papyrusrt.xtumlrt.aexpr.ast.Var;
import org.eclipse.papyrusrt.xtumlrt.aexpr.names.Name;
import org.eclipse.papyrusrt.xtumlrt.aexpr.printers.AExprPrinter;
import org.eclipse.papyrusrt.xtumlrt.aexpr.printers.NamePrinter;
import org.eclipse.papyrusrt.xtumlrt.aexpr.printers.OpPrinter;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;

public class AExprPrettyPrinter
implements AExprPrinter {
    @Extension
    private OpPrinter opPrinter = new OpPrinter();
    @Extension
    private OpPrecedence opPrecedence = new OpPrecedence();
    @Extension
    private NamePrinter namePrinter = new NamePrinter();

    @Override
    public String toText(AExpr e) {
        return this.relativeToText(e, Op.NOOP);
    }

    private String _relativeToText(Num e, Op parentOp) {
        StringConcatenation _builder = new StringConcatenation();
        int _value = e.getValue();
        _builder.append((Object)_value, "");
        return _builder.toString();
    }

    private String _relativeToText(Var e, Op parentOp) {
        StringConcatenation _builder = new StringConcatenation();
        Name _name = e.getName();
        CharSequence _text = this.namePrinter.toText(_name);
        _builder.append((Object)_text, "");
        return _builder.toString();
    }

    private String _relativeToText(UnaryExpr e, Op parentOp) {
        StringConcatenation _builder = new StringConcatenation();
        Op _op = e.getOp();
        boolean _bindsTighter = this.opPrecedence.bindsTighter(_op, parentOp);
        if (_bindsTighter) {
            CharSequence _unaryExprText = this.unaryExprText(e);
            _builder.append((Object)_unaryExprText, "");
        } else {
            _builder.append("(");
            CharSequence _unaryExprText_1 = this.unaryExprText(e);
            _builder.append((Object)_unaryExprText_1, "");
            _builder.append(")");
        }
        return _builder.toString();
    }

    private String _relativeToText(BinExpr e, Op parentOp) {
        StringConcatenation _builder = new StringConcatenation();
        Op _op = e.getOp();
        boolean _bindsTighter = this.opPrecedence.bindsTighter(_op, parentOp);
        if (_bindsTighter) {
            CharSequence _binExprText = this.binExprText(e);
            _builder.append((Object)_binExprText, "");
        } else {
            _builder.append("(");
            CharSequence _binExprText_1 = this.binExprText(e);
            _builder.append((Object)_binExprText_1, "");
            _builder.append(")");
        }
        return _builder.toString();
    }

    private CharSequence unaryExprText(UnaryExpr e) {
        StringConcatenation _builder = new StringConcatenation();
        Op _op = e.getOp();
        String _opText = this.opPrinter.opText(_op);
        _builder.append(_opText, "");
        AExpr _operand = e.getOperand();
        Op _op_1 = e.getOp();
        String _relativeToText = this.relativeToText(_operand, _op_1);
        _builder.append(_relativeToText, "");
        return _builder;
    }

    private CharSequence binExprText(BinExpr e) {
        StringConcatenation _builder = new StringConcatenation();
        AExpr _left = e.getLeft();
        Op _op = e.getOp();
        String _relativeToText = this.relativeToText(_left, _op);
        _builder.append(_relativeToText, "");
        _builder.append(" ");
        Op _op_1 = e.getOp();
        String _opText = this.opPrinter.opText(_op_1);
        _builder.append(_opText, "");
        _builder.append(" ");
        AExpr _right = e.getRight();
        Op _op_2 = e.getOp();
        String _relativeToText_1 = this.relativeToText(_right, _op_2);
        _builder.append(_relativeToText_1, "");
        return _builder;
    }

    private String relativeToText(AExpr e, Op parentOp) {
        if (e instanceof BinExpr) {
            return this._relativeToText((BinExpr)e, parentOp);
        }
        if (e instanceof Num) {
            return this._relativeToText((Num)e, parentOp);
        }
        if (e instanceof UnaryExpr) {
            return this._relativeToText((UnaryExpr)e, parentOp);
        }
        if (e instanceof Var) {
            return this._relativeToText((Var)e, parentOp);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(new Object[]{e, parentOp}).toString());
    }
}

