/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.cpp.validation;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrusrt.xtumlrt.util.DetailedException;
import org.eclipse.papyrusrt.xtumlrt.util.NamesUtil;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Pure;

@Data
public class ValidationException
extends DetailedException {
    private final Kind kind;
    private final EObject element;
    private final String shortMsg;
    private final String description;

    public String toString() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Validation ");
        String _kindStr = this.kindStr(this.kind);
        _builder.append(_kindStr, "");
        _builder.append(": ");
        String _trim = this.shortMsg.trim();
        _builder.append(_trim, "");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        _builder.append("Element type: ");
        String _elementTypeStr = this.getElementTypeStr();
        _builder.append(_elementTypeStr, "  ");
        _builder.append(" ");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        _builder.append("Element qualified name: ");
        String _elementQualifiedNameStr = this.getElementQualifiedNameStr();
        _builder.append(_elementQualifiedNameStr, "  ");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        _builder.append("Description: ");
        _builder.append(this.description, "  ");
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    public String kindStr(Kind kind) {
        String _switchResult = null;
        if (kind != null) {
            switch (kind) {
                case ERROR: {
                    _switchResult = "error";
                    break;
                }
                case WARNING: {
                    _switchResult = "warning";
                    break;
                }
                default: {
                    _switchResult = "info";
                    break;
                }
            }
        } else {
            _switchResult = "info";
        }
        return _switchResult;
    }

    public String getElementTypeStr() {
        if (this.element == null) {
            return "null element";
        }
        EClass _eClass = this.element.eClass();
        return _eClass.getName();
    }

    public String getElementQualifiedNameStr() {
        if (this.element == null) {
            return "null element";
        }
        if (this.element instanceof NamedElement) {
            String umlQualifiedName = ((NamedElement)this.element).getQualifiedName();
            if (umlQualifiedName != null && !umlQualifiedName.trim().isEmpty()) {
                return umlQualifiedName;
            }
            return NamesUtil.getEffectiveQualifiedName((EObject)this.element);
        }
        if (this.element instanceof Enum) {
            return ((Enum)this.element).name();
        }
        if (this.element instanceof EObject) {
            return NamesUtil.getEffectiveQualifiedName((EObject)this.element);
        }
        String _string = this.element.toString();
        return "non-UML element: " + _string;
    }

    public ValidationException(Kind kind, EObject element, String shortMsg, String description) {
        this.kind = kind;
        this.element = element;
        this.shortMsg = shortMsg;
        this.description = description;
    }

    @Pure
    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.kind == null ? 0 : this.kind.hashCode());
        result = 31 * result + (this.element == null ? 0 : this.element.hashCode());
        result = 31 * result + (this.shortMsg == null ? 0 : this.shortMsg.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        return result;
    }

    @Pure
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ValidationException other = (ValidationException)((Object)obj);
        if (this.kind == null ? other.kind != null : !this.kind.equals((Object)other.kind)) {
            return false;
        }
        if (this.element == null ? other.element != null : !this.element.equals(other.element)) {
            return false;
        }
        if (this.shortMsg == null ? other.shortMsg != null : !this.shortMsg.equals(other.shortMsg)) {
            return false;
        }
        return !(this.description == null ? other.description != null : !this.description.equals(other.description));
    }

    @Pure
    public Kind getKind() {
        return this.kind;
    }

    @Pure
    public EObject getElement() {
        return this.element;
    }

    @Pure
    public String getShortMsg() {
        return this.shortMsg;
    }

    @Pure
    public String getDescription() {
        return this.description;
    }

    public static enum Kind {
        ERROR,
        WARNING;

    }
}

