/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.lang.cpp.internal;

import java.io.ByteArrayOutputStream;
import java.util.Stack;
import org.eclipse.papyrusrt.codegen.lang.cpp.IGeneratable;
import org.eclipse.papyrusrt.codegen.lang.cpp.Name;
import org.eclipse.papyrusrt.codegen.lang.io.CodeFormatter;
import org.eclipse.papyrusrt.codegen.lang.io.ComparisonStream;

public class CppFormatter
extends CodeFormatter {
    private Stack<Name> context = new Stack();

    public static CppFormatter create(String pathname) {
        ComparisonStream stm = ComparisonStream.create((String)pathname);
        return stm == null ? null : new CppFormatter(stm);
    }

    public static CppFormatter createProvisional(String pathname) {
        ComparisonStream stm = ComparisonStream.createProvisional((String)pathname);
        return stm == null ? null : new CppFormatter(stm);
    }

    protected CppFormatter(ComparisonStream stm) {
        super(stm);
    }

    public void enter(Name name) {
        this.context.push(name);
    }

    public void exit() {
        this.context.pop();
    }

    public boolean write(Name name) {
        if (name == null) {
            this.clearPending();
            return true;
        }
        return name.writeQualified(this, this.context.isEmpty() ? null : this.context.peek());
    }

    public boolean write(IGeneratable gen, boolean withParen) {
        return (!withParen || this.write('(') && this.space()) && gen.write(this) && (!withParen || this.space() && this.write(')'));
    }

    public static CppFormatter createMemoryBased(ByteArrayOutputStream out) {
        return new CppFormatter(new ComparisonStream(out));
    }

    public static /* bridge */ /* synthetic */ CodeFormatter createProvisional(String string) {
        return CppFormatter.createProvisional(string);
    }

    public static /* bridge */ /* synthetic */ CodeFormatter create(String string) {
        return CppFormatter.create(string);
    }
}

