/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.common.ui.internal.preferences;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.plugin.RegistryReader;
import org.eclipse.papyrusrt.umlrt.common.ui.Activator;
import org.eclipse.papyrusrt.umlrt.common.ui.preferences.IToggleDialogDelegate;

public class ToggleDialogDelegateRegistry {
    private static final String EXT_PT = "toggleDialogDelegates";
    private static final String CLASS_ATTR = "class";
    private static final String DELEGATE_ELEM = "toggleDialogDelegate";
    private final Map<String, IToggleDialogDelegate> delegatesByClass = new ConcurrentHashMap<String, IToggleDialogDelegate>();

    public ToggleDialogDelegateRegistry() {
        new RegReader().readRegistry();
    }

    public Collection<IToggleDialogDelegate> getToggleDialogDelegates() {
        return Collections.unmodifiableCollection(this.delegatesByClass.values());
    }

    private class RegReader
    extends RegistryReader {
        RegReader() {
            super(Platform.getExtensionRegistry(), "org.eclipse.papyrusrt.umlrt.common.ui", ToggleDialogDelegateRegistry.EXT_PT);
        }

        protected boolean readElement(IConfigurationElement element, boolean add) {
            boolean result = false;
            if (ToggleDialogDelegateRegistry.DELEGATE_ELEM.equals(element.getName())) {
                result = true;
                String className = element.getAttribute(ToggleDialogDelegateRegistry.CLASS_ATTR);
                if (Strings.isNullOrEmpty((String)className)) {
                    this.logMissingAttribute(element, ToggleDialogDelegateRegistry.CLASS_ATTR);
                } else if (!add) {
                    ToggleDialogDelegateRegistry.this.delegatesByClass.remove(className);
                } else if (ToggleDialogDelegateRegistry.this.delegatesByClass.containsKey(className)) {
                    this.logError(element, "Duplicate registration of toggle-dialog delegate: " + className);
                } else {
                    try {
                        IToggleDialogDelegate delegate = (IToggleDialogDelegate)element.createExecutableExtension(ToggleDialogDelegateRegistry.CLASS_ATTR);
                        ToggleDialogDelegateRegistry.this.delegatesByClass.put(className, delegate);
                    }
                    catch (Exception e) {
                        Activator.log.error("Failed to create toggle-dialog delegate", (Throwable)e);
                    }
                }
            }
            return result;
        }
    }
}

