/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.migration.rsa.extension;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.m2m.qvt.oml.BasicModelExtent;
import org.eclipse.m2m.qvt.oml.ExecutionContext;
import org.eclipse.m2m.qvt.oml.ModelExtent;
import org.eclipse.m2m.qvt.oml.TransformationExecutor;
import org.eclipse.papyrus.interoperability.rsa.concurrent.ExecutorsPool;
import org.eclipse.papyrus.interoperability.rsa.internal.extension.TransformationExtension;
import org.eclipse.papyrus.interoperability.rsa.transformation.ImportTransformation;
import org.eclipse.papyrusrt.umlrt.profile.statemachine.UMLRTStateMachines.UMLRTStateMachinesPackage;
import org.eclipse.papyrusrt.umlrt.tooling.rsa.umlrt.UMLRealTimePackage;
import org.eclipse.uml2.common.util.CacheAdapter;

public class ImportRTTransformationExtension
implements TransformationExtension {
    protected ResourceSet resourceSet;
    protected ExecutorsPool executorsPool;
    protected ImportTransformation importTransformation;

    public void setResourceSet(ResourceSet resourceSet) {
        this.resourceSet = resourceSet;
    }

    public void setTransformation(ImportTransformation importTransformation) {
        this.importTransformation = importTransformation;
    }

    public void setExecutorsPool(ExecutorsPool pool) {
        this.executorsPool = pool;
    }

    public IStatus executeBefore(ExecutionContext context, IProgressMonitor monitor) {
        monitor.subTask("Importing RT Stereotypes...");
        this.importRTProfile(context, monitor);
        monitor.worked(1);
        return Status.OK_STATUS;
    }

    public IStatus executeAfter(ExecutionContext context, IProgressMonitor monitor) {
        monitor.subTask("Import RT Diagrams...");
        this.importRTDiagrams(context, monitor);
        monitor.worked(1);
        return Status.OK_STATUS;
    }

    protected IStatus importRTProfile(ExecutionContext context, IProgressMonitor monitor) {
        monitor.subTask("Importing RT Profile... ");
        URI transformationURI = this.getRTTransformationURI("RSARTToPapyrusRT");
        LinkedList<ModelExtent> extents = new LinkedList<ModelExtent>();
        extents.add(this.importTransformation.getInOutUMLModel());
        extents.add(this.initializeExtent(this.getInRTProfiles()));
        extents.add(this.getInRTProfileDefinitions());
        return this.importTransformation.runTransformation(transformationURI, extents, monitor);
    }

    protected IStatus importRTDiagrams(ExecutionContext context, IProgressMonitor monitor) {
        monitor.subTask("Importing RT Profile... ");
        URI transformationURI = this.getRTTransformationURI("PapyrusRTDiagrams");
        ArrayList<ModelExtent> extents = new ArrayList<ModelExtent>(3);
        extents.add(this.importTransformation.getInOutUMLModel());
        extents.add(this.initializeExtent(this.importTransformation.getInoutNotationModel()));
        return this.importTransformation.runTransformation(transformationURI, extents, monitor);
    }

    protected ModelExtent initializeExtent(ModelExtent extent) {
        extent.getContents().forEach(arg_0 -> ((CacheAdapter)CacheAdapter.getInstance()).adapt(arg_0));
        return extent;
    }

    protected ModelExtent getInRTProfileDefinitions() {
        return new BasicModelExtent(Arrays.asList(org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.UMLRealTimePackage.eINSTANCE, UMLRTStateMachinesPackage.eINSTANCE));
    }

    protected ModelExtent getInRTProfiles() {
        LinkedList allContents = new LinkedList();
        URI umlrtProfileURI = URI.createURI((String)"pathmap://UML_RT_PROFILE/uml-rt.profile.uml");
        Resource umlrtProfile = this.resourceSet.getResource(umlrtProfileURI, true);
        allContents.addAll(umlrtProfile.getContents());
        URI umlrtSMProfileURI = URI.createURI((String)"pathmap://UML_RT_PROFILE/UMLRealTimeSM-addendum.profile.uml");
        Resource umlrtSMProfile = this.resourceSet.getResource(umlrtSMProfileURI, true);
        allContents.addAll(umlrtSMProfile.getContents());
        return new BasicModelExtent(allContents);
    }

    protected TransformationExecutor getTransformation(URI transformationURI, IProgressMonitor monitor) throws DiagnosticException {
        return this.executorsPool.getExecutor(transformationURI);
    }

    protected static IStatus createStatusFromDiagnostic(Diagnostic diagnostic) {
        return new Status(diagnostic.getSeverity(), diagnostic.getSource(), diagnostic.getMessage(), diagnostic.getException());
    }

    protected URI getRTTransformationURI(String name) {
        return URI.createPlatformPluginURI((String)String.format("%s/transform/%s.qvto", "org.eclipse.papyrusrt.umlrt.migration.rsa", name), (boolean)true);
    }

    public int getNumberOfSteps() {
        return 2;
    }

    public Set<EPackage> getAdditionalSourceEPackages() {
        return Collections.singleton(UMLRealTimePackage.eINSTANCE);
    }
}

