/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.rsa.umlrt;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum HistoryKind implements Enumerator
{
    DEEP(0, "Deep", "Deep"),
    SHALLOW(1, "Shallow", "Shallow");

    public static final int DEEP_VALUE = 0;
    public static final int SHALLOW_VALUE = 1;
    private static final HistoryKind[] VALUES_ARRAY;
    public static final List<HistoryKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new HistoryKind[]{DEEP, SHALLOW};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static HistoryKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            HistoryKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static HistoryKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            HistoryKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static HistoryKind get(int value) {
        switch (value) {
            case 0: {
                return DEEP;
            }
            case 1: {
                return SHALLOW;
            }
        }
        return null;
    }

    private HistoryKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

