/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.ui.databinding;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;

public class DataBindingContextTracker {
    private static final ThreadLocal<TrackingContext> trackingContext = new ThreadLocal();

    private DataBindingContextTracker() {
    }

    public static void addingDataBindingContext(DataBindingContext dataBindingContext) {
        TrackingContext ctx = trackingContext.get();
        if (ctx != null) {
            ctx.add(dataBindingContext);
        }
    }

    public static void trackWhile(Runnable action) {
        TrackingContext restore = trackingContext.get();
        try {
            TrackingContext ctx = new TrackingContext();
            trackingContext.set(ctx);
            action.run();
        }
        finally {
            if (restore == null) {
                trackingContext.remove();
            } else {
                trackingContext.set(restore);
            }
        }
    }

    public static IObservableList<DataBindingContext> getDataBindingContexts() {
        TrackingContext ctx = trackingContext.get();
        IObservableList<DataBindingContext> result = ctx == null ? Observables.emptyObservableList(DataBindingContext.class) : ctx.getContexts();
        return result;
    }

    private static class TrackingContext {
        private final IObservableList<DataBindingContext> contexts = WritableList.withElementType(DataBindingContext.class);
        private final IObservableList<DataBindingContext> contextsView = Observables.unmodifiableObservableList(this.contexts);

        TrackingContext() {
        }

        void add(DataBindingContext context) {
            this.contexts.add((Object)context);
        }

        IObservableList<DataBindingContext> getContexts() {
            return this.contextsView;
        }
    }
}

