/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.ui.internal.advice;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.databinding.AggregateValidationStatus;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListChangeEvent;
import org.eclipse.core.databinding.observable.list.ListDiffVisitor;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.papyrus.infra.properties.ui.creation.EditionDialog;
import org.eclipse.papyrus.infra.ui.util.UIUtil;
import org.eclipse.papyrus.infra.widgets.editors.StringEditor;
import org.eclipse.papyrusrt.umlrt.tooling.ui.databinding.DataBindingContextTracker;
import org.eclipse.papyrusrt.umlrt.tooling.ui.databinding.DelegatingValidationStatusProvider;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ConfiguratorDialog
extends EditionDialog {
    public ConfiguratorDialog(Shell parentShell, boolean allowCancel) {
        super(parentShell, allowCancel);
    }

    public int open() {
        int[] result = new int[]{1};
        DataBindingContextTracker.trackWhile(() -> {
            this.hookValidation();
            nArray[0] = super.open();
        });
        return result[0];
    }

    public void create() {
        super.create();
        TreeIterator fields = UIUtil.allChildren((Control)this.getShell(), Text.class);
        while (fields.hasNext()) {
            Text next = (Text)fields.next();
            if (!next.getEditable() || !next.isEnabled()) continue;
            next.forceFocus();
            next.selectAll();
            break;
        }
    }

    protected void hookValidation() {
        WritableList statusProviders = WritableList.withElementType(ValidationStatusProvider.class);
        AggregateValidationStatus validationStatus = new AggregateValidationStatus((IObservableCollection)statusProviders, 2);
        validationStatus.addValueChangeListener((IValueChangeListener)new IValueChangeListener<IStatus>(){

            public void handleValueChange(ValueChangeEvent<? extends IStatus> event) {
                Button okButton = ConfiguratorDialog.this.getOkButton();
                if (okButton != null && !okButton.isDisposed()) {
                    IStatus status = (IStatus)event.getObservableValue().getValue();
                    boolean valid = status == null || status.getSeverity() < 4;
                    okButton.setEnabled(valid);
                }
            }
        });
        DataBindingContextTracker.getDataBindingContexts().addListChangeListener((IListChangeListener)new IListChangeListener<DataBindingContext>((IObservableList)statusProviders){
            private final Map<DataBindingContext, ValidationStatusProvider> dbcStatusProviders = new HashMap<DataBindingContext, ValidationStatusProvider>();
            private final /* synthetic */ IObservableList val$statusProviders;
            {
                this.val$statusProviders = iObservableList;
            }

            public void handleListChange(ListChangeEvent<? extends DataBindingContext> event) {
                ListChangeEvent<? extends DataBindingContext> _event = event;
                _event.diff.accept((ListDiffVisitor)new ListDiffVisitor<DataBindingContext>(){

                    public void handleAdd(int index, DataBindingContext element) {
                        AggregateValidationStatus aggregate = new AggregateValidationStatus(element, 2);
                        DelegatingValidationStatusProvider provider = new DelegatingValidationStatusProvider((IObservableValue<IStatus>)aggregate);
                        dbcStatusProviders.put(element, provider);
                        val$statusProviders.add((Object)provider);
                    }

                    public void handleRemove(int index, DataBindingContext element) {
                        ValidationStatusProvider provider = (ValidationStatusProvider)dbcStatusProviders.remove(element);
                        if (provider != null) {
                            val$statusProviders.remove((Object)provider);
                        }
                    }
                });
            }
        });
    }

    protected void okPressed() {
        Control focus = this.getShell().getDisplay().getFocusControl();
        if (focus instanceof Text && focus.getParent() instanceof StringEditor) {
            ((Text)focus).notifyListeners(16, new Event());
        }
        if (this.getOkButton().isEnabled()) {
            super.okPressed();
        }
    }
}

