/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.ui.menus;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.commands.Command;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.services.IServiceLocator;

public class MultiCommandContribution
extends CompoundContributionItem
implements IWorkbenchContribution,
IExecutableExtension {
    private IServiceLocator services;
    private List<String> commandIDs = Collections.emptyList();

    public MultiCommandContribution() {
    }

    public MultiCommandContribution(String id) {
        super(id);
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        Map params = (Map)data;
        String commandIDs = (String)params.get("commandIDs");
        if (commandIDs != null) {
            String contributor = config.getContributor().getName();
            Function<String, String> qualify = id -> id.indexOf(46) < 0 ? String.valueOf(contributor) + '.' + id : id;
            this.commandIDs = Stream.of(commandIDs.split(",")).map(String::trim).filter(((Predicate<String>)String::isEmpty).negate()).map(qualify).collect(Collectors.toList());
        }
    }

    public void initialize(IServiceLocator serviceLocator) {
        this.services = serviceLocator;
    }

    protected IContributionItem[] getContributionItems() {
        return (IContributionItem[])this.commandIDs.stream().map(this::getCommandAction).filter(Objects::nonNull).toArray(IContributionItem[]::new);
    }

    protected IContributionItem getCommandAction(String commandID) {
        ICommandService commands = (ICommandService)this.services.getService(ICommandService.class);
        if (commands == null) {
            return null;
        }
        return Optional.ofNullable(commands.getCommand(commandID)).filter(Command::isEnabled).map(command -> new CommandContributionItemParameter(this.services, command.getId(), command.getId(), 8)).map(CommandContributionItem::new).orElse(null);
    }
}

