/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.xtumlrt.aexpr.parser;

import java.util.Collections;
import java.util.Iterator;
import org.eclipse.papyrusrt.xtumlrt.aexpr.ast.AExpr;
import org.eclipse.papyrusrt.xtumlrt.aexpr.ast.BinExpr;
import org.eclipse.papyrusrt.xtumlrt.aexpr.ast.Num;
import org.eclipse.papyrusrt.xtumlrt.aexpr.ast.Op;
import org.eclipse.papyrusrt.xtumlrt.aexpr.ast.UnaryExpr;
import org.eclipse.papyrusrt.xtumlrt.aexpr.ast.Var;
import org.eclipse.papyrusrt.xtumlrt.aexpr.lexer.Lexer;
import org.eclipse.papyrusrt.xtumlrt.aexpr.lexer.TokenSequence;
import org.eclipse.papyrusrt.xtumlrt.aexpr.lexer.tokens.Delimiter;
import org.eclipse.papyrusrt.xtumlrt.aexpr.lexer.tokens.Identifier;
import org.eclipse.papyrusrt.xtumlrt.aexpr.lexer.tokens.Number;
import org.eclipse.papyrusrt.xtumlrt.aexpr.lexer.tokens.Operator;
import org.eclipse.papyrusrt.xtumlrt.aexpr.lexer.tokens.QualifiedIdentifier;
import org.eclipse.papyrusrt.xtumlrt.aexpr.lexer.tokens.Token;
import org.eclipse.papyrusrt.xtumlrt.aexpr.names.Name;
import org.eclipse.papyrusrt.xtumlrt.aexpr.names.QualifiedName;
import org.eclipse.papyrusrt.xtumlrt.aexpr.parser.MissingExpectedTokenException;
import org.eclipse.papyrusrt.xtumlrt.aexpr.parser.UnexpectedTokenException;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;

public class AExprParser {
    private final Lexer lexer = new Lexer(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[0])), Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[0])), "::", 4);
    private TokenSequence.TokensIterator iterator;

    public AExpr parse(String text) {
        AExpr _xblockexpression = null;
        TokenSequence _tokenSequenceFor = this.lexer.getTokenSequenceFor(text);
        Iterator<Token> _iterator = _tokenSequenceFor.iterator();
        this.iterator = (TokenSequence.TokensIterator)_iterator;
        AExpr result = this.parseExpr();
        boolean _hasNext = this.iterator.hasNext();
        if (_hasNext) {
            Token token = (Token)this.iterator.next();
            throw new UnexpectedTokenException(token);
        }
        _xblockexpression = result;
        return _xblockexpression;
    }

    private AExpr parseFactor() {
        Num _xblockexpression = null;
        Token token = this.iterator.lookAhead();
        AExpr _switchResult = null;
        boolean _matched = false;
        if (token instanceof Number) {
            _matched = true;
            _switchResult = this.acceptNumber(token);
        }
        if (!_matched && token instanceof Identifier) {
            _matched = true;
            _switchResult = this.acceptVar(token);
        }
        if (!_matched && token instanceof Operator) {
            _matched = true;
            _switchResult = this.parseUnaryExpr();
        }
        if (!_matched && token instanceof Delimiter) {
            boolean _tripleEquals;
            Delimiter.Kind _kind = ((Delimiter)token).getKind();
            boolean bl = _tripleEquals = _kind == Delimiter.Kind.LPAR;
            if (_tripleEquals) {
                _matched = true;
                _switchResult = this.parseSubExpr();
            }
        }
        if (!_matched) {
            throw new UnexpectedTokenException(token);
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }

    private AExpr parseTerm() {
        AExpr factor;
        AExpr _xblockexpression = null;
        AExpr term = factor = this.parseFactor();
        boolean _hasNext = this.iterator.hasNext();
        if (_hasNext) {
            Token token = this.iterator.lookAhead();
            while (this.iterator.hasNext() && this.isMultiplicativeOperator(token)) {
                Token _lookAhead;
                this.iterator.next();
                Op operator = this.operator(token);
                AExpr other = this.parseFactor();
                BinExpr _binExpr = new BinExpr(operator, term, other);
                term = _binExpr;
                token = _lookAhead = this.iterator.lookAhead();
            }
        }
        _xblockexpression = term;
        return _xblockexpression;
    }

    private AExpr parseExpr() {
        AExpr term;
        AExpr _xblockexpression = null;
        AExpr expr = term = this.parseTerm();
        boolean _hasNext = this.iterator.hasNext();
        if (_hasNext) {
            Token token = this.iterator.lookAhead();
            while (this.iterator.hasNext() && this.isAdditiveOperator(token)) {
                Token _lookAhead;
                this.iterator.next();
                Op operator = this.operator(token);
                AExpr other = this.parseTerm();
                BinExpr _binExpr = new BinExpr(operator, expr, other);
                expr = _binExpr;
                token = _lookAhead = this.iterator.lookAhead();
            }
        }
        _xblockexpression = expr;
        return _xblockexpression;
    }

    private UnaryExpr parseUnaryExpr() {
        UnaryExpr _xifexpression = null;
        boolean _hasNext = this.iterator.hasNext();
        if (_hasNext) {
            UnaryExpr _xblockexpression = null;
            Token token = this.iterator.lookAhead();
            UnaryExpr _xifexpression_1 = null;
            boolean _isAdditiveOperator = this.isAdditiveOperator(token);
            if (!_isAdditiveOperator) {
                throw new MissingExpectedTokenException(token, "+ or -");
            }
            UnaryExpr _xblockexpression_1 = null;
            this.iterator.next();
            Op op = this.operator(token);
            AExpr factor = this.parseFactor();
            _xifexpression_1 = _xblockexpression_1 = new UnaryExpr(op, factor);
            _xifexpression = _xblockexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    private AExpr parseSubExpr() {
        AExpr _xblockexpression = null;
        this.iterator.next();
        AExpr subExpr = this.parseExpr();
        this.expectRpar();
        _xblockexpression = subExpr;
        return _xblockexpression;
    }

    private Num acceptNumber(Token token) {
        Num _xblockexpression = null;
        this.iterator.next();
        int _value = ((Number)token).getValue();
        _xblockexpression = new Num(_value);
        return _xblockexpression;
    }

    private Var acceptVar(Token token) {
        Var _xblockexpression = null;
        this.iterator.next();
        Name _xifexpression = null;
        if (token instanceof QualifiedIdentifier) {
            String _text = ((QualifiedIdentifier)token).getText();
            String[] _segments = ((QualifiedIdentifier)token).getSegments();
            _xifexpression = new QualifiedName(_text, _segments);
        } else {
            String _text_1 = token.getText();
            _xifexpression = new Name(_text_1);
        }
        Name name = _xifexpression;
        _xblockexpression = new Var(name);
        return _xblockexpression;
    }

    private Token expectRpar() {
        Token _xblockexpression = null;
        Token token = this.iterator.lookAhead();
        Token _xifexpression = null;
        if (!(token instanceof Delimiter) || ((Delimiter)token).getKind() != Delimiter.Kind.RPAR) {
            throw new MissingExpectedTokenException(token, ")");
        }
        _xifexpression = (Token)this.iterator.next();
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private boolean isMultiplicativeOperator(Token token) {
        boolean _xifexpression = false;
        _xifexpression = token instanceof Operator ? ((Operator)token).getKind() == Operator.Kind.TIMES || ((Operator)token).getKind() == Operator.Kind.DIV || ((Operator)token).getKind() == Operator.Kind.MOD : false;
        return _xifexpression;
    }

    private boolean isAdditiveOperator(Token token) {
        boolean _xifexpression = false;
        _xifexpression = token instanceof Operator ? ((Operator)token).getKind() == Operator.Kind.PLUS || ((Operator)token).getKind() == Operator.Kind.MINUS : false;
        return _xifexpression;
    }

    private Op operator(Token token) {
        Op _xifexpression;
        block7: {
            Op _switchResult;
            block9: {
                block8: {
                    _xifexpression = null;
                    if (!(token instanceof Operator)) break block7;
                    _switchResult = null;
                    Operator.Kind _kind = ((Operator)token).getKind();
                    if (_kind == null) break block8;
                    switch (_kind) {
                        case PLUS: {
                            _switchResult = Op.PLUS;
                            break block9;
                        }
                        case MINUS: {
                            _switchResult = Op.MINUS;
                            break block9;
                        }
                        case TIMES: {
                            _switchResult = Op.TIMES;
                            break block9;
                        }
                        case DIV: {
                            _switchResult = Op.DIV;
                            break block9;
                        }
                        case MOD: {
                            _switchResult = Op.MOD;
                            break block9;
                        }
                        default: {
                            throw new UnexpectedTokenException(token);
                        }
                    }
                }
                throw new UnexpectedTokenException(token);
            }
            _xifexpression = _switchResult;
        }
        return _xifexpression;
    }
}

