/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.cpp;

import com.google.common.base.Objects;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.net.URI;
import org.eclipse.papyrusrt.xtumlrt.external.ExternalPackageManager;
import org.eclipse.papyrusrt.xtumlrt.external.PluginFinder;
import org.eclipse.uml2.uml.util.UMLUtil;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class StandaloneCppProjectGenerator {
    private static final String RTS_PLUGIN_ID = "org.eclipse.papyrusrt.rts";
    private static String UMLRTS_ROOT = "";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean generate(String path, String projectName, boolean regenerate) {
        try {
            File cprojectFile;
            boolean _isEmpty;
            File projectFile;
            File _file = new File(path);
            File project = new File(_file, projectName);
            boolean _exists = project.exists();
            if (_exists) {
                boolean _isDirectory = project.isDirectory();
                if (!_isDirectory) return false;
                boolean bl = false;
                boolean _not = bl;
                if (_not) {
                    return false;
                }
            } else {
                boolean result = project.mkdirs();
                if (!result) {
                    return result;
                }
            }
            if (!(projectFile = new File(project, ".project")).exists() || regenerate) {
                FileWriter _fileWriter = new FileWriter(projectFile);
                BufferedWriter writer = new BufferedWriter(_fileWriter);
                CharSequence _generateProjectMetadata = this.generateProjectMetadata(projectName);
                String _string = _generateProjectMetadata.toString();
                writer.write(_string);
                writer.close();
            }
            if (_isEmpty = UMLUtil.isEmpty((String)UMLRTS_ROOT)) {
                String rtsroot = System.getenv("UMLRTS_ROOT");
                boolean _isEmpty_1 = UMLUtil.isEmpty((String)rtsroot);
                if (_isEmpty_1) {
                    boolean _notEquals;
                    ExternalPackageManager _instance = ExternalPackageManager.getInstance();
                    PluginFinder _pluginFinder = _instance.getPluginFinder();
                    String loc = _pluginFinder.get(RTS_PLUGIN_ID);
                    boolean bl = _notEquals = !Objects.equal((Object)loc, null);
                    if (_notEquals) {
                        String _plus;
                        URI uri = URI.create(loc);
                        String _path = uri.getPath();
                        UMLRTS_ROOT = _plus = String.valueOf(_path) + "/umlrts";
                    }
                } else {
                    UMLRTS_ROOT = "${UMLRTS_ROOT}";
                }
            }
            if ((cprojectFile = new File(project, ".cproject")).exists()) {
                if (!regenerate) return true;
            }
            FileWriter _fileWriter_1 = new FileWriter(cprojectFile);
            BufferedWriter writer_1 = new BufferedWriter(_fileWriter_1);
            String _property = System.getProperty("os.name");
            String _lowerCase = _property.toLowerCase();
            boolean _startsWith = _lowerCase.startsWith("win");
            if (_startsWith) {
                CharSequence _generateCProjectMetadataForCygwin = this.generateCProjectMetadataForCygwin(projectName);
                String _string_1 = _generateCProjectMetadataForCygwin.toString();
                writer_1.write(_string_1);
            } else {
                CharSequence _generateCProjectMetadata = this.generateCProjectMetadata(projectName);
                String _string_2 = _generateCProjectMetadata.toString();
                writer_1.write(_string_2);
            }
            writer_1.close();
            return true;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public boolean generate(String path, String projectName) {
        return this.generate(path, projectName, false);
    }

    public boolean regenerateMetadata(String path, String projectName) {
        return this.generate(path, projectName, true);
    }

    private CharSequence generateProjectMetadata(String projectName) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        _builder.newLine();
        _builder.append("<projectDescription>");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("<name>");
        _builder.append(projectName, "\t");
        _builder.append("</name>");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("<comment></comment>");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("<projects>");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("</projects>");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("<buildSpec>");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("<buildCommand>");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("<name>org.eclipse.papyrusrt.codegen.umlrtgensrcbuilder</name>");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("<arguments>");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("</arguments>");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("</buildCommand>\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("<buildCommand>");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("<name>org.eclipse.cdt.managedbuilder.core.genmakebuilder</name>");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("<triggers>clean,full,incremental,</triggers>");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("<arguments>");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("</arguments>");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("</buildCommand>");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("<buildCommand>");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("<name>org.eclipse.cdt.managedbuilder.core.ScannerConfigBuilder</name>");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("<triggers>full,incremental,</triggers>");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("<arguments>");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("</arguments>");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("</buildCommand>");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("</buildSpec>");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("<natures>");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("<nature>org.eclipse.cdt.core.cnature</nature>");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("<nature>org.eclipse.cdt.core.ccnature</nature>");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("<nature>org.eclipse.cdt.managedbuilder.core.managedBuildNature</nature>");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("<nature>org.eclipse.cdt.managedbuilder.core.ScannerConfigNature</nature>");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("</natures>");
        _builder.newLine();
        _builder.append("</projectDescription>");
        _builder.newLine();
        return _builder;
    }

    private CharSequence generateCProjectMetadata(String projectName) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>");
        _builder.newLine();
        _builder.append("<?fileVersion 4.0.0?><cproject storage_type_id=\"org.eclipse.cdt.core.XmlProjectDescriptionStorage\">");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("<storageModule moduleId=\"org.eclipse.cdt.core.settings\">");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("<cconfiguration id=\"cdt.managedbuild.toolchain.gnu.base.4997491962\">");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("<storageModule moduleId=\"cdtBuildSystem\" version=\"4.0.0\">");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("<configuration artifactName=\"${ProjName}\" buildProperties=\"\" id=\"cdt.managedbuild.toolchain.gnu.base.4997491961\" name=\"Default\" parent=\"org.eclipse.cdt.build.core.emptycfg\">");
        _builder.newLine();
        _builder.append("                    ");
        _builder.append("<folderInfo id=\"cdt.managedbuild.toolchain.gnu.base.8320418219\" name=\"/\" resourcePath=\"\">");
        _builder.newLine();
        _builder.append("                        ");
        _builder.append("<toolChain id=\"cdt.managedbuild.toolchain.gnu.base.9623027664\" name=\"Linux GCC\" superClass=\"cdt.managedbuild.toolchain.gnu.base\">");
        _builder.newLine();
        _builder.append("                            ");
        _builder.append("<targetPlatform archList=\"all\" binaryParser=\"org.eclipse.cdt.core.ELF\" id=\"cdt.managedbuild.target.gnu.platform.base.1127549341\" name=\"Debug Platform\" osList=\"linux,hpux,aix,qnx\" superClass=\"cdt.managedbuild.target.gnu.platform.base\"/>");
        _builder.newLine();
        _builder.append("                            ");
        _builder.append("<builder id=\"cdt.managedbuild.target.gnu.builder.base.6925958497\" managedBuildOn=\"false\" name=\"Gnu Make Builder.Default\" superClass=\"cdt.managedbuild.target.gnu.builder.base\"/>");
        _builder.newLine();
        _builder.append("                            ");
        _builder.append("<tool id=\"cdt.managedbuild.tool.gnu.archiver.base.4527526645\" name=\"GCC Archiver\" superClass=\"cdt.managedbuild.tool.gnu.archiver.base\"/>");
        _builder.newLine();
        _builder.append("                            ");
        _builder.append("<tool id=\"cdt.managedbuild.tool.gnu.cpp.compiler.base.1689764086\" name=\"GCC C++ Compiler\" superClass=\"cdt.managedbuild.tool.gnu.cpp.compiler.base\">");
        _builder.newLine();
        int _length = UMLRTS_ROOT.length();
        boolean bl = _notEquals = _length != 0;
        if (_notEquals) {
            _builder.append("                                ");
            _builder.append("<option id=\"gnu.cpp.compiler.option.include.paths.1773497216\" name=\"Include paths (-I)\" superClass=\"gnu.cpp.compiler.option.include.paths\" valueType=\"includePath\">");
            _builder.newLine();
            _builder.append("                                ");
            _builder.append("    ");
            _builder.append("<listOptionValue builtIn=\"false\" value=\"&quot;");
            _builder.append(UMLRTS_ROOT, "                                    ");
            _builder.append("/include&quot;\"/>");
            _builder.newLineIfNotEmpty();
            _builder.append("                                ");
            _builder.append("</option>");
            _builder.newLine();
        }
        _builder.append("                                ");
        _builder.append("<inputType id=\"cdt.managedbuild.tool.gnu.cpp.compiler.input.1003716063\" superClass=\"cdt.managedbuild.tool.gnu.cpp.compiler.input\"/>");
        _builder.newLine();
        _builder.append("                            ");
        _builder.append("</tool>");
        _builder.newLine();
        _builder.append("                            ");
        _builder.append("<tool id=\"cdt.managedbuild.tool.gnu.c.compiler.base.8030371610\" name=\"GCC C Compiler\" superClass=\"cdt.managedbuild.tool.gnu.c.compiler.base\">");
        _builder.newLine();
        _builder.append("                                ");
        _builder.append("<inputType id=\"cdt.managedbuild.tool.gnu.c.compiler.input.793805426\" superClass=\"cdt.managedbuild.tool.gnu.c.compiler.input\"/>");
        _builder.newLine();
        _builder.append("                            ");
        _builder.append("</tool>");
        _builder.newLine();
        _builder.append("                            ");
        _builder.append("<tool id=\"cdt.managedbuild.tool.gnu.c.linker.base.2851231432\" name=\"GCC C Linker\" superClass=\"cdt.managedbuild.tool.gnu.c.linker.base\"/>");
        _builder.newLine();
        _builder.append("                            ");
        _builder.append("<tool id=\"cdt.managedbuild.tool.gnu.cpp.linker.base.1578285699\" name=\"GCC C++ Linker\" superClass=\"cdt.managedbuild.tool.gnu.cpp.linker.base\">");
        _builder.newLine();
        _builder.append("                                ");
        _builder.append("<inputType id=\"cdt.managedbuild.tool.gnu.cpp.linker.input.540722823\" superClass=\"cdt.managedbuild.tool.gnu.cpp.linker.input\">");
        _builder.newLine();
        _builder.append("                                    ");
        _builder.append("<additionalInput kind=\"additionalinputdependency\" paths=\"$(USER_OBJS)\"/>");
        _builder.newLine();
        _builder.append("                                    ");
        _builder.append("<additionalInput kind=\"additionalinput\" paths=\"$(LIBS)\"/>");
        _builder.newLine();
        _builder.append("                                ");
        _builder.append("</inputType>");
        _builder.newLine();
        _builder.append("                            ");
        _builder.append("</tool>");
        _builder.newLine();
        _builder.append("                            ");
        _builder.append("<tool id=\"cdt.managedbuild.tool.gnu.assembler.base.1716199300\" name=\"GCC Assembler\" superClass=\"cdt.managedbuild.tool.gnu.assembler.base\">");
        _builder.newLine();
        _builder.append("                                ");
        _builder.append("<inputType id=\"cdt.managedbuild.tool.gnu.assembler.input.345505909\" superClass=\"cdt.managedbuild.tool.gnu.assembler.input\"/>");
        _builder.newLine();
        _builder.append("                            ");
        _builder.append("</tool>");
        _builder.newLine();
        _builder.append("                        ");
        _builder.append("</toolChain>");
        _builder.newLine();
        _builder.append("                    ");
        _builder.append("</folderInfo>");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("</configuration>");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("</storageModule>");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("<storageModule buildSystemId=\"org.eclipse.cdt.managedbuilder.core.configurationDataProvider\" id=\"cdt.managedbuild.toolchain.gnu.base.4997491961\" moduleId=\"org.eclipse.cdt.core.settings\" name=\"Default\">");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("<externalSettings/>");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("<extensions>");
        _builder.newLine();
        _builder.append("                    ");
        _builder.append("<extension id=\"org.eclipse.cdt.core.GmakeErrorParser\" point=\"org.eclipse.cdt.core.ErrorParser\"/>");
        _builder.newLine();
        _builder.append("                    ");
        _builder.append("<extension id=\"org.eclipse.cdt.core.CWDLocator\" point=\"org.eclipse.cdt.core.ErrorParser\"/>");
        _builder.newLine();
        _builder.append("                    ");
        _builder.append("<extension id=\"org.eclipse.cdt.core.GCCErrorParser\" point=\"org.eclipse.cdt.core.ErrorParser\"/>");
        _builder.newLine();
        _builder.append("                    ");
        _builder.append("<extension id=\"org.eclipse.cdt.core.GASErrorParser\" point=\"org.eclipse.cdt.core.ErrorParser\"/>");
        _builder.newLine();
        _builder.append("                    ");
        _builder.append("<extension id=\"org.eclipse.cdt.core.GLDErrorParser\" point=\"org.eclipse.cdt.core.ErrorParser\"/>");
        _builder.newLine();
        _builder.append("                    ");
        _builder.append("<extension id=\"org.eclipse.cdt.core.ELF\" point=\"org.eclipse.cdt.core.BinaryParser\"/>");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("</extensions>");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("</storageModule>");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("<storageModule moduleId=\"org.eclipse.cdt.core.externalSettings\"/>");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("</cconfiguration>");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("</storageModule>");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("<storageModule moduleId=\"cdtBuildSystem\" version=\"4.0.0\">");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("<project id=\"");
        _builder.append(projectName, "        ");
        _builder.append(".cdt.1970989858\" name=\"");
        _builder.append(projectName, "        ");
        _builder.append("\"/>");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("</storageModule>");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("<storageModule moduleId=\"scannerConfiguration\">");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("<autodiscovery enabled=\"true\" problemReportingEnabled=\"true\" selectedProfileId=\"\"/>");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("</storageModule>");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("<storageModule moduleId=\"org.eclipse.cdt.core.LanguageSettingsProviders\"/>");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("<storageModule moduleId=\"org.eclipse.cdt.make.core.buildtargets\">");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("<buildTargets>");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("<target name=\"all\" path=\"src\" targetID=\"org.eclipse.cdt.build.MakeTargetBuilder\">");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("<buildCommand>make</buildCommand>");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("<buildArguments/>");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("<buildTarget>all</buildTarget>");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("<stopOnError>true</stopOnError>");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("<useDefaultCommand>true</useDefaultCommand>");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("<runAllBuilders>true</runAllBuilders>");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("</target>");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("<target name=\"clean\" path=\"src\" targetID=\"org.eclipse.cdt.build.MakeTargetBuilder\">");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("<buildCommand>make</buildCommand>");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("<buildArguments/>");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("<buildTarget>clean</buildTarget>");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("<stopOnError>true</stopOnError>");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("<useDefaultCommand>true</useDefaultCommand>");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("<runAllBuilders>true</runAllBuilders>");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("</target>");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("<target name=\"info\" path=\"src\" targetID=\"org.eclipse.cdt.build.MakeTargetBuilder\">");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("<buildCommand>make</buildCommand>");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("<buildArguments/>");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("<buildTarget>info</buildTarget>");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("<stopOnError>true</stopOnError>");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("<useDefaultCommand>true</useDefaultCommand>");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("<runAllBuilders>true</runAllBuilders>");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("</target>            ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("</buildTargets>");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("</storageModule>");
        _builder.newLine();
        _builder.append("</cproject>");
        _builder.newLine();
        return _builder;
    }

    private CharSequence generateCProjectMetadataForCygwin(String projectName) {
        boolean _notEquals_5;
        boolean _notEquals_4;
        boolean _notEquals_3;
        boolean _notEquals_2;
        boolean _notEquals_1;
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>");
        _builder.newLine();
        _builder.append("\t    ");
        _builder.append("<?fileVersion 4.0.0?><cproject storage_type_id=\"org.eclipse.cdt.core.XmlProjectDescriptionStorage\">");
        _builder.newLine();
        _builder.append("\t    \t");
        _builder.append("<storageModule moduleId=\"org.eclipse.cdt.core.settings\">");
        _builder.newLine();
        _builder.append("\t    \t\t");
        _builder.append("<cconfiguration id=\"cdt.managedbuild.config.gnu.cygwin.exe.debug.980520581\">");
        _builder.newLine();
        _builder.append("\t    \t\t\t");
        _builder.append("<storageModule buildSystemId=\"org.eclipse.cdt.managedbuilder.core.configurationDataProvider\" id=\"cdt.managedbuild.config.gnu.cygwin.exe.debug.980520581\" moduleId=\"org.eclipse.cdt.core.settings\" name=\"Debug\">");
        _builder.newLine();
        _builder.append("\t    \t\t\t\t");
        _builder.append("<externalSettings/>");
        _builder.newLine();
        _builder.append("\t    \t\t\t\t");
        _builder.append("<extensions>");
        _builder.newLine();
        _builder.append("\t    \t\t\t\t\t");
        _builder.append("<extension id=\"org.eclipse.cdt.core.Cygwin_PE\" point=\"org.eclipse.cdt.core.BinaryParser\"/>");
        _builder.newLine();
        _builder.append("\t    \t\t\t\t\t");
        _builder.append("<extension id=\"org.eclipse.cdt.core.GASErrorParser\" point=\"org.eclipse.cdt.core.ErrorParser\"/>");
        _builder.newLine();
        _builder.append("\t    \t\t\t\t\t");
        _builder.append("<extension id=\"org.eclipse.cdt.core.GmakeErrorParser\" point=\"org.eclipse.cdt.core.ErrorParser\"/>");
        _builder.newLine();
        _builder.append("\t    \t\t\t\t\t");
        _builder.append("<extension id=\"org.eclipse.cdt.core.GLDErrorParser\" point=\"org.eclipse.cdt.core.ErrorParser\"/>");
        _builder.newLine();
        _builder.append("\t    \t\t\t\t\t");
        _builder.append("<extension id=\"org.eclipse.cdt.core.CWDLocator\" point=\"org.eclipse.cdt.core.ErrorParser\"/>");
        _builder.newLine();
        _builder.append("\t    \t\t\t\t\t");
        _builder.append("<extension id=\"org.eclipse.cdt.core.GCCErrorParser\" point=\"org.eclipse.cdt.core.ErrorParser\"/>");
        _builder.newLine();
        _builder.append("\t    \t\t\t\t");
        _builder.append("</extensions>");
        _builder.newLine();
        _builder.append("\t    \t\t\t");
        _builder.append("</storageModule>");
        _builder.newLine();
        _builder.append("\t    \t\t\t");
        _builder.append("<storageModule moduleId=\"cdtBuildSystem\" version=\"4.0.0\">");
        _builder.newLine();
        _builder.append("\t    \t\t\t\t");
        _builder.append("<configuration artifactName=\"${ProjName}\" buildArtefactType=\"org.eclipse.cdt.build.core.buildArtefactType.exe\" buildProperties=\"org.eclipse.cdt.build.core.buildArtefactType=org.eclipse.cdt.build.core.buildArtefactType.exe,org.eclipse.cdt.build.core.buildType=org.eclipse.cdt.build.core.buildType.debug\" cleanCommand=\"rm -rf\" description=\"\" id=\"cdt.managedbuild.config.gnu.cygwin.exe.debug.980520581\" name=\"Debug\" parent=\"cdt.managedbuild.config.gnu.cygwin.exe.debug\">");
        _builder.newLine();
        _builder.append("\t    \t\t\t\t\t");
        _builder.append("<folderInfo id=\"cdt.managedbuild.config.gnu.cygwin.exe.debug.980520581.\" name=\"/\" resourcePath=\"\">");
        _builder.newLine();
        _builder.append("\t    \t\t\t\t\t\t");
        _builder.append("<toolChain id=\"cdt.managedbuild.toolchain.gnu.cygwin.exe.debug.245506467\" name=\"Cygwin GCC\" superClass=\"cdt.managedbuild.toolchain.gnu.cygwin.exe.debug\">");
        _builder.newLine();
        _builder.append("\t    \t\t\t\t\t\t\t");
        _builder.append("<targetPlatform id=\"cdt.managedbuild.target.gnu.platform.cygwin.exe.debug.680331407\" name=\"Debug Platform\" superClass=\"cdt.managedbuild.target.gnu.platform.cygwin.exe.debug\"/>");
        _builder.newLine();
        _builder.append("\t    \t\t\t\t\t\t\t");
        _builder.append("<builder buildPath=\"${workspace_loc:/c}/Debug\" id=\"cdt.managedbuild.target.gnu.builder.cygwin.exe.debug.1123165732\" keepEnvironmentInBuildfile=\"false\" managedBuildOn=\"true\" name=\"Gnu Make Builder\" superClass=\"cdt.managedbuild.target.gnu.builder.cygwin.exe.debug\"/>");
        _builder.newLine();
        _builder.append("\t    \t\t\t\t\t\t\t");
        _builder.append("<tool id=\"cdt.managedbuild.tool.gnu.assembler.cygwin.exe.debug.355408502\" name=\"GCC Assembler\" superClass=\"cdt.managedbuild.tool.gnu.assembler.cygwin.exe.debug\">");
        _builder.newLine();
        int _length = UMLRTS_ROOT.length();
        boolean bl = _notEquals = _length != 0;
        if (_notEquals) {
            _builder.append("\t\t\t\t\t\t\t\t\t");
            _builder.append("<option id=\"gnu.both.asm.option.include.paths.1307501777\" superClass=\"gnu.both.asm.option.include.paths\" valueType=\"includePath\">");
            _builder.newLine();
            _builder.append("\t\t\t\t\t\t\t\t\t");
            _builder.append("\t");
            _builder.append("<listOptionValue builtIn=\"false\" value=\"&quot;");
            _builder.append(UMLRTS_ROOT, "\t\t\t\t\t\t\t\t\t\t");
            _builder.append("\\include&quot;\"/>");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t\t\t\t\t\t\t\t");
            _builder.append("</option>");
            _builder.newLine();
        }
        _builder.append("\t    \t\t\t\t\t\t\t\t");
        _builder.append("<inputType id=\"cdt.managedbuild.tool.gnu.assembler.input.1899783247\" superClass=\"cdt.managedbuild.tool.gnu.assembler.input\"/>");
        _builder.newLine();
        _builder.append("\t    \t\t\t\t\t\t\t");
        _builder.append("</tool>");
        _builder.newLine();
        _builder.append("\t    \t\t\t\t\t\t\t");
        _builder.append("<tool id=\"cdt.managedbuild.tool.gnu.archiver.cygwin.base.1540805693\" name=\"GCC Archiver\" superClass=\"cdt.managedbuild.tool.gnu.archiver.cygwin.base\"/>");
        _builder.newLine();
        _builder.append("\t    \t\t\t\t\t\t\t");
        _builder.append("<tool id=\"cdt.managedbuild.tool.gnu.cpp.compiler.cygwin.exe.debug.679549339\" name=\"Cygwin C++ Compiler\" superClass=\"cdt.managedbuild.tool.gnu.cpp.compiler.cygwin.exe.debug\">");
        _builder.newLine();
        _builder.append("\t    \t\t\t\t\t\t\t\t");
        _builder.append("<option id=\"gnu.cpp.compiler.cygwin.exe.debug.option.optimization.level.655345258\" name=\"Optimization Level\" superClass=\"gnu.cpp.compiler.cygwin.exe.debug.option.optimization.level\" useByScannerDiscovery=\"false\" value=\"gnu.cpp.compiler.optimization.level.none\" valueType=\"enumerated\"/>");
        _builder.newLine();
        _builder.append("\t    \t\t\t\t\t\t\t\t");
        _builder.append("<option id=\"gnu.cpp.compiler.cygwin.exe.debug.option.debugging.level.1250786344\" name=\"Debug Level\" superClass=\"gnu.cpp.compiler.cygwin.exe.debug.option.debugging.level\" useByScannerDiscovery=\"false\" value=\"gnu.cpp.compiler.debugging.level.max\" valueType=\"enumerated\"/>");
        _builder.newLine();
        int _length_1 = UMLRTS_ROOT.length();
        boolean bl2 = _notEquals_1 = _length_1 != 0;
        if (_notEquals_1) {
            _builder.append("\t\t\t\t\t\t\t\t\t\t");
            _builder.append("<option id=\"gnu.cpp.compiler.option.include.paths.1678157794\" superClass=\"gnu.cpp.compiler.option.include.paths\" valueType=\"includePath\">");
            _builder.newLine();
            _builder.append("\t\t\t\t\t\t\t\t\t\t");
            _builder.append("\t");
            _builder.append("<listOptionValue builtIn=\"false\" value=\"&quot;");
            _builder.append(UMLRTS_ROOT, "\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("\\include&quot;\"/>");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t\t\t\t\t\t\t\t\t");
            _builder.append("</option>");
            _builder.newLine();
        }
        _builder.append("\t    \t\t\t\t\t\t\t\t");
        _builder.append("<inputType id=\"cdt.managedbuild.tool.gnu.cpp.compiler.input.cygwin.112150320\" superClass=\"cdt.managedbuild.tool.gnu.cpp.compiler.input.cygwin\"/>");
        _builder.newLine();
        _builder.append("\t    \t\t\t\t\t\t\t");
        _builder.append("</tool>");
        _builder.newLine();
        _builder.append("\t    \t\t\t\t\t\t\t");
        _builder.append("<tool id=\"cdt.managedbuild.tool.gnu.c.compiler.cygwin.exe.debug.1425344114\" name=\"Cygwin C Compiler\" superClass=\"cdt.managedbuild.tool.gnu.c.compiler.cygwin.exe.debug\">");
        _builder.newLine();
        _builder.append("\t    \t\t\t\t\t\t\t\t");
        _builder.append("<option defaultValue=\"gnu.c.optimization.level.none\" id=\"gnu.c.compiler.cygwin.exe.debug.option.optimization.level.1196154684\" name=\"Optimization Level\" superClass=\"gnu.c.compiler.cygwin.exe.debug.option.optimization.level\" useByScannerDiscovery=\"false\" valueType=\"enumerated\"/>");
        _builder.newLine();
        _builder.append("\t    \t\t\t\t\t\t\t\t");
        _builder.append("<option id=\"gnu.c.compiler.cygwin.exe.debug.option.debugging.level.731657235\" name=\"Debug Level\" superClass=\"gnu.c.compiler.cygwin.exe.debug.option.debugging.level\" useByScannerDiscovery=\"false\" value=\"gnu.c.debugging.level.max\" valueType=\"enumerated\"/>");
        _builder.newLine();
        int _length_2 = UMLRTS_ROOT.length();
        boolean bl3 = _notEquals_2 = _length_2 != 0;
        if (_notEquals_2) {
            _builder.append("\t\t\t\t\t\t\t\t\t\t");
            _builder.append("<option id=\"gnu.c.compiler.option.include.paths.1712091319\" superClass=\"gnu.c.compiler.option.include.paths\" valueType=\"includePath\">");
            _builder.newLine();
            _builder.append("\t\t\t\t\t\t\t\t\t\t");
            _builder.append("\t");
            _builder.append("<listOptionValue builtIn=\"false\" value=\"&quot;");
            _builder.append(UMLRTS_ROOT, "\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("\\include&quot;\"/>");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t\t\t\t\t\t\t\t\t");
            _builder.append("</option>");
            _builder.newLine();
        }
        _builder.append("\t    \t\t\t\t\t\t\t\t");
        _builder.append("<inputType id=\"cdt.managedbuild.tool.gnu.c.compiler.input.cygwin.203106561\" superClass=\"cdt.managedbuild.tool.gnu.c.compiler.input.cygwin\"/>");
        _builder.newLine();
        _builder.append("\t    \t\t\t\t\t\t\t");
        _builder.append("</tool>");
        _builder.newLine();
        _builder.append("\t    \t\t\t\t\t\t\t");
        _builder.append("<tool id=\"cdt.managedbuild.tool.gnu.c.linker.cygwin.exe.debug.1613601859\" name=\"Cygwin C Linker\" superClass=\"cdt.managedbuild.tool.gnu.c.linker.cygwin.exe.debug\"/>");
        _builder.newLine();
        _builder.append("\t    \t\t\t\t\t\t\t");
        _builder.append("<tool id=\"cdt.managedbuild.tool.gnu.cpp.linker.cygwin.exe.debug.150791258\" name=\"Cygwin C++ Linker\" superClass=\"cdt.managedbuild.tool.gnu.cpp.linker.cygwin.exe.debug\">");
        _builder.newLine();
        _builder.append("\t    \t\t\t\t\t\t\t\t");
        _builder.append("<inputType id=\"cdt.managedbuild.tool.gnu.cpp.linker.input.2053989711\" superClass=\"cdt.managedbuild.tool.gnu.cpp.linker.input\">");
        _builder.newLine();
        _builder.append("\t    \t\t\t\t\t\t\t\t\t");
        _builder.append("<additionalInput kind=\"additionalinputdependency\" paths=\"$(USER_OBJS)\"/>");
        _builder.newLine();
        _builder.append("\t    \t\t\t\t\t\t\t\t\t");
        _builder.append("<additionalInput kind=\"additionalinput\" paths=\"$(LIBS)\"/>");
        _builder.newLine();
        _builder.append("\t    \t\t\t\t\t\t\t\t");
        _builder.append("</inputType>");
        _builder.newLine();
        _builder.append("\t    \t\t\t\t\t\t\t");
        _builder.append("</tool>");
        _builder.newLine();
        _builder.append("\t    \t\t\t\t\t\t");
        _builder.append("</toolChain>");
        _builder.newLine();
        _builder.append("\t    \t\t\t\t\t");
        _builder.append("</folderInfo>");
        _builder.newLine();
        _builder.append("\t    \t\t\t\t");
        _builder.append("</configuration>");
        _builder.newLine();
        _builder.append("\t    \t\t\t");
        _builder.append("</storageModule>");
        _builder.newLine();
        _builder.append("\t    \t\t\t");
        _builder.append("<storageModule moduleId=\"org.eclipse.cdt.core.externalSettings\"/>");
        _builder.newLine();
        _builder.append("\t    \t\t");
        _builder.append("</cconfiguration>");
        _builder.newLine();
        _builder.append("\t    \t\t");
        _builder.append("<cconfiguration id=\"cdt.managedbuild.config.gnu.cygwin.exe.release.830625860\">");
        _builder.newLine();
        _builder.append("\t    \t\t\t");
        _builder.append("<storageModule buildSystemId=\"org.eclipse.cdt.managedbuilder.core.configurationDataProvider\" id=\"cdt.managedbuild.config.gnu.cygwin.exe.release.830625860\" moduleId=\"org.eclipse.cdt.core.settings\" name=\"Release\">");
        _builder.newLine();
        _builder.append("\t    \t\t\t\t");
        _builder.append("<externalSettings/>");
        _builder.newLine();
        _builder.append("\t    \t\t\t\t");
        _builder.append("<extensions>");
        _builder.newLine();
        _builder.append("\t    \t\t\t\t\t");
        _builder.append("<extension id=\"org.eclipse.cdt.core.Cygwin_PE\" point=\"org.eclipse.cdt.core.BinaryParser\"/>");
        _builder.newLine();
        _builder.append("\t    \t\t\t\t\t");
        _builder.append("<extension id=\"org.eclipse.cdt.core.GASErrorParser\" point=\"org.eclipse.cdt.core.ErrorParser\"/>");
        _builder.newLine();
        _builder.append("\t    \t\t\t\t\t");
        _builder.append("<extension id=\"org.eclipse.cdt.core.GmakeErrorParser\" point=\"org.eclipse.cdt.core.ErrorParser\"/>");
        _builder.newLine();
        _builder.append("\t    \t\t\t\t\t");
        _builder.append("<extension id=\"org.eclipse.cdt.core.GLDErrorParser\" point=\"org.eclipse.cdt.core.ErrorParser\"/>");
        _builder.newLine();
        _builder.append("\t    \t\t\t\t\t");
        _builder.append("<extension id=\"org.eclipse.cdt.core.CWDLocator\" point=\"org.eclipse.cdt.core.ErrorParser\"/>");
        _builder.newLine();
        _builder.append("\t    \t\t\t\t\t");
        _builder.append("<extension id=\"org.eclipse.cdt.core.GCCErrorParser\" point=\"org.eclipse.cdt.core.ErrorParser\"/>");
        _builder.newLine();
        _builder.append("\t    \t\t\t\t");
        _builder.append("</extensions>");
        _builder.newLine();
        _builder.append("\t    \t\t\t");
        _builder.append("</storageModule>");
        _builder.newLine();
        _builder.append("\t    \t\t\t");
        _builder.append("<storageModule moduleId=\"cdtBuildSystem\" version=\"4.0.0\">");
        _builder.newLine();
        _builder.append("\t    \t\t\t\t");
        _builder.append("<configuration artifactName=\"${ProjName}\" buildArtefactType=\"org.eclipse.cdt.build.core.buildArtefactType.exe\" buildProperties=\"org.eclipse.cdt.build.core.buildArtefactType=org.eclipse.cdt.build.core.buildArtefactType.exe,org.eclipse.cdt.build.core.buildType=org.eclipse.cdt.build.core.buildType.release\" cleanCommand=\"rm -rf\" description=\"\" id=\"cdt.managedbuild.config.gnu.cygwin.exe.release.830625860\" name=\"Release\" parent=\"cdt.managedbuild.config.gnu.cygwin.exe.release\">");
        _builder.newLine();
        _builder.append("\t    \t\t\t\t\t");
        _builder.append("<folderInfo id=\"cdt.managedbuild.config.gnu.cygwin.exe.release.830625860.\" name=\"/\" resourcePath=\"\">");
        _builder.newLine();
        _builder.append("\t    \t\t\t\t\t\t");
        _builder.append("<toolChain id=\"cdt.managedbuild.toolchain.gnu.cygwin.exe.release.587807483\" name=\"Cygwin GCC\" superClass=\"cdt.managedbuild.toolchain.gnu.cygwin.exe.release\">");
        _builder.newLine();
        _builder.append("\t    \t\t\t\t\t\t\t");
        _builder.append("<targetPlatform id=\"cdt.managedbuild.target.gnu.platform.cygwin.exe.release.386480403\" name=\"Debug Platform\" superClass=\"cdt.managedbuild.target.gnu.platform.cygwin.exe.release\"/>");
        _builder.newLine();
        _builder.append("\t    \t\t\t\t\t\t\t");
        _builder.append("<builder buildPath=\"${workspace_loc:/c}/Release\" id=\"cdt.managedbuild.target.gnu.builder.cygwin.exe.release.1650634844\" keepEnvironmentInBuildfile=\"false\" managedBuildOn=\"true\" name=\"Gnu Make Builder\" superClass=\"cdt.managedbuild.target.gnu.builder.cygwin.exe.release\"/>");
        _builder.newLine();
        _builder.append("\t    \t\t\t\t\t\t\t");
        _builder.append("<tool id=\"cdt.managedbuild.tool.gnu.assembler.cygwin.exe.release.733379197\" name=\"GCC Assembler\" superClass=\"cdt.managedbuild.tool.gnu.assembler.cygwin.exe.release\">");
        _builder.newLine();
        int _length_3 = UMLRTS_ROOT.length();
        boolean bl4 = _notEquals_3 = _length_3 != 0;
        if (_notEquals_3) {
            _builder.append("\t\t\t\t\t\t\t\t\t\t");
            _builder.append("<option id=\"gnu.both.asm.option.include.paths.1632898777\" superClass=\"gnu.both.asm.option.include.paths\" valueType=\"includePath\">");
            _builder.newLine();
            _builder.append("\t\t\t\t\t\t\t\t\t\t");
            _builder.append("\t");
            _builder.append("<listOptionValue builtIn=\"false\" value=\"&quot;");
            _builder.append(UMLRTS_ROOT, "\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("\\include&quot;\"/>");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t\t\t\t\t\t\t\t\t");
            _builder.append("</option>");
            _builder.newLine();
        }
        _builder.append("\t    \t\t\t\t\t\t\t\t");
        _builder.append("<inputType id=\"cdt.managedbuild.tool.gnu.assembler.input.129880286\" superClass=\"cdt.managedbuild.tool.gnu.assembler.input\"/>");
        _builder.newLine();
        _builder.append("\t    \t\t\t\t\t\t\t");
        _builder.append("</tool>");
        _builder.newLine();
        _builder.append("\t    \t\t\t\t\t\t\t");
        _builder.append("<tool id=\"cdt.managedbuild.tool.gnu.archiver.cygwin.base.1151813552\" name=\"GCC Archiver\" superClass=\"cdt.managedbuild.tool.gnu.archiver.cygwin.base\"/>");
        _builder.newLine();
        _builder.append("\t    \t\t\t\t\t\t\t");
        _builder.append("<tool id=\"cdt.managedbuild.tool.gnu.cpp.compiler.cygwin.exe.release.728311195\" name=\"Cygwin C++ Compiler\" superClass=\"cdt.managedbuild.tool.gnu.cpp.compiler.cygwin.exe.release\">");
        _builder.newLine();
        _builder.append("\t    \t\t\t\t\t\t\t\t");
        _builder.append("<option id=\"gnu.cpp.compiler.cygwin.exe.release.option.optimization.level.883110365\" name=\"Optimization Level\" superClass=\"gnu.cpp.compiler.cygwin.exe.release.option.optimization.level\" useByScannerDiscovery=\"false\" value=\"gnu.cpp.compiler.optimization.level.most\" valueType=\"enumerated\"/>");
        _builder.newLine();
        _builder.append("\t    \t\t\t\t\t\t\t\t");
        _builder.append("<option id=\"gnu.cpp.compiler.cygwin.exe.release.option.debugging.level.964253167\" name=\"Debug Level\" superClass=\"gnu.cpp.compiler.cygwin.exe.release.option.debugging.level\" useByScannerDiscovery=\"false\" value=\"gnu.cpp.compiler.debugging.level.none\" valueType=\"enumerated\"/>");
        _builder.newLine();
        int _length_4 = UMLRTS_ROOT.length();
        boolean bl5 = _notEquals_4 = _length_4 != 0;
        if (_notEquals_4) {
            _builder.append("\t\t\t\t\t\t\t\t\t\t");
            _builder.append("<option id=\"gnu.cpp.compiler.option.include.paths.983362243\" superClass=\"gnu.cpp.compiler.option.include.paths\" valueType=\"includePath\">");
            _builder.newLine();
            _builder.append("\t\t\t\t\t\t\t\t\t\t");
            _builder.append("\t");
            _builder.append("<listOptionValue builtIn=\"false\" value=\"&quot;");
            _builder.append(UMLRTS_ROOT, "\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("\\include&quot;\"/>");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t\t\t\t\t\t\t\t\t");
            _builder.append("</option>");
            _builder.newLine();
        }
        _builder.append("\t    \t\t\t\t\t\t\t\t");
        _builder.append("<inputType id=\"cdt.managedbuild.tool.gnu.cpp.compiler.input.cygwin.330030312\" superClass=\"cdt.managedbuild.tool.gnu.cpp.compiler.input.cygwin\"/>");
        _builder.newLine();
        _builder.append("\t    \t\t\t\t\t\t\t");
        _builder.append("</tool>");
        _builder.newLine();
        _builder.append("\t    \t\t\t\t\t\t\t");
        _builder.append("<tool id=\"cdt.managedbuild.tool.gnu.c.compiler.cygwin.exe.release.1838180696\" name=\"Cygwin C Compiler\" superClass=\"cdt.managedbuild.tool.gnu.c.compiler.cygwin.exe.release\">");
        _builder.newLine();
        _builder.append("\t    \t\t\t\t\t\t\t\t");
        _builder.append("<option defaultValue=\"gnu.c.optimization.level.most\" id=\"gnu.c.compiler.cygwin.exe.release.option.optimization.level.1171465442\" name=\"Optimization Level\" superClass=\"gnu.c.compiler.cygwin.exe.release.option.optimization.level\" useByScannerDiscovery=\"false\" valueType=\"enumerated\"/>");
        _builder.newLine();
        _builder.append("\t    \t\t\t\t\t\t\t\t");
        _builder.append("<option id=\"gnu.c.compiler.cygwin.exe.release.option.debugging.level.1099610109\" name=\"Debug Level\" superClass=\"gnu.c.compiler.cygwin.exe.release.option.debugging.level\" useByScannerDiscovery=\"false\" value=\"gnu.c.debugging.level.none\" valueType=\"enumerated\"/>");
        _builder.newLine();
        int _length_5 = UMLRTS_ROOT.length();
        boolean bl6 = _notEquals_5 = _length_5 != 0;
        if (_notEquals_5) {
            _builder.append("\t    \t\t\t\t\t\t\t\t");
            _builder.append("<option id=\"gnu.c.compiler.option.include.paths.1234491149\" superClass=\"gnu.c.compiler.option.include.paths\" valueType=\"includePath\">");
            _builder.newLine();
            _builder.append("\t    \t\t\t\t\t\t\t\t");
            _builder.append("\t");
            _builder.append("<listOptionValue builtIn=\"false\" value=\"&quot;");
            _builder.append(UMLRTS_ROOT, "\t    \t\t\t\t\t\t\t\t\t");
            _builder.append("\\include&quot;\"/>");
            _builder.newLineIfNotEmpty();
            _builder.append("\t    \t\t\t\t\t\t\t\t");
            _builder.append("</option>");
            _builder.newLine();
        }
        _builder.append("\t    \t\t\t\t\t\t\t\t");
        _builder.append("<inputType id=\"cdt.managedbuild.tool.gnu.c.compiler.input.cygwin.492790812\" superClass=\"cdt.managedbuild.tool.gnu.c.compiler.input.cygwin\"/>");
        _builder.newLine();
        _builder.append("\t    \t\t\t\t\t\t\t");
        _builder.append("</tool>");
        _builder.newLine();
        _builder.append("\t    \t\t\t\t\t\t\t");
        _builder.append("<tool id=\"cdt.managedbuild.tool.gnu.c.linker.cygwin.exe.release.639933432\" name=\"Cygwin C Linker\" superClass=\"cdt.managedbuild.tool.gnu.c.linker.cygwin.exe.release\"/>");
        _builder.newLine();
        _builder.append("\t    \t\t\t\t\t\t\t");
        _builder.append("<tool id=\"cdt.managedbuild.tool.gnu.cpp.linker.cygwin.exe.release.943105356\" name=\"Cygwin C++ Linker\" superClass=\"cdt.managedbuild.tool.gnu.cpp.linker.cygwin.exe.release\">");
        _builder.newLine();
        _builder.append("\t    \t\t\t\t\t\t\t\t");
        _builder.append("<inputType id=\"cdt.managedbuild.tool.gnu.cpp.linker.input.1337288436\" superClass=\"cdt.managedbuild.tool.gnu.cpp.linker.input\">");
        _builder.newLine();
        _builder.append("\t    \t\t\t\t\t\t\t\t\t");
        _builder.append("<additionalInput kind=\"additionalinputdependency\" paths=\"$(USER_OBJS)\"/>");
        _builder.newLine();
        _builder.append("\t    \t\t\t\t\t\t\t\t\t");
        _builder.append("<additionalInput kind=\"additionalinput\" paths=\"$(LIBS)\"/>");
        _builder.newLine();
        _builder.append("\t    \t\t\t\t\t\t\t\t");
        _builder.append("</inputType>");
        _builder.newLine();
        _builder.append("\t    \t\t\t\t\t\t\t");
        _builder.append("</tool>");
        _builder.newLine();
        _builder.append("\t    \t\t\t\t\t\t");
        _builder.append("</toolChain>");
        _builder.newLine();
        _builder.append("\t    \t\t\t\t\t");
        _builder.append("</folderInfo>");
        _builder.newLine();
        _builder.append("\t    \t\t\t\t");
        _builder.append("</configuration>");
        _builder.newLine();
        _builder.append("\t    \t\t\t");
        _builder.append("</storageModule>");
        _builder.newLine();
        _builder.append("\t    \t\t\t");
        _builder.append("<storageModule moduleId=\"org.eclipse.cdt.core.externalSettings\"/>");
        _builder.newLine();
        _builder.append("\t    \t\t");
        _builder.append("</cconfiguration>");
        _builder.newLine();
        _builder.append("\t    \t");
        _builder.append("</storageModule>");
        _builder.newLine();
        _builder.append("\t    \t");
        _builder.append("<storageModule moduleId=\"cdtBuildSystem\" version=\"4.0.0\">");
        _builder.newLine();
        _builder.append("\t    \t\t");
        _builder.append("<project id=\"");
        _builder.append(projectName, "\t    \t\t");
        _builder.append(".cdt.managedbuild.target.gnu.cygwin.exe.1255429509\" name=\"Executable\" projectType=\"cdt.managedbuild.target.gnu.cygwin.exe\"/>");
        _builder.newLineIfNotEmpty();
        _builder.append("\t    \t");
        _builder.append("</storageModule>");
        _builder.newLine();
        _builder.append("\t    \t");
        _builder.append("<storageModule moduleId=\"scannerConfiguration\">");
        _builder.newLine();
        _builder.append("\t    \t\t");
        _builder.append("<autodiscovery enabled=\"true\" problemReportingEnabled=\"true\" selectedProfileId=\"\"/>");
        _builder.newLine();
        _builder.append("\t    \t\t");
        _builder.append("<scannerConfigBuildInfo instanceId=\"cdt.managedbuild.config.gnu.cygwin.exe.debug.980520581;cdt.managedbuild.config.gnu.cygwin.exe.debug.980520581.;cdt.managedbuild.tool.gnu.cpp.compiler.cygwin.exe.debug.679549339;cdt.managedbuild.tool.gnu.cpp.compiler.input.cygwin.112150320\">");
        _builder.newLine();
        _builder.append("\t    \t\t\t");
        _builder.append("<autodiscovery enabled=\"true\" problemReportingEnabled=\"true\" selectedProfileId=\"\"/>");
        _builder.newLine();
        _builder.append("\t    \t\t");
        _builder.append("</scannerConfigBuildInfo>");
        _builder.newLine();
        _builder.append("\t    \t\t");
        _builder.append("<scannerConfigBuildInfo instanceId=\"cdt.managedbuild.config.gnu.cygwin.exe.debug.980520581;cdt.managedbuild.config.gnu.cygwin.exe.debug.980520581.;cdt.managedbuild.tool.gnu.c.compiler.cygwin.exe.debug.1425344114;cdt.managedbuild.tool.gnu.c.compiler.input.cygwin.203106561\">");
        _builder.newLine();
        _builder.append("\t    \t\t\t");
        _builder.append("<autodiscovery enabled=\"true\" problemReportingEnabled=\"true\" selectedProfileId=\"\"/>");
        _builder.newLine();
        _builder.append("\t    \t\t");
        _builder.append("</scannerConfigBuildInfo>");
        _builder.newLine();
        _builder.append("\t    \t\t");
        _builder.append("<scannerConfigBuildInfo instanceId=\"cdt.managedbuild.config.gnu.cygwin.exe.release.830625860;cdt.managedbuild.config.gnu.cygwin.exe.release.830625860.;cdt.managedbuild.tool.gnu.c.compiler.cygwin.exe.release.1838180696;cdt.managedbuild.tool.gnu.c.compiler.input.cygwin.492790812\">");
        _builder.newLine();
        _builder.append("\t    \t\t\t");
        _builder.append("<autodiscovery enabled=\"true\" problemReportingEnabled=\"true\" selectedProfileId=\"\"/>");
        _builder.newLine();
        _builder.append("\t    \t\t");
        _builder.append("</scannerConfigBuildInfo>");
        _builder.newLine();
        _builder.append("\t    \t\t");
        _builder.append("<scannerConfigBuildInfo instanceId=\"cdt.managedbuild.config.gnu.cygwin.exe.release.830625860;cdt.managedbuild.config.gnu.cygwin.exe.release.830625860.;cdt.managedbuild.tool.gnu.cpp.compiler.cygwin.exe.release.728311195;cdt.managedbuild.tool.gnu.cpp.compiler.input.cygwin.330030312\">");
        _builder.newLine();
        _builder.append("\t    \t\t\t");
        _builder.append("<autodiscovery enabled=\"true\" problemReportingEnabled=\"true\" selectedProfileId=\"\"/>");
        _builder.newLine();
        _builder.append("\t    \t\t");
        _builder.append("</scannerConfigBuildInfo>");
        _builder.newLine();
        _builder.append("\t    \t");
        _builder.append("</storageModule>");
        _builder.newLine();
        _builder.append("\t    \t");
        _builder.append("<storageModule moduleId=\"org.eclipse.cdt.core.LanguageSettingsProviders\"/>");
        _builder.newLine();
        _builder.append("\t    ");
        _builder.append("</cproject>");
        _builder.newLine();
        return _builder;
    }
}

