/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.cpp.validation;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrusrt.codegen.cpp.UMLPrettyPrinter;
import org.eclipse.papyrusrt.codegen.cpp.validation.StatusFactory;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTGuard;
import org.eclipse.papyrusrt.xtumlrt.external.predefined.UMLRTProfileUtil;
import org.eclipse.papyrusrt.xtumlrt.external.predefined.UMLRTStateMachProfileUtil;
import org.eclipse.papyrusrt.xtumlrt.trans.TransformValidator;
import org.eclipse.papyrusrt.xtumlrt.util.ContainmentUtils;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Event;
import org.eclipse.uml2.uml.LiteralUnlimitedNatural;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Pseudostate;
import org.eclipse.uml2.uml.PseudostateKind;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Trigger;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.Vertex;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class PreUML2xtumlrtValidator
implements TransformValidator<List<EObject>> {
    @Extension
    private UMLPrettyPrinter prettyPrinter = new UMLPrettyPrinter();
    private static final int UNLIMITED_NATURAL = -1;

    public MultiStatus validate(List<EObject> context) {
        MultiStatus _xblockexpression = null;
        final MultiStatus status = new MultiStatus("org.eclipse.papyrusrt.codegen", 1, "UML-RT Code Generator - pre-generation validation", null);
        for (EObject e : context) {
            TreeIterator _eAllContents = e.eAllContents();
            Procedures.Procedure1<EObject> _function = new Procedures.Procedure1<EObject>(){

                public void apply(EObject it) {
                    PreUML2xtumlrtValidator.this.validateElement(it, status);
                    PreUML2xtumlrtValidator.this.validateDuplicateElement(it, status);
                }
            };
            IteratorExtensions.forEach((Iterator)_eAllContents, (Procedures.Procedure1)_function);
        }
        _xblockexpression = status;
        return _xblockexpression;
    }

    protected void _validateElement(EObject e, MultiStatus result) {
    }

    protected void _validateElement(Constraint element, MultiStatus result) {
        UMLRTGuard guard = UMLRTGuard.getInstance((Constraint)element);
        if (guard != null && !guard.getBodies().containsKey("C++")) {
            StatusFactory.addErrorStatus((EObject)element, "Guard must have a C++ body specification", "No C++ body was found.", result);
        }
    }

    protected void _validateElement(MultiplicityElement element, MultiStatus result) {
        ValueSpecification upper;
        ValueSpecification lower = element.getLowerValue();
        if (lower != null) {
            this.validateElement((EObject)lower, result);
        }
        if ((upper = element.getUpperValue()) != null) {
            this.validateElement((EObject)upper, result);
        }
    }

    protected void _validateElement(Property property, MultiStatus result) {
        boolean _isCapsulePart = UMLRTProfileUtil.isCapsulePart((Element)property);
        if (_isCapsulePart) {
            boolean _not_1;
            boolean _tripleEquals;
            Type _type = property.getType();
            boolean bl = _tripleEquals = _type == null;
            if (_tripleEquals) {
                StatusFactory.addErrorStatus((EObject)property, "The part's type is unset.", "All parts must have their type set to be a Capsule.", result);
            } else {
                boolean _not;
                Type _type_1 = property.getType();
                boolean _isCapsule = UMLRTProfileUtil.isCapsule((Element)_type_1);
                boolean bl2 = _not = !_isCapsule;
                if (_not) {
                    StatusFactory.addErrorStatus((EObject)property, "The part's type is not a Capsule.", "All parts must have their type set to be a Capsule.", result);
                }
            }
            boolean _isReplicationSet = this.isReplicationSet((MultiplicityElement)property);
            boolean bl3 = _not_1 = !_isReplicationSet;
            if (_not_1) {
                StatusFactory.addWarningStatus((EObject)property, "The part has no replication set. Assuming 1.", "The replication of a part is its multiplicity. The multiplicity's lower and upper values are derived from the replication. If no replication is given the default (1) is assumed. A part must not have replication set to '0..*'.", result);
            } else {
                Optional<ValueSpecification> _replication = this.getReplication((MultiplicityElement)property);
                ValueSpecification _get = _replication.get();
                boolean _isUnlimited = this.isUnlimited(_get);
                if (_isUnlimited) {
                    StatusFactory.addErrorStatus((EObject)property, "The part has replication set to 0..*. This is not allowed.", "The part's replication must be set to a positive integer or an arithmetic expression with constants and variables defined in the namespace.", result);
                }
            }
        }
    }

    protected void _validateElement(Port port, MultiStatus result) {
        boolean _not_2;
        Type _type;
        boolean _tripleEquals;
        boolean _not;
        boolean _isRTPort = UMLRTProfileUtil.isRTPort((Element)port);
        boolean bl = _not = !_isRTPort;
        if (_not) {
            StatusFactory.addWarningStatus((EObject)port, "This port doesn't have the RTPort stereotype.", result);
        }
        boolean bl2 = _tripleEquals = (_type = port.getType()) == null;
        if (_tripleEquals) {
            StatusFactory.addErrorStatus((EObject)port, "The port's type is unset.", "All ports must have their type set to be a Protocol.", result);
        } else {
            boolean _not_1;
            Type _type_1 = port.getType();
            boolean _isProtocol = UMLRTProfileUtil.isProtocol((Element)_type_1);
            boolean bl3 = _not_1 = !_isProtocol;
            if (_not_1) {
                StatusFactory.addErrorStatus((EObject)port, "The port's type is not a protocol.", "All ports must have their type set to be a Protocol.", result);
            }
        }
        boolean _isReplicationSet = this.isReplicationSet((MultiplicityElement)port);
        boolean bl4 = _not_2 = !_isReplicationSet;
        if (_not_2) {
            StatusFactory.addWarningStatus((EObject)port, "The port has no replication set. Assuming 1.", "The replication of a port is its multiplicity. The multiplicity's lower and upper values are derived from the replication. If no replication is given the default (1) is assumed. A port must not have replication set to '0..*'.", result);
        } else {
            Optional<ValueSpecification> _replication = this.getReplication((MultiplicityElement)port);
            ValueSpecification _get = _replication.get();
            boolean _isUnlimited = this.isUnlimited(_get);
            if (_isUnlimited) {
                StatusFactory.addErrorStatus((EObject)port, "The port has replication set to 0..*. This is not allowed.", "The port's replication must be set to a positive integer or an arithmetic expression with constants and variables defined in the namespace.", result);
            }
        }
    }

    private boolean isReplicationSet(MultiplicityElement element) {
        boolean upperValueIsSet;
        boolean lowerValueIsSet = element.eIsSet((EStructuralFeature)UMLPackage.Literals.MULTIPLICITY_ELEMENT__LOWER_VALUE) || element.getLowerValue() != null;
        boolean bl = upperValueIsSet = element.eIsSet((EStructuralFeature)UMLPackage.Literals.MULTIPLICITY_ELEMENT__UPPER_VALUE) || element.getUpperValue() != null;
        return lowerValueIsSet || upperValueIsSet;
    }

    private Optional<ValueSpecification> getReplication(MultiplicityElement element) {
        Optional<ValueSpecification> _xblockexpression = null;
        ValueSpecification lowerValue = element.getLowerValue();
        ValueSpecification upperValue = element.getUpperValue();
        boolean lowerValueIsSet = element.eIsSet((EStructuralFeature)UMLPackage.Literals.MULTIPLICITY_ELEMENT__LOWER_VALUE) || lowerValue != null;
        boolean upperValueIsSet = element.eIsSet((EStructuralFeature)UMLPackage.Literals.MULTIPLICITY_ELEMENT__UPPER_VALUE) || upperValue != null;
        Optional<Object> _xifexpression = null;
        if (upperValueIsSet) {
            _xifexpression = Optional.of(upperValue);
        } else {
            Optional<Object> _xifexpression_1 = null;
            _xifexpression_1 = lowerValueIsSet ? Optional.of(lowerValue) : Optional.empty();
            _xifexpression = _xifexpression_1;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private boolean _isUnlimited(ValueSpecification spec) {
        return false;
    }

    private boolean _isUnlimited(LiteralUnlimitedNatural spec) {
        int _value = spec.getValue();
        return _value == -1;
    }

    protected void _validateElement(State state, MultiStatus result) {
        Iterable _allOwningElementsUptoType = ContainmentUtils.getAllOwningElementsUptoType((Element)state, StateMachine.class);
        Functions.Function1<Element, Boolean> _function = new Functions.Function1<Element, Boolean>(){

            public Boolean apply(Element it) {
                return it instanceof State;
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_allOwningElementsUptoType, (Functions.Function1)_function);
        Functions.Function1<Element, State> _function_1 = new Functions.Function1<Element, State>(){

            public State apply(Element it) {
                return (State)it;
            }
        };
        Iterable containingStates = IterableExtensions.map((Iterable)_filter, (Functions.Function1)_function_1);
        Functions.Function1<State, Iterable<Transition>> _function_2 = new Functions.Function1<State, Iterable<Transition>>(){

            public Iterable<Transition> apply(State it) {
                return UMLRTStateMachProfileUtil.getAllOutgoingTransitions((State)it);
            }
        };
        Iterable _map = IterableExtensions.map((Iterable)containingStates, (Functions.Function1)_function_2);
        Iterable allOutgoingTransitionsHierarchy = Iterables.concat((Iterable)_map);
        Iterable _allOutgoingTransitions = UMLRTStateMachProfileUtil.getAllOutgoingTransitions((State)state);
        for (final Transition transition : _allOutgoingTransitions) {
            boolean _not;
            Functions.Function1<Transition, Boolean> _function_3 = new Functions.Function1<Transition, Boolean>(){

                public Boolean apply(Transition it) {
                    return PreUML2xtumlrtValidator.this.conflict(it, transition);
                }
            };
            Iterable otherEquivalentTransitions = IterableExtensions.filter((Iterable)allOutgoingTransitionsHierarchy, (Functions.Function1)_function_3);
            boolean _isEmpty = IterableExtensions.isEmpty((Iterable)otherEquivalentTransitions);
            boolean bl = _not = !_isEmpty;
            if (!_not) continue;
            String conflictingTransitions = this.prettyPrinter.multiLineListText(otherEquivalentTransitions);
            String _text = this.prettyPrinter.text((NamedElement)transition);
            String _plus = "The state has at least two conflicting (ambiguous) outgoing transitions with the same trigger and guard. \nTransition " + _text;
            String _plus_1 = String.valueOf(_plus) + "conflicts with the following:\n";
            String _plus_2 = String.valueOf(_plus_1) + conflictingTransitions;
            String _plus_3 = String.valueOf(_plus_2) + "\n";
            String _plus_4 = String.valueOf(_plus_3) + "The transition with the deepest source will be selected and the others ignored.\n";
            String _plus_5 = String.valueOf(_plus_4) + "If there is more than one such transitions any one of them will be selected and others will be ignored.\n";
            String _plus_6 = String.valueOf(_plus_5) + "Note that the transitions may have a different source, namely a composite state that contains this state.\n";
            StatusFactory.addWarningStatus((EObject)state, "State has conflicting transitions.", _plus_6, result);
            return;
        }
    }

    private boolean conflict(Transition transition1, Transition transition2) {
        return transition1 != transition2 && this.commonTrigger(transition1, transition2) && this.sameGuard(transition1, transition2);
    }

    private boolean sameGuard(Transition transition1, Transition transition2) {
        Constraint _guard_1;
        boolean _or = false;
        Constraint _guard = transition1.getGuard();
        boolean _equals = Objects.equal((Object)_guard, (Object)(_guard_1 = transition2.getGuard()));
        if (_equals) {
            _or = true;
        } else {
            boolean _equals_1;
            Constraint _guard_2 = transition1.getGuard();
            ValueSpecification _specification = null;
            if (_guard_2 != null) {
                _specification = _guard_2.getSpecification();
            }
            Constraint _guard_3 = transition2.getGuard();
            ValueSpecification _specification_1 = null;
            if (_guard_3 != null) {
                _specification_1 = _guard_3.getSpecification();
            }
            _or = _equals_1 = Objects.equal((Object)_specification, (Object)_specification_1);
        }
        return _or;
    }

    private boolean commonTrigger(Transition transition1, final Transition transition2) {
        EList _triggers = transition1.getTriggers();
        Functions.Function1<Trigger, Boolean> _function = new Functions.Function1<Trigger, Boolean>(){

            public Boolean apply(final Trigger t1) {
                EList _triggers = transition2.getTriggers();
                Functions.Function1<Trigger, Boolean> _function = new Functions.Function1<Trigger, Boolean>(){

                    public Boolean apply(Trigger t2) {
                        return PreUML2xtumlrtValidator.this.equivalentTrigger(t1, t2);
                    }
                };
                return IterableExtensions.exists((Iterable)_triggers, (Functions.Function1)_function);
            }
        };
        return IterableExtensions.exists((Iterable)_triggers, (Functions.Function1)_function);
    }

    private boolean equivalentTrigger(Trigger trigger1, final Trigger trigger2) {
        return Objects.equal((Object)trigger1, (Object)trigger2) || Objects.equal((Object)trigger1.getEvent(), (Object)trigger2.getEvent()) && IterableExtensions.exists((Iterable)trigger1.getPorts(), (Functions.Function1)new Functions.Function1<Port, Boolean>(){

            public Boolean apply(Port it) {
                EList _ports = trigger2.getPorts();
                return _ports.contains((Object)it);
            }
        });
    }

    protected void _validateElement(Transition transition, MultiStatus result) {
        EList _triggers;
        boolean _isEmpty;
        boolean _isFirstSegment = this.isFirstSegment(transition);
        if (_isFirstSegment && (_isEmpty = (_triggers = transition.getTriggers()).isEmpty())) {
            StatusFactory.addWarningStatus((EObject)transition, "Transition has no triggers", "A transition which is the first segment in a transition chain, i.e. a transition which leaves a state, should have at least one trigger. Triggers may be added in state machines of capsules which are subclasses of this capsule.", result);
        }
    }

    private boolean isFirstSegment(Transition t) {
        boolean _xblockexpression = false;
        Vertex source = t.getSource();
        _xblockexpression = source instanceof State || source instanceof Pseudostate && Objects.equal((Object)((Pseudostate)source).getKind(), (Object)PseudostateKind.EXIT_POINT_LITERAL) && source.getIncomings().isEmpty();
        return _xblockexpression;
    }

    protected void _validateElement(Trigger trigger, MultiStatus result) {
        EList _ports;
        boolean _isEmpty;
        Event _event;
        boolean _tripleEquals;
        boolean _not;
        boolean _isRTTrigger = UMLRTStateMachProfileUtil.isRTTrigger((Element)trigger);
        boolean bl = _not = !_isRTTrigger;
        if (_not) {
            StatusFactory.addWarningStatus((EObject)trigger, "Trigger doesn't have the \"RTTrigger\" stereotype applied.", "Triggers without the \"RTTrigger\" stereotype might lead to incorrectly generated code.", result);
        }
        boolean bl2 = _tripleEquals = (_event = trigger.getEvent()) == null;
        if (_tripleEquals) {
            StatusFactory.addWarningStatus((EObject)trigger, "Trigger has no event", "A trigger should have an event associated. Without an event, code generation might fail or it might produce incorrect code.", result);
        }
        if (_isEmpty = (_ports = trigger.getPorts()).isEmpty()) {
            StatusFactory.addWarningStatus((EObject)trigger, "Trigger has no ports", "A trigger should have at least one port associated. Without a port, code generation might fail or it might produce incorrect code.", result);
        }
    }

    protected void _validateElement(Pseudostate pseudostate, MultiStatus result) {
        boolean _isChoicePoint = UMLRTStateMachProfileUtil.isChoicePoint((Element)pseudostate);
        if (_isChoicePoint) {
            EList outgoingTransitions = pseudostate.getOutgoings();
            boolean _isEmpty = outgoingTransitions.isEmpty();
            if (_isEmpty) {
                StatusFactory.addWarningStatus((EObject)pseudostate, "Choice point has no outgoing transitions.", "A choice point should have outgoing transitions. Outgoing transitions may be specified in state machines of capsules which are subclasses of this capsule.", result);
            } else {
                boolean _equals;
                int _size = outgoingTransitions.size();
                boolean bl = _equals = _size == 1;
                if (_equals) {
                    boolean _tripleNotEquals;
                    Transition _get = (Transition)outgoingTransitions.get(0);
                    Constraint _guard = _get.getGuard();
                    boolean bl2 = _tripleNotEquals = _guard != null;
                    if (_tripleNotEquals) {
                        StatusFactory.addWarningStatus((EObject)pseudostate, "Choice point has exactly one guarded outgoing transition.", "If a choice point has only one outgoing transition, it should be guarded. ", result);
                    }
                } else {
                    boolean _greaterThan;
                    Functions.Function1<Transition, Boolean> _function = new Functions.Function1<Transition, Boolean>(){

                        public Boolean apply(Transition it) {
                            Constraint _guard = it.getGuard();
                            return _guard == null;
                        }
                    };
                    Iterable unguardedTransitions = IterableExtensions.filter((Iterable)outgoingTransitions, (Functions.Function1)_function);
                    int _size_1 = IterableExtensions.size((Iterable)unguardedTransitions);
                    boolean bl3 = _greaterThan = _size_1 > 1;
                    if (_greaterThan) {
                        StatusFactory.addWarningStatus((EObject)pseudostate, "Choice point has multiple unguarded transitions.", "A choice point should have one unguarded transition at most.", result);
                    }
                }
            }
        } else {
            boolean _isJunctionPoint = UMLRTStateMachProfileUtil.isJunctionPoint((Element)pseudostate);
            if (_isJunctionPoint) {
                EList _outgoings = pseudostate.getOutgoings();
                boolean _isEmpty_1 = _outgoings.isEmpty();
                if (_isEmpty_1) {
                    StatusFactory.addWarningStatus((EObject)pseudostate, "Junction point has no outgoing transitions.", "A junction point should have outgoing transitions. Outgoing transitions may be specified in state machines of capsules which are subclasses of this capsule.", result);
                } else {
                    boolean _greaterThan_1;
                    EList _outgoings_1 = pseudostate.getOutgoings();
                    int _size_2 = _outgoings_1.size();
                    boolean bl = _greaterThan_1 = _size_2 > 1;
                    if (_greaterThan_1) {
                        StatusFactory.addErrorStatus((EObject)pseudostate, "Junction point has more than one outgoing transition.", "A junction point can have one and only one outgoing transition.", result);
                    }
                }
            }
        }
    }

    protected void _validateDuplicateElement(Object element, MultiStatus result) {
    }

    protected void _validateDuplicateElement(final NamedElement element, MultiStatus result) {
        Functions.Function1<NamedElement, Boolean> _function;
        Namespace _namespace;
        EList _ownedMembers;
        Iterable _filter;
        boolean unique;
        if (element.getNamespace() != null && !Strings.isNullOrEmpty((String)element.getName()) && !(unique = IterableExtensions.isEmpty((Iterable)(_filter = IterableExtensions.filter((Iterable)(_ownedMembers = (_namespace = element.getNamespace()).getOwnedMembers()), (Functions.Function1)(_function = new Functions.Function1<NamedElement, Boolean>(){

            public Boolean apply(NamedElement e) {
                return e != element && e.eClass() == element.eClass() && Objects.equal((Object)e.getName(), (Object)element.getName());
            }
        })))))) {
            StatusFactory.addWarningStatus((EObject)element, "More than one element with the same name exist in the same namespace.", result);
        }
    }

    protected void validateElement(EObject port, MultiStatus result) {
        if (port instanceof Port) {
            this._validateElement((Port)port, result);
            return;
        }
        if (port instanceof Property) {
            this._validateElement((Property)port, result);
            return;
        }
        if (port instanceof Constraint) {
            this._validateElement((Constraint)port, result);
            return;
        }
        if (port instanceof Pseudostate) {
            this._validateElement((Pseudostate)port, result);
            return;
        }
        if (port instanceof State) {
            this._validateElement((State)port, result);
            return;
        }
        if (port instanceof Transition) {
            this._validateElement((Transition)port, result);
            return;
        }
        if (port instanceof Trigger) {
            this._validateElement((Trigger)port, result);
            return;
        }
        if (port instanceof MultiplicityElement) {
            this._validateElement((MultiplicityElement)port, result);
            return;
        }
        if (port != null) {
            this._validateElement(port, result);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(port, result).toString());
    }

    private boolean isUnlimited(ValueSpecification spec) {
        if (spec instanceof LiteralUnlimitedNatural) {
            return this._isUnlimited((LiteralUnlimitedNatural)spec);
        }
        if (spec != null) {
            return this._isUnlimited(spec);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(spec).toString());
    }

    protected void validateDuplicateElement(Object element, MultiStatus result) {
        if (element instanceof NamedElement) {
            this._validateDuplicateElement((NamedElement)element, result);
            return;
        }
        if (element != null) {
            this._validateDuplicateElement(element, result);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(element, result).toString());
    }
}

