/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.papyrus.propertytester;

import java.util.List;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrusrt.umlrt.core.utils.UMLRTProfileUtils;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Trigger;
import org.eclipse.uml2.uml.UMLPackage;

public class UMLRTPropertyTester
extends PropertyTester {
    private static final String STEREOTYPE_PROPERTY = "stereotype";
    private static final String ECLASS_PROPERTY = "eClass";
    private static final String IS_SOURCE_EDITABLE_PROPERTY = "isSourceEditable";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        EObject eobj;
        boolean result = false;
        Object element = receiver;
        if (receiver instanceof List && !((List)receiver).isEmpty()) {
            element = ((List)receiver).get(0);
        }
        if ((eobj = EMFHelper.getEObject((Object)element)) != null) {
            if (eobj instanceof Element && STEREOTYPE_PROPERTY.equals(property)) {
                Stereotype st = ((Element)eobj).getAppliedStereotype((String)expectedValue);
                result = st != null;
            } else if (ECLASS_PROPERTY.equals(property)) {
                result = eobj.eClass().getName().equals(expectedValue);
            } else if (IS_SOURCE_EDITABLE_PROPERTY.equals(property)) {
                result = ((Boolean)expectedValue).booleanValue() == this.isSourceEditable(eobj);
            }
        }
        return result;
    }

    private boolean isSourceEditable(EObject eo) {
        boolean result = false;
        if (eo instanceof Element && UMLRTProfileUtils.isUMLRTProfileApplied((Element)((Element)eo))) {
            if (eo.eClass().equals(UMLPackage.Literals.CLASS) || eo.eClass().equals(UMLPackage.Literals.OPERATION)) {
                result = true;
            } else if (eo instanceof Transition) {
                result = true;
            } else if (eo instanceof State) {
                result = true;
            } else if (eo instanceof Trigger) {
                result = true;
            }
        }
        return result;
    }
}

