/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.uml.internal.facade.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrusrt.umlrt.uml.FacadeObject;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTClassifier;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTFactory;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTPackage;
import org.eclipse.papyrusrt.umlrt.uml.internal.facade.UMLRTUMLRTPackage;
import org.eclipse.papyrusrt.umlrt.uml.internal.facade.impl.FacadeObjectImpl;
import org.eclipse.papyrusrt.umlrt.uml.internal.facade.impl.UMLRTNamedElementImpl;
import org.eclipse.uml2.common.util.CacheAdapter;
import org.eclipse.uml2.common.util.DerivedUnionEObjectEList;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.UMLPackage;

public abstract class UMLRTClassifierImpl
extends UMLRTNamedElementImpl
implements UMLRTClassifier {
    protected UMLRTClassifierImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return UMLRTUMLRTPackage.Literals.CLASSIFIER;
    }

    protected FacadeObjectImpl.BasicFacadeAdapter<? extends UMLRTClassifierImpl> createFacadeAdapter() {
        return new ClassifierAdapter<UMLRTClassifierImpl>(this);
    }

    @Override
    public List<UMLRTClassifier> getSpecifics() {
        CacheAdapter cache = this.getCacheAdapter();
        if (cache != null) {
            Resource eResource = this.eResource();
            List specifics = (List)cache.get(eResource, (EObject)this, (Object)UMLRTUMLRTPackage.Literals.CLASSIFIER__SPECIFIC);
            if (specifics == null) {
                specifics = new DerivedUnionEObjectEList(UMLRTClassifier.class, (InternalEObject)this, 15, null);
                cache.put(eResource, (EObject)this, (Object)UMLRTUMLRTPackage.Literals.CLASSIFIER__SPECIFIC, (Object)specifics);
            }
            return specifics;
        }
        return new DerivedUnionEObjectEList(UMLRTClassifier.class, (InternalEObject)this, 15, null);
    }

    static <C extends Classifier> Stream<C> specifics(C class_, Class<C> metaclass) {
        Stream<Generalization> generalizations = class_.getTargetDirectedRelationships().stream().filter(Generalization.class::isInstance).map(Generalization.class::cast);
        Stream<Classifier> result = generalizations.map(Generalization::getSpecific).filter(metaclass::isInstance).map(metaclass::cast);
        return result;
    }

    static <C extends Classifier> Set<C> collectSpecificClosure(C class_, Class<C> metaclass, Set<C> result) {
        UMLRTClassifierImpl.specifics(class_, metaclass).forEach(classifier -> {
            if (result.add(classifier)) {
                UMLRTClassifierImpl.collectSpecificClosure(classifier, metaclass, result);
            }
        });
        return result;
    }

    @Override
    public UMLRTClassifier getSpecific(String name) {
        return this.getSpecific(name, false, null);
    }

    @Override
    public UMLRTClassifier getSpecific(String name, boolean ignoreCase, EClass eClass) {
        for (UMLRTClassifier specific : this.getSpecifics()) {
            if (eClass != null && !eClass.isInstance((Object)specific) || name != null && (ignoreCase ? !name.equalsIgnoreCase(specific.getName()) : !name.equals(specific.getName()))) continue;
            return specific;
        }
        return null;
    }

    @Override
    public UMLRTClassifier getGeneral() {
        return null;
    }

    @Override
    public Classifier toUML() {
        return (Classifier)super.toUML();
    }

    @Override
    public UMLRTPackage getPackage() {
        return UMLRTPackage.getInstance(this.toUML().getNearestPackage());
    }

    @Override
    public List<? extends UMLRTClassifier> getAncestry() {
        throw new UnsupportedOperationException();
    }

    static <C extends Classifier> List<C> ancestry(C class_, Class<C> metaclass) {
        LinkedHashSet<C> result = new LinkedHashSet<C>();
        Object next = class_;
        while (next != null) {
            if (!result.add((C)next)) break;
            EList generals = next.getGenerals();
            next = !generals.isEmpty() && metaclass.isInstance(generals.get(0)) ? (Classifier)metaclass.cast(generals.get(0)) : null;
        }
        return new BasicEList.FastCompare(result);
    }

    @Override
    public Stream<? extends UMLRTClassifier> getHierarchy() {
        throw new UnsupportedOperationException();
    }

    static <C extends Classifier> Stream<C> hierarchy(C class_, Class<C> metaclass) {
        return Stream.concat(Stream.of(class_), UMLRTClassifierImpl.collectSpecificClosure(class_, metaclass, new LinkedHashSet()).stream());
    }

    @Override
    public boolean isSuperTypeOf(UMLRTClassifier classifier) {
        return classifier != null && classifier.getAncestry().contains(this);
    }

    @Override
    public void setGeneral(UMLRTClassifier general) {
        throw new UnsupportedOperationException();
    }

    protected static <C extends Classifier> void setGeneral(C specific, C general) {
        EList generals = specific.getGenerals();
        if (general == null) {
            new ArrayList<Generalization>((Collection<Generalization>)specific.getGeneralizations()).forEach(Element::destroy);
        } else if (generals.isEmpty()) {
            generals.add(general);
        } else if (generals.get(0) != general) {
            generals.set(0, general);
        }
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 14: {
                return this.getGeneral();
            }
            case 15: {
                return this.getSpecifics();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    protected Object facadeGetAll(int referenceID) {
        return this.eGet(referenceID, true, true);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 14: {
                return this.isSetGeneral();
            }
            case 15: {
                return this.isSetSpecifics();
            }
        }
        return super.eIsSet(featureID);
    }

    public boolean isSetGeneral() {
        return false;
    }

    public boolean isSetSpecifics() {
        return false;
    }

    protected static class ClassifierAdapter<F extends UMLRTClassifierImpl>
    extends UMLRTNamedElementImpl.NamedElementAdapter<F> {
        ClassifierAdapter(F facade) {
            super(facade);
        }

        @Override
        public void setTarget(Notifier newTarget) {
            Classifier classifier;
            EList generalizations;
            super.setTarget(newTarget);
            if (newTarget instanceof Classifier && !(generalizations = (classifier = (Classifier)newTarget).getGeneralizations()).isEmpty()) {
                this.addAdapter((Notifier)generalizations.get(0));
            }
        }

        public void unsetTarget(Notifier oldTarget) {
            Classifier classifier;
            EList generalizations;
            if (oldTarget instanceof Classifier && !(generalizations = (classifier = (Classifier)oldTarget).getGeneralizations()).isEmpty()) {
                generalizations.forEach(this::removeAdapter);
            }
            super.unsetTarget(oldTarget);
        }

        @Override
        protected void handleObjectAdded(Notification msg, int position, EObject object) {
            if (msg.getFeature() == UMLPackage.Literals.CLASSIFIER__GENERALIZATION) {
                if (((UMLRTClassifierImpl)this.get()).toUML().getGeneralizations().indexOf((Object)object) == 0) {
                    this.addAdapter((Notifier)object);
                }
            } else {
                super.handleObjectAdded(msg, position, object);
            }
        }

        @Override
        protected void handleObjectRemoved(Notification msg, int position, EObject object) {
            if (msg.getFeature() == UMLPackage.Literals.CLASSIFIER__GENERALIZATION) {
                this.removeAdapter((Notifier)object);
            } else {
                super.handleObjectRemoved(msg, position, object);
            }
        }

        @Override
        protected FacadeObject getFacade(EObject umlOwner, EReference umlReference, EObject object) {
            if (object instanceof Generalization) {
                Classifier general = ((Generalization)object).getGeneral();
                return general == null ? null : UMLRTFactory.create((NamedElement)general);
            }
            return super.getFacade(umlOwner, umlReference, object);
        }

        @Override
        protected void handleObjectReplaced(Notification msg, int position, FacadeObject oldObject, FacadeObject newObject) {
            if (msg.getFeature() == UMLPackage.Literals.CLASSIFIER__GENERALIZATION) {
                if (position == 0) {
                    this.notifyGeneral((UMLRTClassifierImpl)this.get(), oldObject, newObject);
                }
            } else if (msg.getFeature() == UMLPackage.Literals.GENERALIZATION__GENERAL) {
                this.notifyGeneral((UMLRTClassifierImpl)this.get(), oldObject, newObject);
            } else {
                super.handleObjectReplaced(msg, position, oldObject, newObject);
            }
        }

        protected void notifyGeneral(F owner, FacadeObject oldObject, FacadeObject newObject) {
            if (owner.eNotificationRequired()) {
                owner.eNotify((Notification)new ENotificationImpl(owner, 1, (EStructuralFeature)UMLRTUMLRTPackage.Literals.CLASSIFIER__GENERAL, (Object)oldObject, (Object)newObject));
            }
        }
    }
}

