/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.uml.internal.facade.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.UMLRealTimePackage;
import org.eclipse.papyrusrt.umlrt.profile.statemachine.UMLRTStateMachines.UMLRTStateMachinesPackage;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTFactory;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTInheritanceKind;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTModel;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTNamedElement;
import org.eclipse.papyrusrt.umlrt.uml.internal.facade.UMLRTUMLRTPackage;
import org.eclipse.papyrusrt.umlrt.uml.internal.facade.impl.FacadeEMap;
import org.eclipse.papyrusrt.umlrt.uml.internal.facade.impl.FacadeObjectImpl;
import org.eclipse.papyrusrt.umlrt.uml.internal.facade.impl.InternalFacadeEMap;
import org.eclipse.papyrusrt.umlrt.uml.internal.impl.InternalUMLRTElement;
import org.eclipse.papyrusrt.umlrt.uml.internal.umlext.ExtUMLExtPackage;
import org.eclipse.uml2.common.util.CacheAdapter;
import org.eclipse.uml2.common.util.DerivedUnionEObjectEList;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.util.UMLUtil;

public abstract class UMLRTNamedElementImpl
extends FacadeObjectImpl
implements UMLRTNamedElement {
    protected int fFlags = 0;
    protected static final UMLRTModel MODEL_EDEFAULT = null;
    protected static final UMLRTInheritanceKind INHERITANCE_KIND_EDEFAULT = UMLRTInheritanceKind.INHERITED;
    protected static final String NAME_EDEFAULT = null;
    protected static final String QUALIFIED_NAME_EDEFAULT = null;
    protected static final boolean IS_INHERITED_EDEFAULT = false;
    protected static final boolean IS_VIRTUAL_REDEFINITION_EDEFAULT = false;
    protected static final boolean IS_REDEFINITION_EDEFAULT = false;
    protected static final boolean IS_EXCLUDED_EDEFAULT = false;

    protected UMLRTNamedElementImpl() {
    }

    protected EClass eStaticClass() {
        return UMLRTUMLRTPackage.Literals.NAMED_ELEMENT;
    }

    protected FacadeObjectImpl.BasicFacadeAdapter<? extends UMLRTNamedElementImpl> createFacadeAdapter() {
        return new NamedElementAdapter<UMLRTNamedElementImpl>(this);
    }

    @Override
    public UMLRTNamedElement getRedefinedElement() {
        return null;
    }

    @Override
    public UMLRTNamedElement getRedefinitionContext() {
        return null;
    }

    @Override
    public List<UMLRTNamedElement> getRedefinableElements() {
        CacheAdapter cache = this.getCacheAdapter();
        if (cache != null) {
            Resource eResource = this.eResource();
            List redefinableElements = (List)cache.get(eResource, (EObject)this, (Object)UMLRTUMLRTPackage.Literals.NAMED_ELEMENT__REDEFINABLE_ELEMENT);
            if (redefinableElements == null) {
                redefinableElements = new DerivedUnionEObjectEList(UMLRTNamedElement.class, (InternalEObject)this, 10, null);
                cache.put(eResource, (EObject)this, (Object)UMLRTUMLRTPackage.Literals.NAMED_ELEMENT__REDEFINABLE_ELEMENT, (Object)redefinableElements);
            }
            return redefinableElements;
        }
        return new DerivedUnionEObjectEList(UMLRTNamedElement.class, (InternalEObject)this, 10, null);
    }

    @Override
    public UMLRTNamedElement getRedefinableElement(String name) {
        return this.getRedefinableElement(name, false, null);
    }

    @Override
    public UMLRTNamedElement getRedefinableElement(String name, boolean ignoreCase, EClass eClass) {
        for (UMLRTNamedElement redefinableElement : this.getRedefinableElements()) {
            if (eClass != null && !eClass.isInstance((Object)redefinableElement) || name != null && (ignoreCase ? !name.equalsIgnoreCase(redefinableElement.getName()) : !name.equals(redefinableElement.getName()))) continue;
            return redefinableElement;
        }
        return null;
    }

    @Override
    public UMLRTModel getModel() {
        return UMLRTModel.getInstance(this.toUML().eResource());
    }

    @Override
    public UMLRTInheritanceKind getInheritanceKind() {
        return UMLRTInheritanceKind.of((Element)this.toUML());
    }

    @Override
    public String getName() {
        return this.toUML().getName();
    }

    @Override
    public void setName(String newName) {
        this.toUML().setName(newName);
    }

    @Override
    public String getQualifiedName() {
        return this.toUML().getQualifiedName();
    }

    @Override
    public boolean isInherited() {
        return this.getInheritanceKind() != UMLRTInheritanceKind.NONE;
    }

    @Override
    public boolean isVirtualRedefinition() {
        return this.getInheritanceKind() == UMLRTInheritanceKind.INHERITED;
    }

    @Override
    public boolean isRedefinition() {
        return this.getInheritanceKind() == UMLRTInheritanceKind.REDEFINED;
    }

    @Override
    public boolean isExcluded() {
        return this.getInheritanceKind() == UMLRTInheritanceKind.EXCLUDED;
    }

    @Override
    public UMLRTNamedElement getInheritedElement() {
        UMLRTNamedElement result = this.getRedefinedElement();
        if (result != null && result.isVirtualRedefinition()) {
            result = result.getInheritedElement();
        }
        return result;
    }

    @Override
    public UMLRTNamedElement getRootDefinition() {
        UMLRTNamedElement result = this;
        UMLRTNamedElement inh = result.getInheritedElement();
        while (inh != null) {
            result = inh;
            inh = result.getInheritedElement();
        }
        return result;
    }

    @Override
    public List<UMLRTNamedElement> getExcludedElements() {
        return (List)this.excludedElements().collect(Collectors.collectingAndThen(Collectors.toList(), list -> this.elist((EStructuralFeature)UMLRTUMLRTPackage.Literals.NAMED_ELEMENT__EXCLUDED_ELEMENT, list)));
    }

    protected Stream<? extends UMLRTNamedElement> excludedElements() {
        return this.exclusions().map(UMLRTFactory::create).filter(Objects::nonNull);
    }

    protected Stream<NamedElement> exclusions() {
        NamedElement uml = this.toUML();
        return uml instanceof Namespace ? UMLRTNamedElementImpl.exclusions((Namespace)uml) : Stream.empty();
    }

    protected static Stream<NamedElement> exclusions(Namespace namespace) {
        return namespace instanceof InternalUMLRTElement ? ((List)namespace.eGet((EStructuralFeature)ExtUMLExtPackage.Literals.NAMESPACE__EXCLUDED_MEMBER)).stream().filter(NamedElement.class::isInstance).map(NamedElement.class::cast) : Stream.empty();
    }

    @Override
    public UMLRTNamedElement getExcludedElement(String name) {
        return this.getExcludedElement(name, false, null);
    }

    @Override
    public UMLRTNamedElement getExcludedElement(String name, boolean ignoreCase, EClass eClass) {
        for (UMLRTNamedElement excludedElement : this.getExcludedElements()) {
            if (eClass != null && !eClass.isInstance((Object)excludedElement) || name != null && (ignoreCase ? !name.equalsIgnoreCase(excludedElement.getName()) : !name.equals(excludedElement.getName()))) continue;
            return excludedElement;
        }
        return null;
    }

    @Override
    public NamedElement toUML() {
        return (NamedElement)super.toUML();
    }

    @Override
    public boolean redefines(UMLRTNamedElement element) {
        boolean result;
        boolean bl = result = element == this;
        if (!result) {
            int count = 0;
            UMLRTNamedElement redefined = this.getRedefinedElement();
            while (!result && redefined != null) {
                if (++count > 100000) {
                    return redefined.redefines(element);
                }
                if (redefined == this) {
                    throw new IllegalStateException("Redefinition cycle including " + this);
                }
                result = redefined == element;
                redefined = redefined.getRedefinedElement();
            }
        }
        return result;
    }

    @Override
    public <T extends UMLRTNamedElement> T getRedefinitionOf(T element) {
        return (T)((UMLRTNamedElement)Stream.concat(this.getRedefinableElements().stream(), this.getExcludedElements().stream()).filter(e -> e.redefines(element)).findAny().orElse(null));
    }

    @Override
    public List<UMLRTNamedElement> getRedefinitionChain() {
        Object result;
        UMLRTNamedElement redef = this.getRedefinedElement();
        if (redef == null) {
            result = ECollections.singletonEList((Object)this);
        } else {
            result = new ArrayList(3);
            result.add(this);
            while (redef != null) {
                result.add(redef);
                redef = redef.getRedefinedElement();
            }
            result = ECollections.unmodifiableEList((List)result);
        }
        return result;
    }

    @Override
    public <T extends UMLRTNamedElement> T getExcludedElement(String name, Class<T> type) {
        return (T)((UMLRTNamedElement)this.excludedElements().filter(type::isInstance).filter(e -> Objects.equals(e.getName(), name)).map(type::cast).findAny().orElse(null));
    }

    @Override
    public Stream<? extends UMLRTNamedElement> allRedefinitions() {
        return Stream.of(this);
    }

    @Override
    public boolean exclude() {
        boolean result = false;
        NamedElement uml = this.toUML();
        if (uml instanceof InternalUMLRTElement) {
            result = ((InternalUMLRTElement)uml).rtExclude();
        }
        return result;
    }

    @Override
    public boolean reinherit() {
        boolean result = false;
        NamedElement uml = this.toUML();
        if (uml instanceof InternalUMLRTElement) {
            result = ((InternalUMLRTElement)uml).rtReinherit();
        }
        return result;
    }

    @Override
    public void reify() {
        InternalUMLRTElement internal;
        NamedElement uml = this.toUML();
        if (uml instanceof InternalUMLRTElement && (internal = (InternalUMLRTElement)uml).rtIsVirtual()) {
            internal.rtReify();
        }
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 8: {
                return this.getRedefinedElement();
            }
            case 9: {
                return this.getRedefinitionContext();
            }
            case 10: {
                return this.getRedefinableElements();
            }
            case 0: {
                return this.getModel();
            }
            case 1: {
                return this.getInheritanceKind();
            }
            case 2: {
                return this.getName();
            }
            case 3: {
                return this.getQualifiedName();
            }
            case 4: {
                return this.isInherited();
            }
            case 5: {
                return this.isVirtualRedefinition();
            }
            case 6: {
                return this.isRedefinition();
            }
            case 7: {
                return this.isExcluded();
            }
            case 11: {
                return this.getInheritedElement();
            }
            case 12: {
                return this.getRootDefinition();
            }
            case 13: {
                return this.getExcludedElements();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    protected Object facadeGetAll(int referenceID) {
        return this.eGet(referenceID, true, true);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 2: {
                this.setName((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 2: {
                this.setName(NAME_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 8: {
                return this.isSetRedefinedElement();
            }
            case 9: {
                return this.isSetRedefinitionContext();
            }
            case 10: {
                return this.isSetRedefinableElements();
            }
            case 0: {
                return MODEL_EDEFAULT == null ? this.getModel() != null : !MODEL_EDEFAULT.equals(this.getModel());
            }
            case 1: {
                return this.getInheritanceKind() != INHERITANCE_KIND_EDEFAULT;
            }
            case 2: {
                return NAME_EDEFAULT == null ? this.getName() != null : !NAME_EDEFAULT.equals(this.getName());
            }
            case 3: {
                return QUALIFIED_NAME_EDEFAULT == null ? this.getQualifiedName() != null : !QUALIFIED_NAME_EDEFAULT.equals(this.getQualifiedName());
            }
            case 4: {
                return this.isInherited();
            }
            case 5: {
                return this.isVirtualRedefinition();
            }
            case 6: {
                return this.isRedefinition();
            }
            case 7: {
                return this.isExcluded();
            }
            case 11: {
                return this.getInheritedElement() != null;
            }
            case 12: {
                return this.getRootDefinition() != null;
            }
            case 13: {
                return !this.getExcludedElements().isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    protected EObject create(EClass eClass) {
        return EcoreUtil.create((EClass)eClass);
    }

    protected <T extends EObject> T applyStereotype(Element base, Class<T> stereotype) {
        EClass eClass = (EClass)UMLRealTimePackage.eINSTANCE.getEClassifier(stereotype.getSimpleName());
        if (eClass == null) {
            eClass = (EClass)UMLRTStateMachinesPackage.eINSTANCE.getEClassifier(stereotype.getSimpleName());
        }
        return (T)((EObject)stereotype.cast(UMLUtil.StereotypeApplicationHelper.getInstance((Notifier)this.toUML()).applyStereotype(base, eClass)));
    }

    protected CacheAdapter getCacheAdapter() {
        return CacheAdapter.getCacheAdapter((Notifier)this.toUML());
    }

    protected static String initialLower(String name) {
        String result;
        if (UML2Util.isEmpty((String)name)) {
            result = name;
        } else {
            StringBuilder buf = new StringBuilder(name.length());
            buf.append(Character.toLowerCase(name.charAt(0)));
            buf.append(name, 1, name.length());
            result = buf.toString();
        }
        return result;
    }

    public boolean isSetRedefinedElement() {
        return false;
    }

    public boolean isSetRedefinitionContext() {
        return false;
    }

    public boolean isSetRedefinableElements() {
        return false;
    }

    @Override
    public String toString() {
        String pattern = this.isExcluded() ? "%s[X](name=%s)" : "%s(name=%s)";
        return String.format(pattern, this.eClass().getName(), this.getName());
    }

    protected static class Code
    extends FacadeEMap<String, String> {
        private static final long serialVersionUID = 1L;
        private boolean initializing;

        protected Code(UMLRTNamedElementImpl owner, int featureID) {
            super(owner, EcorePackage.Literals.ESTRING_TO_STRING_MAP_ENTRY, BasicEMap.Entry.class, featureID);
            List<String> languages = Code.getLanguages(this.getCodeOwner());
            List<String> bodies = Code.getBodies(this.getCodeOwner());
            int count = Math.min(languages.size(), bodies.size());
            int i = 0;
            while (i < count) {
                BasicEMap.Entry entry = (BasicEMap.Entry)EcoreUtil.create((EClass)EcorePackage.Literals.ESTRING_TO_STRING_MAP_ENTRY);
                entry.setKey((Object)languages.get(i));
                entry.setValue((Object)bodies.get(i));
                this.facadeAdd(entry);
                ++i;
            }
        }

        protected EObject getCodeOwner() {
            UMLRTNamedElement owner = (UMLRTNamedElement)this.getEObject();
            return owner.toUML();
        }

        @Override
        protected void ensureEntryDataExists() {
            this.initializing = true;
            try {
                super.ensureEntryDataExists();
            }
            finally {
                this.initializing = false;
            }
        }

        protected void didAdd(BasicEMap.Entry<String, String> entry) {
            if (this.initializing) {
                return;
            }
            int index = Code.getLanguages(this.getCodeOwner()).indexOf(entry.getKey());
            if (index >= 0) {
                Code.getBodies(this.getCodeOwner()).set(index, (String)entry.getValue());
            } else {
                Code.getLanguages(this.getCodeOwner()).add((String)entry.getKey());
                Code.getBodies(this.getCodeOwner()).add((String)entry.getValue());
            }
        }

        protected void didRemove(BasicEMap.Entry<String, String> entry) {
            List<String> languages = Code.getLanguages(this.getCodeOwner());
            List<String> bodies = Code.getBodies(this.getCodeOwner());
            int count = Math.min(languages.size(), bodies.size());
            int i = 0;
            while (i < count) {
                if (Objects.equals(languages.get(i), entry.getKey()) && Objects.equals(bodies.get(i), entry.getValue())) {
                    languages.remove(i);
                    bodies.remove(i);
                    break;
                }
                ++i;
            }
        }

        protected void didModify(BasicEMap.Entry<String, String> entry, String oldValue) {
            int index = Code.getLanguages(this.getCodeOwner()).indexOf(entry.getKey());
            if (index < 0) {
                throw new IllegalArgumentException("No such language: " + (String)entry.getKey());
            }
            Code.getBodies(this.getCodeOwner()).set(index, (String)entry.getValue());
        }

        protected static List<String> getLanguages(Object owner) {
            EList result = owner instanceof OpaqueExpression ? ((OpaqueExpression)owner).getLanguages() : (owner instanceof OpaqueBehavior ? ((OpaqueBehavior)owner).getLanguages() : ECollections.emptyEList());
            return result;
        }

        protected static List<String> getBodies(Object owner) {
            EList result = owner instanceof OpaqueExpression ? ((OpaqueExpression)owner).getBodies() : (owner instanceof OpaqueBehavior ? ((OpaqueBehavior)owner).getBodies() : ECollections.emptyEList());
            return result;
        }
    }

    protected static class NamedElementAdapter<F extends UMLRTNamedElementImpl>
    extends FacadeObjectImpl.Reactor<F> {
        NamedElementAdapter(F facade) {
            super(facade);
        }

        @Override
        protected void handleValueReplaced(Notification msg, int position, Object oldValue, Object newValue) {
            if (msg.getFeature() == UMLPackage.Literals.NAMED_ELEMENT__NAME) {
                if (((UMLRTNamedElementImpl)this.get()).eNotificationRequired()) {
                    ((UMLRTNamedElementImpl)this.get()).eNotify((Notification)new ENotificationImpl((InternalEObject)this.get(), msg.getEventType(), (EStructuralFeature)UMLRTUMLRTPackage.Literals.NAMED_ELEMENT__NAME, oldValue, newValue));
                }
            } else {
                super.handleValueReplaced(msg, position, oldValue, newValue);
            }
        }

        protected static abstract class WithCode<F extends UMLRTNamedElementImpl>
        extends NamedElementAdapter<F> {
            WithCode(F facade) {
                super(facade);
            }

            protected abstract InternalFacadeEMap<String, String> getCode();

            @Override
            protected void handleValueAdded(Notification msg, int position, Object value) {
                Object feature = msg.getFeature();
                if ((feature == UMLPackage.Literals.OPAQUE_EXPRESSION__LANGUAGE || feature == UMLPackage.Literals.OPAQUE_EXPRESSION__BODY || feature == UMLPackage.Literals.OPAQUE_BEHAVIOR__LANGUAGE || feature == UMLPackage.Literals.OPAQUE_BEHAVIOR__BODY) && this.getCode() != null) {
                    List<String> languages = Code.getLanguages(msg.getNotifier());
                    List<String> bodies = Code.getBodies(msg.getNotifier());
                    if (languages.size() == bodies.size()) {
                        this.getCode().facadePut(languages.get(position), bodies.get(position));
                    }
                }
            }

            @Override
            protected void handleValueRemoved(Notification msg, int position, Object value) {
                Object feature = msg.getFeature();
                if (feature == UMLPackage.Literals.OPAQUE_EXPRESSION__LANGUAGE || feature == UMLPackage.Literals.OPAQUE_BEHAVIOR__LANGUAGE) {
                    if (this.getCode() != null) {
                        this.getCode().facadeRemoveKey(value);
                    }
                } else if ((feature == UMLPackage.Literals.OPAQUE_EXPRESSION__BODY || feature == UMLPackage.Literals.OPAQUE_BEHAVIOR__BODY) && this.getCode() != null) {
                    List<String> languages = Code.getLanguages(msg.getNotifier());
                    List<String> bodies = Code.getBodies(msg.getNotifier());
                    if (languages.size() == bodies.size()) {
                        this.getCode().entrySet().stream().filter(entry -> Objects.equals(value, entry.getValue())).findFirst().ifPresent(entry -> {
                            int languageIndex = languages.indexOf(entry.getKey());
                            if (languageIndex >= 0) {
                                entry.setValue((String)bodies.get(languageIndex));
                            }
                        });
                    }
                }
            }

            @Override
            protected void handleValueReplaced(Notification msg, int position, Object oldValue, Object newValue) {
                List<String> languages;
                if (msg.getFeature() == UMLPackage.Literals.OPAQUE_EXPRESSION__LANGUAGE || msg.getFeature() == UMLPackage.Literals.OPAQUE_BEHAVIOR__LANGUAGE) {
                    if (this.getCode() != null) {
                        String body = this.getCode().facadeRemoveKey(oldValue);
                        this.getCode().facadePut((String)newValue, body);
                    }
                } else if ((msg.getFeature() == UMLPackage.Literals.OPAQUE_EXPRESSION__BODY || msg.getFeature() == UMLPackage.Literals.OPAQUE_BEHAVIOR__BODY) && this.getCode() != null && (languages = Code.getLanguages(msg.getNotifier())).size() > position) {
                    String language = languages.get(position);
                    this.getCode().facadePut(language, (String)newValue);
                }
            }
        }
    }
}

