/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.uml.internal.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrusrt.umlrt.uml.internal.facade.impl.FacadeAdapter;
import org.eclipse.papyrusrt.umlrt.uml.internal.impl.InternalUMLRTRedefinitionContext;
import org.eclipse.papyrusrt.umlrt.uml.internal.operations.ElementRTOperations;
import org.eclipse.papyrusrt.umlrt.uml.internal.operations.RedefinableElementRTOperations;
import org.eclipse.papyrusrt.umlrt.uml.internal.umlext.util.ExtensionResource;
import org.eclipse.papyrusrt.umlrt.uml.internal.util.ReificationAdapter;
import org.eclipse.uml2.common.util.CacheAdapter;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.RedefinableElement;
import org.eclipse.uml2.uml.util.UMLUtil;

public interface InternalUMLRTElement
extends InternalEObject {
    public int eDerivedStructuralFeatureID(EStructuralFeature var1);

    default public boolean rtIsSet(EStructuralFeature feature) {
        return this.eIsSet(feature);
    }

    default public <T> T umlGet(EStructuralFeature feature) {
        int featureID = this.eDerivedStructuralFeatureID(feature);
        return (T)(featureID >= 0 ? this.umlGet(featureID) : this.eGet(feature));
    }

    public <T> T umlGet(int var1);

    default public void rtCreateExtension() {
        throw new UnsupportedOperationException("createExtension");
    }

    default public void rtDestroyExtension() {
        throw new UnsupportedOperationException("destroyExtension");
    }

    default public boolean rtHasExtension() {
        return false;
    }

    default public <T extends EObject> T rtExtension(Class<T> extensionClass) {
        return null;
    }

    default public void rtSuppressForwardingWhile(Runnable action) {
        action.run();
    }

    default public <T> T inheritFeature(EStructuralFeature feature) {
        Object result;
        if (feature instanceof EReference) {
            EReference reference = (EReference)feature;
            Function<? super EObject, ? extends EObject> resolver = null;
            if (!reference.isContainment() && !reference.isContainer()) {
                resolver = this.rtGetInheritanceResolver(reference);
            }
            result = resolver == null ? RedefinableElementRTOperations.inheritFeature(this, feature, CacheAdapter.getInstance()) : RedefinableElementRTOperations.inheritReference(this, reference, CacheAdapter.getInstance(), resolver);
        } else {
            result = RedefinableElementRTOperations.inheritFeature(this, feature, CacheAdapter.getInstance());
        }
        return result;
    }

    default public Function<? super EObject, ? extends EObject> rtGetInheritanceResolver(EReference reference) {
        return null;
    }

    default public Collection<? extends EStructuralFeature> rtInheritedFeatures() {
        return Collections.emptySet();
    }

    default public boolean rtIsRedefinition() {
        return this.rtIsVirtual() || RedefinableElementRTOperations.isRedefinition(this);
    }

    default public <R extends InternalUMLRTElement> R rtGetRedefinedElement() {
        return (R)RedefinableElementRTOperations.getRedefinedElement(this);
    }

    default public <R extends InternalUMLRTElement> R rtGetRootDefinition() {
        return (R)RedefinableElementRTOperations.getNearestDefinition(this, __ -> false);
    }

    default public <R extends InternalUMLRTElement> R rtGetNearestRealDefinition() {
        Predicate<InternalUMLRTElement> isVirtual = InternalUMLRTElement::rtIsVirtual;
        return (R)RedefinableElementRTOperations.getNearestDefinition(this, isVirtual.negate());
    }

    default public boolean rtRedefines(InternalUMLRTElement element) {
        boolean result;
        boolean bl = result = element == this;
        if (!result) {
            result = RedefinableElementRTOperations.getNearestDefinition(this, e -> e == element) == element;
        }
        return result;
    }

    default public <R extends InternalUMLRTElement> Stream<R> rtGetRedefinitions() {
        InternalUMLRTElement self = this;
        Stream<InternalUMLRTElement> result = Stream.of(self);
        if (this.rtOwner() instanceof InternalUMLRTRedefinitionContext) {
            InternalUMLRTRedefinitionContext context = (InternalUMLRTRedefinitionContext)this.rtOwner();
            Stream<InternalUMLRTElement> redefineMe = context.rtDescendants().map(descendant -> descendant.rtGetRedefinitionOf(self)).filter(Objects::nonNull);
            result = Stream.concat(result, redefineMe);
        }
        return result;
    }

    default public void umlSetRedefinedElement(InternalUMLRTElement redefined) {
        throw new UnsupportedOperationException("redefinition not supported");
    }

    default public boolean rtIsExcluded() {
        return RedefinableElementRTOperations.isExcluded(this);
    }

    default public Element rtGetElement() {
        return this instanceof Element ? (Element)this : UMLUtil.getBaseElement((EObject)this);
    }

    default public void rtDelete() {
        ElementRTOperations.delete((EObject)this);
    }

    default public boolean rtExclude() {
        return this.run(() -> {
            boolean result = RedefinableElementRTOperations.exclude(this);
            if (result) {
                this.rtUnsetAll();
                Element owner = this.rtOwner();
                if (owner != null && this instanceof Element) {
                    FacadeAdapter.getInstance((Notifier)owner).ifPresent(a -> a.excluded((Element)this));
                }
            }
            return result;
        });
    }

    default public boolean rtReinherit() {
        return this.run(() -> {
            boolean result = RedefinableElementRTOperations.reinherit(this);
            if (result) {
                this.rtUnsetAll();
                Element owner = this.rtOwner();
                if (owner != null && this instanceof Element) {
                    FacadeAdapter.getInstance((Notifier)owner).ifPresent(a -> a.reinherited((Element)this));
                }
            }
            return result;
        });
    }

    public void rtUnsetAll();

    default public void rtRedefine(InternalUMLRTElement element) {
        if (element.eClass() != this.eClass()) {
            throw new IllegalArgumentException(String.format("a %s cannot redefine a %s", this.eClass().getName(), element.eClass().getName()));
        }
        RedefinableElementRTOperations.redefine((RedefinableElement)this, (RedefinableElement)element);
    }

    default public Element rtOwner() {
        return RedefinableElementRTOperations.getOwner(this);
    }

    default public Resource rtResource() {
        return this.eInternalResource();
    }

    default public void rtReify() {
        throw new UnsupportedOperationException("rtReify");
    }

    default public void rtVirtualize() {
        throw new UnsupportedOperationException("rtVirtualize");
    }

    default public void run(Runnable action) {
        ReificationAdapter adapter = ReificationAdapter.getInstance((Notifier)this);
        if (adapter == null) {
            action.run();
        } else {
            adapter.run(action);
        }
    }

    default public <V> V run(Callable<V> action) {
        V result;
        ReificationAdapter adapter = ReificationAdapter.getInstance((Notifier)this);
        if (adapter == null) {
            try {
                result = action.call();
            }
            catch (Exception e) {
                throw new WrappedException(e);
            }
        } else {
            result = adapter.run(action);
        }
        return result;
    }

    default public boolean rtApplyStereotypes(InternalUMLRTElement prototype) {
        boolean result = false;
        if (this instanceof Element && prototype.eClass() == this.eClass()) {
            result = ElementRTOperations.rtApplyStereotype((InternalUMLRTElement)((Element)this), (InternalUMLRTElement)((Element)prototype));
        }
        return result;
    }

    default public void rtAdjustStereotypes() {
        if (this instanceof Element) {
            Element element = (Element)this;
            TreeIterator contents = EcoreUtil.getAllContents(Collections.singleton(element));
            while (contents.hasNext()) {
                EObject next = (EObject)contents.next();
                if (next instanceof Element && next instanceof InternalUMLRTElement) {
                    Element nextElement = (Element)next;
                    InternalUMLRTElement nextInternal = (InternalUMLRTElement)nextElement;
                    ArrayList stereotypeApplications = new ArrayList(nextElement.getStereotypeApplications());
                    if (!stereotypeApplications.isEmpty()) {
                        if (nextInternal.rtIsVirtual()) {
                            nextInternal.rtResource().getContents().addAll(stereotypeApplications);
                        } else {
                            UMLUtil.StereotypeApplicationHelper helper = UMLUtil.StereotypeApplicationHelper.getInstance((Notifier)this);
                            stereotypeApplications.forEach(appl -> {
                                boolean bl = helper.addToContainmentList(nextElement, appl);
                            });
                        }
                    }
                    if (nextInternal.rtIsVirtual() || !nextInternal.rtIsRedefinition() || !(next instanceof RedefinableElement)) continue;
                    RedefinableElementRTOperations.ensureStereotype((RedefinableElement)((InternalUMLRTElement)next));
                    continue;
                }
                contents.prune();
            }
        }
    }

    default public boolean rtIsVirtual() {
        InternalEObject container;
        boolean result = this.rtResource() instanceof ExtensionResource;
        if (!result && (container = this.eInternalContainer()) != null) {
            EReference containment = this.eContainmentFeature();
            result = !container.eIsSet((EStructuralFeature)containment);
        }
        return result;
    }

    public EObject create(EClass var1);
}

