/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.xtumlrt.trans.to.text.ui.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.onefile.model.IPapyrusFile;
import org.eclipse.papyrus.infra.onefile.model.ISubResourceFile;
import org.eclipse.papyrus.infra.onefile.utils.OneFileUtils;
import org.eclipse.papyrusrt.xtumlrt.external.ExternalPackageManager;
import org.eclipse.papyrusrt.xtumlrt.external.ExternalPackageMetadata;
import org.eclipse.papyrusrt.xtumlrt.trans.to.text.UMLRT2textTransformer;
import org.eclipse.papyrusrt.xtumlrt.util.XTUMLRTLogger;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.handlers.HandlerUtil;

public class UMLRT2textHandler
extends AbstractHandler {
    private static final ExternalPackageMetadata[] REQUIRED_PACKAGES = new ExternalPackageMetadata[0];
    private static final IStatus OK_STATUS = new Status(0, "org.eclipse.papyrusrt.xtumlrt.trans.to.text.ui", "ok");
    private boolean forceExternalPackageReset = true;
    private ExternalPackageManager externalPackageManager;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            Object firstElement = structuredSelection.getFirstElement();
            IFile file = null;
            if (firstElement instanceof IFile) {
                file = (IFile)firstElement;
            } else if (firstElement instanceof IPapyrusFile) {
                IFile[] associatedFiles;
                IPapyrusFile papyrusFile = (IPapyrusFile)firstElement;
                IFile[] iFileArray = associatedFiles = OneFileUtils.getAssociatedFiles((IPapyrusFile)papyrusFile);
                int n = associatedFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    IFile f = iFileArray[n2];
                    if ("uml".equals(f.getFileExtension())) {
                        file = f;
                        break;
                    }
                    ++n2;
                }
            } else if (firstElement instanceof ISubResourceFile) {
                ISubResourceFile subResourceFile = (ISubResourceFile)firstElement;
                file = subResourceFile.getFile();
            }
            if (file != null) {
                ResourceSetImpl resourceSet = new ResourceSetImpl();
                this.setupExternalPackageManagement((ResourceSet)resourceSet);
                IStatus result = this.processFile(file);
                MessageBox dialog = new MessageBox(Display.getCurrent().getActiveShell(), 34);
                dialog.setText("Information");
                if (result.getSeverity() == 4) {
                    dialog.setMessage("Operation failed: " + result.getException().getMessage());
                } else if (result.getSeverity() == 8) {
                    dialog.setMessage("Operation cancelled.");
                } else {
                    dialog.setMessage("Operation completed.");
                }
                dialog.open();
            }
        }
        return null;
    }

    private IStatus setupExternalPackageManagement(ResourceSet resourceSet) {
        IStatus success = OK_STATUS;
        this.externalPackageManager = ExternalPackageManager.getInstance();
        if (this.forceExternalPackageReset) {
            this.externalPackageManager.reset();
        }
        this.externalPackageManager.setResourceSet(resourceSet);
        this.externalPackageManager.setStandalone(false);
        ExternalPackageMetadata[] externalPackageMetadataArray = REQUIRED_PACKAGES;
        int n = REQUIRED_PACKAGES.length;
        int n2 = 0;
        while (n2 < n) {
            ExternalPackageMetadata metadata = externalPackageMetadataArray[n2];
            this.externalPackageManager.addRequiredPackage(metadata);
            ++n2;
        }
        success = this.externalPackageManager.setup();
        return success;
    }

    private IStatus processFile(IFile file) {
        IStatus result = Status.OK_STATUS;
        URI uri = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
        EObject inputModel = this.loadInputModel(uri);
        UMLRT2textTransformer transformer = new UMLRT2textTransformer();
        transformer.setTarget(UMLRT2textTransformer.Target.TUMLRT);
        try {
            boolean step2 = transformer.save(inputModel);
            if (!step2) {
                result = XTUMLRTLogger.error((String)"Unable to serialize model.", null);
            }
        }
        catch (Exception e) {
            result = XTUMLRTLogger.error((String)"Unable to serialize model.", (Throwable)e);
        }
        return result;
    }

    private EObject loadInputModel(URI uri) {
        EObject root = null;
        ResourceSet resourceSet = this.externalPackageManager.getResourceSet();
        if (resourceSet != null) {
            Resource res = resourceSet.getResource(uri, true);
            if (res != null) {
                EList contents = null;
                contents = res.getContents();
                if (!contents.isEmpty()) {
                    root = (EObject)contents.get(0);
                } else {
                    XTUMLRTLogger.info((String)("Empty model with URI: " + uri.toString()));
                }
            }
        } else {
            XTUMLRTLogger.error((String)("Unable to load model with URI: " + uri.toString()));
        }
        return root;
    }

    private IFolder getTargetFolder(IFile file) {
        IFolder srcGenFolder = null;
        IProject project = file.getProject();
        srcGenFolder = project.getFolder(".");
        if (!srcGenFolder.exists()) {
            try {
                srcGenFolder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException coreException) {
                srcGenFolder = null;
            }
        }
        return srcGenFolder;
    }
}

